/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.Nullable;

abstract class AbstractNavigableMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V> {
    @Override
    @Nullable
    public Map.Entry<K, V> firstEntry() {
        return Iterators.getNext(this.entryIterator(), null);
    }

    @Override
    @Nullable
    public Map.Entry<K, V> lastEntry() {
        return Iterators.getNext(this.descendingEntryIterator(), null);
    }

    @Override
    @Nullable
    public Map.Entry<K, V> pollFirstEntry() {
        return Iterators.pollNext(this.entryIterator());
    }

    @Override
    @Nullable
    public Map.Entry<K, V> pollLastEntry() {
        return Iterators.pollNext(this.descendingEntryIterator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K firstKey() {
        void var1_1;
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return var1_1.getKey();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K lastKey() {
        void var1_1;
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return var1_1.getKey();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Map.Entry<K, V> lowerEntry(K key) {
        void var1_1;
        return this.headMap(var1_1, false).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Map.Entry<K, V> floorEntry(K key) {
        void var1_1;
        return this.headMap(var1_1, true).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Map.Entry<K, V> ceilingEntry(K key) {
        void var1_1;
        return this.tailMap(var1_1, true).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Map.Entry<K, V> higherEntry(K key) {
        void var1_1;
        return this.tailMap(var1_1, false).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K lowerKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.lowerEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K floorKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.floorEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K ceilingKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.ceilingEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K higherKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.higherEntry(var1_1));
    }

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    abstract Iterator<Map.Entry<K, V>> descendingEntryIterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        void var2_2;
        void var1_1;
        return this.subMap(var1_1, true, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> headMap(K toKey) {
        void var1_1;
        return this.headMap(var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        void var1_1;
        return this.tailMap(var1_1, true);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new Maps.NavigableKeySet(this);
    }

    @Override
    public Set<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Maps.EntrySet<K, V>(this){
            private /* synthetic */ AbstractNavigableMap this$0;
            {
                this.this$0 = abstractNavigableMap;
            }

            @Override
            final Map<K, V> map() {
                return this.this$0;
            }

            @Override
            public final Iterator<Map.Entry<K, V>> iterator() {
                return this.this$0.entryIterator();
            }
        };
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new DescendingMap(this, 0);
    }

    final class DescendingMap
    extends Maps.DescendingMap<K, V> {
        private /* synthetic */ AbstractNavigableMap this$0;

        private DescendingMap(AbstractNavigableMap abstractNavigableMap) {
            this.this$0 = abstractNavigableMap;
        }

        @Override
        final NavigableMap<K, V> forward() {
            return this.this$0;
        }

        @Override
        final Iterator<Map.Entry<K, V>> entryIterator() {
            return this.this$0.descendingEntryIterator();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ DescendingMap(AbstractNavigableMap x0, byte by) {
            this((AbstractNavigableMap)var1_1);
            void var1_1;
        }
    }
}

