/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.AbstractMultiset;
import com.github.igorsuhorukov.google.common.collect.BoundType;
import com.github.igorsuhorukov.google.common.collect.DescendingMultiset;
import com.github.igorsuhorukov.google.common.collect.Multiset;
import com.github.igorsuhorukov.google.common.collect.Multisets;
import com.github.igorsuhorukov.google.common.collect.SortedMultiset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import javax.annotation.Nullable;

abstract class AbstractSortedMultiset<E>
extends AbstractMultiset<E>
implements SortedMultiset<E> {
    private Comparator<? super E> comparator;
    private transient SortedMultiset<E> descendingMultiset;

    @Override
    public final NavigableSet<E> elementSet() {
        return (NavigableSet)super.elementSet();
    }

    @Override
    public final Comparator<? super E> comparator() {
        return this.comparator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Multiset.Entry<E> firstEntry() {
        Iterator entryIterator = this.entryIterator();
        if (entryIterator.hasNext()) {
            void var1_1;
            return (Multiset.Entry)var1_1.next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Multiset.Entry<E> lastEntry() {
        Iterator<Multiset.Entry<E>> entryIterator = this.descendingEntryIterator();
        if (entryIterator.hasNext()) {
            void var1_1;
            return (Multiset.Entry)var1_1.next();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Multiset.Entry<E> pollFirstEntry() {
        Iterator entryIterator = this.entryIterator();
        if (entryIterator.hasNext()) {
            void var2_2;
            void var1_1;
            Multiset.Entry result = entryIterator.next();
            result = Multisets.immutableEntry(result.getElement(), result.getCount());
            var1_1.remove();
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Multiset.Entry<E> pollLastEntry() {
        Iterator<Multiset.Entry<E>> entryIterator = this.descendingEntryIterator();
        if (entryIterator.hasNext()) {
            void var2_2;
            void var1_1;
            Multiset.Entry<E> result = entryIterator.next();
            result = Multisets.immutableEntry(result.getElement(), result.getCount());
            var1_1.remove();
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SortedMultiset<E> subMultiset(@Nullable E fromElement, BoundType fromBoundType, @Nullable E toElement, BoundType toBoundType) {
        void var3_3;
        void var2_2;
        void var1_1;
        Ascii.checkNotNull(fromBoundType);
        Ascii.checkNotNull(toBoundType);
        return this.tailMultiset(var1_1, (BoundType)var2_2).headMultiset(var3_3, toBoundType);
    }

    abstract Iterator<Multiset.Entry<E>> descendingEntryIterator();

    final Iterator<E> descendingIterator() {
        return Multisets.iteratorImpl(this.descendingMultiset());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SortedMultiset<E> descendingMultiset() {
        void var1_1;
        AbstractSortedMultiset result = this.descendingMultiset;
        if (result == null) {
            result = this;
            this.descendingMultiset = new DescendingMultiset<E>(result){
                private /* synthetic */ AbstractSortedMultiset this$0;
                {
                    this.this$0 = abstractSortedMultiset;
                }

                @Override
                final SortedMultiset<E> forwardMultiset() {
                    return this.this$0;
                }

                @Override
                final Iterator<Multiset.Entry<E>> entryIterator() {
                    return this.this$0.descendingEntryIterator();
                }

                @Override
                public final Iterator<E> iterator() {
                    return this.this$0.descendingIterator();
                }
            };
            return this.descendingMultiset;
        }
        return var1_1;
    }
}

