/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.collect.Collections2;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.collect.Table;
import com.github.igorsuhorukov.google.common.collect.Tables;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    private transient Set<Table.Cell<R, C, V>> cellSet;

    AbstractTable() {
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsRow(@Nullable Object rowKey) {
        void var1_1;
        return Maps.safeContainsKey(this.rowMap(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        void var2_2;
        void var1_1;
        Map row = Maps.safeGet(this.rowMap(), rowKey);
        if (row == null) {
            return null;
        }
        return Maps.safeGet(var1_1, var2_2);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        Iterators.clear(this.cellSet().iterator());
    }

    /*
     * WARNING - void declaration
     */
    public V put(R rowKey, C columnKey, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.row(var1_1).put(var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        void var1_1;
        Set<Table.Cell<R, C, V>> result = this.cellSet;
        if (result == null) {
            this.cellSet = this.createCellSet();
            return this.cellSet;
        }
        return var1_1;
    }

    Set<Table.Cell<R, C, V>> createCellSet() {
        return new CellSet(this);
    }

    abstract Iterator<Table.Cell<R, C, V>> cellIterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object obj) {
        void var1_1;
        return Tables.equalsImpl(this, var1_1);
    }

    @Override
    public int hashCode() {
        return this.cellSet().hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    final class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        private /* synthetic */ AbstractTable this$0;

        CellSet(AbstractTable abstractTable) {
            this.this$0 = abstractTable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            if (o instanceof Table.Cell) {
                void var1_1;
                void var2_2;
                Table.Cell cell = (Table.Cell)o;
                Map row = Maps.safeGet(this.this$0.rowMap(), cell.getRowKey());
                return row != null && Collections2.safeContains(var2_2.entrySet(), Maps.immutableEntry(cell.getColumnKey(), var1_1.getValue()));
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(@Nullable Object o) {
            if (o instanceof Table.Cell) {
                void var1_1;
                void var2_2;
                Table.Cell cell = (Table.Cell)o;
                Map row = Maps.safeGet(this.this$0.rowMap(), cell.getRowKey());
                return row != null && Collections2.safeRemove(var2_2.entrySet(), Maps.immutableEntry(cell.getColumnKey(), var1_1.getValue()));
            }
            return false;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }

        @Override
        public final Iterator<Table.Cell<R, C, V>> iterator() {
            return this.this$0.cellIterator();
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }
    }
}

