/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.AbstractIndexedListIterator;
import com.github.igorsuhorukov.google.common.collect.AbstractTable;
import com.github.igorsuhorukov.google.common.collect.ArrayTable;
import com.github.igorsuhorukov.google.common.collect.ImmutableCollection;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.collect.Table;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class ArrayTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    private final ImmutableList<R> rowList;
    private final ImmutableList<C> columnList;
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final V[][] array;
    private transient ArrayTable.RowMap rowMap;

    /*
     * WARNING - void declaration
     */
    public final V at(int rowIndex, int columnIndex) {
        void var2_2;
        void var1_1;
        Ascii.checkElementIndex(rowIndex, this.rowList.size());
        Ascii.checkElementIndex(columnIndex, this.columnList.size());
        return this.array[var1_1][var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public final V set(int rowIndex, int columnIndex, @Nullable V value) {
        void var3_3;
        Ascii.checkElementIndex(rowIndex, this.rowList.size());
        Ascii.checkElementIndex(columnIndex, this.columnList.size());
        V oldValue = this.array[rowIndex][columnIndex];
        this.array[var1_1][var2_2] = var3_3;
        return oldValue;
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsRow(@Nullable Object rowKey) {
        void var1_1;
        return this.rowKeyToIndex.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        void var2_2;
        void var1_1;
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        if (rowIndex == null || columnIndex == null) {
            return null;
        }
        return this.at(var1_1.intValue(), var2_2.intValue());
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(R rowKey, C columnKey, @Nullable V value) {
        void var3_3;
        void var1_1;
        void var2_2;
        Ascii.checkNotNull(rowKey);
        Ascii.checkNotNull(columnKey);
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        Ascii.checkArgument(rowIndex != null, "Row %s not in %s", rowKey, this.rowList);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        Ascii.checkArgument(columnIndex != null, "Column %s not in %s", var2_2, this.columnList);
        return this.set(rowIndex, var1_1.intValue(), var3_3);
    }

    @Override
    public final int size() {
        return this.rowList.size() * this.columnList.size();
    }

    @Override
    public final Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    @Override
    final Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new AbstractIndexedListIterator<Table.Cell<R, C, V>>(this.size()){
            {
                void var2_2;
                super((int)var2_2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<C, V> row(R rowKey) {
        void var1_1;
        Ascii.checkNotNull(rowKey);
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        if (rowIndex == null) {
            return ImmutableMap.of();
        }
        return new Row(this, var1_1.intValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<R, Map<C, V>> rowMap() {
        void var1_1;
        ArrayTable.RowMap map = this.rowMap;
        if (map == null) {
            this.rowMap = new RowMap(this, 0);
            return this.rowMap;
        }
        return var1_1;
    }

    final class RowMap
    extends ArrayMap<R, Map<C, V>> {
        private /* synthetic */ ArrayTable this$0;

        private RowMap(ArrayTable arrayTable) {
            this.this$0 = arrayTable;
            super(arrayTable.rowKeyToIndex, (byte)0);
        }

        @Override
        final String getKeyRole() {
            return "Row";
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ RowMap(ArrayTable x0, byte by) {
            this((ArrayTable)var1_1);
            void var1_1;
        }
    }

    final class Row
    extends ArrayMap<C, V> {
        private int rowIndex;
        private /* synthetic */ ArrayTable this$0;

        /*
         * WARNING - void declaration
         */
        Row(ArrayTable arrayTable, int rowIndex) {
            void var2_2;
            this.this$0 = arrayTable;
            super(arrayTable.columnKeyToIndex, (byte)0);
            this.rowIndex = var2_2;
        }

        @Override
        final String getKeyRole() {
            return "Column";
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final V getValue(int index) {
            void var1_1;
            return this.this$0.at(this.rowIndex, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final V setValue(int index, V newValue) {
            void var2_2;
            void var1_1;
            return this.this$0.set(this.rowIndex, (int)var1_1, var2_2);
        }
    }

    static abstract class ArrayMap<K, V>
    extends Maps.ImprovedAbstractMap<K, V> {
        private final ImmutableMap<K, Integer> keyIndex;

        /*
         * WARNING - void declaration
         */
        private ArrayMap(ImmutableMap<K, Integer> keyIndex) {
            void var1_1;
            this.keyIndex = var1_1;
        }

        @Override
        public Set<K> keySet() {
            return this.keyIndex.keySet();
        }

        /*
         * WARNING - void declaration
         */
        final K getKey(int index) {
            void var1_1;
            return (K)((ImmutableCollection)((Object)this.keyIndex.keySet())).asList().get((int)var1_1);
        }

        abstract String getKeyRole();

        @Nullable
        abstract V getValue(int var1);

        @Nullable
        abstract V setValue(int var1, V var2);

        @Override
        public int size() {
            return this.keyIndex.size();
        }

        @Override
        public boolean isEmpty() {
            return this.keyIndex.isEmpty();
        }

        @Override
        protected final Set<Map.Entry<K, V>> createEntrySet() {
            return new Maps.EntrySet<K, V>(){

                @Override
                final Map<K, V> map() {
                    return ArrayMap.this;
                }

                @Override
                public final Iterator<Map.Entry<K, V>> iterator() {
                    return new AbstractIndexedListIterator<Map.Entry<K, V>>(this.size()){
                        {
                            void var2_2;
                            super((int)var2_2);
                        }
                    };
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(@Nullable Object key) {
            void var1_1;
            return this.keyIndex.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(@Nullable Object key) {
            void var1_1;
            Integer index = this.keyIndex.get(key);
            if (index == null) {
                return null;
            }
            return this.getValue(var1_1.intValue());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(K key, V value) {
            void var2_2;
            void var3_3;
            Object index = this.keyIndex.get(key);
            if (index == null) {
                String string;
                value = String.valueOf(String.valueOf(this.getKeyRole()));
                string = String.valueOf(String.valueOf(string));
                index = String.valueOf(String.valueOf(this.keyIndex.keySet()));
                throw new IllegalArgumentException(new StringBuilder(9 + ((String)value).length() + string.length() + ((String)index).length()).append((String)value).append(" ").append(string).append(" not in ").append((String)index).toString());
            }
            return this.setValue(var3_3.intValue(), var2_2);
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ArrayMap(ImmutableMap x0, byte by) {
            this((ImmutableMap<K, Integer>)var1_1);
            void var1_1;
        }
    }
}

