/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.collect.Range;
import java.io.Serializable;
import javax.annotation.Nullable;

abstract class Cut<C extends Comparable>
implements Serializable,
Comparable<Cut<C>> {
    final C endpoint = null;

    Cut(@Nullable C endpoint) {
    }

    abstract boolean isLessThan(C var1);

    abstract void describeAsLowerBound(StringBuilder var1);

    abstract void describeAsUpperBound(StringBuilder var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Cut<C> that) {
        void var1_1;
        boolean bl;
        if (that == BelowAll.INSTANCE) {
            return 1;
        }
        if (that == AboveAll.INSTANCE) {
            return -1;
        }
        int result = Range.compareOrThrow(this.endpoint, that.endpoint);
        if (result != 0) {
            return bl ? 1 : 0;
        }
        boolean bl2 = this instanceof AboveValue;
        bl = var1_1 instanceof AboveValue;
        if (bl2 == bl) {
            return 0;
        }
        if (bl2) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj instanceof Cut) {
            Cut that = (Cut)obj;
            try {
                void var1_1;
                int n = this.compareTo((Cut<C>)var1_1);
                return n == 0;
            }
            catch (ClassCastException classCastException) {}
        }
        return false;
    }

    static <C extends Comparable> Cut<C> belowAll() {
        return BelowAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> aboveAll() {
        return AboveAll.INSTANCE;
    }

    static final class AboveValue<C extends Comparable>
    extends Cut<C> {
        /*
         * WARNING - void declaration
         */
        @Override
        final boolean isLessThan(C value) {
            void var1_1;
            return Range.compareOrThrow(this.endpoint, (Comparable)var1_1) < 0;
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            sb.append('(').append(this.endpoint);
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(']');
        }

        public final int hashCode() {
            return ~this.endpoint.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.endpoint));
            return new StringBuilder(2 + string.length()).append("/").append(string).append("\\").toString();
        }
    }

    static final class AboveAll
    extends Cut<Comparable<?>> {
        private static final AboveAll INSTANCE = new AboveAll();

        private AboveAll() {
            super(null);
        }

        @Override
        final boolean isLessThan(Comparable<?> value) {
            return false;
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            sb.append("+\u221e)");
        }

        @Override
        public final int compareTo(Cut<Comparable<?>> o) {
            if (o == this) {
                return 0;
            }
            return 1;
        }

        public final String toString() {
            return "+\u221e";
        }
    }

    static final class BelowAll
    extends Cut<Comparable<?>> {
        private static final BelowAll INSTANCE = new BelowAll();

        private BelowAll() {
            super(null);
        }

        @Override
        final boolean isLessThan(Comparable<?> value) {
            return true;
        }

        @Override
        final void describeAsLowerBound(StringBuilder sb) {
            sb.append("(-\u221e");
        }

        @Override
        final void describeAsUpperBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        public final int compareTo(Cut<Comparable<?>> o) {
            if (o == this) {
                return 0;
            }
            return -1;
        }

        public final String toString() {
            return "-\u221e";
        }
    }
}

