/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.AbstractMapEntry;
import com.github.igorsuhorukov.google.common.collect.BiMap;
import com.github.igorsuhorukov.google.common.collect.Hashing;
import com.github.igorsuhorukov.google.common.collect.ImmutableEntry;
import com.github.igorsuhorukov.google.common.collect.Maps;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

public final class HashBiMap<K, V>
extends AbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient BiEntry<K, V>[] hashTableKToV;
    private transient BiEntry<K, V>[] hashTableVToK;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    private transient BiMap<V, K> inverse;

    private void delete(BiEntry<K, V> entry) {
        int keyBucket = entry.keyHash & this.mask;
        BiEntry<K, V> prevBucketEntry = null;
        BiEntry<K, V> bucketEntry = this.hashTableKToV[keyBucket];
        while (true) {
            if (bucketEntry == entry) {
                if (prevBucketEntry == null) {
                    this.hashTableKToV[keyBucket] = entry.nextInKToVBucket;
                    break;
                }
                prevBucketEntry.nextInKToVBucket = entry.nextInKToVBucket;
                break;
            }
            prevBucketEntry = bucketEntry;
            bucketEntry = bucketEntry.nextInKToVBucket;
        }
        int valueBucket = entry.valueHash & this.mask;
        prevBucketEntry = null;
        BiEntry<K, V> bucketEntry2 = this.hashTableVToK[valueBucket];
        while (true) {
            if (bucketEntry2 == entry) {
                if (prevBucketEntry == null) {
                    this.hashTableVToK[valueBucket] = entry.nextInVToKBucket;
                    break;
                }
                prevBucketEntry.nextInVToKBucket = entry.nextInVToKBucket;
                break;
            }
            prevBucketEntry = bucketEntry2;
            bucketEntry2 = bucketEntry2.nextInVToKBucket;
        }
        --this.size;
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    private void insert(BiEntry<K, V> entry) {
        void var1_1;
        int keyBucket = entry.keyHash & this.mask;
        entry.nextInKToVBucket = this.hashTableKToV[keyBucket];
        this.hashTableKToV[keyBucket] = entry;
        int valueBucket = entry.valueHash & this.mask;
        entry.nextInVToKBucket = this.hashTableVToK[valueBucket];
        this.hashTableVToK[var2_2] = var1_1;
        ++this.size;
        ++this.modCount;
    }

    private static int hash(@Nullable Object o) {
        Object object;
        return Hashing.smear(o == null ? 0 : object.hashCode());
    }

    private BiEntry<K, V> seekByKey(@Nullable Object key, int keyHash) {
        BiEntry<K, V> entry = this.hashTableKToV[keyHash & this.mask];
        while (entry != null) {
            if (keyHash == entry.keyHash && Ascii.equal(key, entry.key)) {
                return entry;
            }
            entry = entry.nextInKToVBucket;
        }
        return null;
    }

    private BiEntry<K, V> seekByValue(@Nullable Object value, int valueHash) {
        BiEntry<K, V> entry = this.hashTableVToK[valueHash & this.mask];
        while (entry != null) {
            if (valueHash == entry.valueHash && Ascii.equal(value, entry.value)) {
                return entry;
            }
            entry = entry.nextInVToKBucket;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(@Nullable Object key) {
        void var1_1;
        return this.seekByKey(key, HashBiMap.hash(var1_1)) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsValue(@Nullable Object value) {
        void var1_1;
        return this.seekByValue(value, HashBiMap.hash(var1_1)) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public final V get(@Nullable Object key) {
        void var1_1;
        BiEntry<K, V> entry = this.seekByKey(key, HashBiMap.hash(key));
        if (entry == null) {
            return null;
        }
        return (V)var1_1.value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(@Nullable K key, @Nullable V value) {
        void var1_1;
        Object object;
        boolean bl = false;
        void var3_5 = object;
        object = var1_1;
        HashBiMap hashBiMap = this;
        int n = HashBiMap.hash(object);
        int n2 = HashBiMap.hash(var3_5);
        BiEntry<K, V> biEntry = hashBiMap.seekByKey(object, n);
        if (biEntry != null && n2 == biEntry.valueHash && Ascii.equal(var3_5, biEntry.value)) {
            return var3_5;
        }
        BiEntry<K, V> biEntry2 = hashBiMap.seekByValue(var3_5, n2);
        if (biEntry2 != null) {
            object = String.valueOf(String.valueOf(var3_5));
            throw new IllegalArgumentException(new StringBuilder(23 + ((String)object).length()).append("value already present: ").append((String)object).toString());
        }
        if (biEntry != null) {
            hashBiMap.delete(biEntry);
        }
        object = new BiEntry<void, void>((void)object, n, var3_5, n2);
        hashBiMap.insert((BiEntry<K, V>)object);
        hashBiMap.rehashIfNecessary();
        if (biEntry == null) {
            return null;
        }
        return (V)biEntry.value;
    }

    private void rehashIfNecessary() {
        BiEntry<K, V>[] oldKToV = this.hashTableKToV;
        if (Hashing.needsResizing(this.size, oldKToV.length, 1.0)) {
            int newTableSize;
            int n = newTableSize = oldKToV.length << 1;
            this.hashTableKToV = new BiEntry[n];
            n = newTableSize;
            this.hashTableVToK = new BiEntry[n];
            this.mask = newTableSize - 1;
            this.size = 0;
            for (int bucket = 0; bucket < oldKToV.length; ++bucket) {
                BiEntry<K, V> entry = oldKToV[bucket];
                while (entry != null) {
                    BiEntry nextEntry = entry.nextInKToVBucket;
                    this.insert(entry);
                    entry = nextEntry;
                }
            }
            ++this.modCount;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V remove(@Nullable Object key) {
        void var1_1;
        BiEntry<K, V> entry = this.seekByKey(key, HashBiMap.hash(key));
        if (entry == null) {
            return null;
        }
        this.delete(entry);
        return (V)var1_1.value;
    }

    @Override
    public final void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        ++this.modCount;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet(0);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(HashBiMap x0, BiEntry x1) {
        void var1_1;
        x0.delete((BiEntry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BiEntry access$400(HashBiMap x0, Object x1, int x2) {
        void var2_2;
        void var1_1;
        return x0.seekByKey(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BiEntry access$600(HashBiMap x0, Object x1, int x2) {
        void var2_2;
        void var1_1;
        return x0.seekByValue(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(HashBiMap x0, BiEntry x1) {
        void var1_1;
        x0.insert((BiEntry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$1000(HashBiMap x0, Object x1, Object x2, boolean x3) {
        void var2_2;
        Object object;
        boolean bl = false;
        HashBiMap hashBiMap = x0;
        int n = HashBiMap.hash(object);
        int n2 = HashBiMap.hash(var2_2);
        BiEntry biEntry = hashBiMap.seekByValue(object, n);
        if (biEntry != null && n2 == biEntry.keyHash && Ascii.equal(var2_2, biEntry.key)) {
            return var2_2;
        }
        BiEntry biEntry2 = hashBiMap.seekByKey(var2_2, n2);
        if (biEntry2 != null) {
            if (bl) {
                hashBiMap.delete(biEntry2);
            } else {
                object = String.valueOf(String.valueOf(var2_2));
                throw new IllegalArgumentException(new StringBuilder(23 + ((String)object).length()).append("value already present: ").append((String)object).toString());
            }
        }
        if (biEntry != null) {
            hashBiMap.delete(biEntry);
        }
        object = new BiEntry<void, void>(var2_2, n2, (void)object, n);
        hashBiMap.insert((BiEntry)object);
        hashBiMap.rehashIfNecessary();
        if (biEntry == null) {
            return null;
        }
        return biEntry.key;
    }

    final class Inverse
    extends AbstractMap<V, K>
    implements BiMap<V, K>,
    Serializable {
        private Inverse() {
        }

        @Override
        public final int size() {
            return HashBiMap.this.size;
        }

        @Override
        public final void clear() {
            Inverse inverse = this;
            inverse.HashBiMap.this.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(@Nullable Object value) {
            void var1_1;
            Inverse inverse = this;
            return inverse.HashBiMap.this.containsValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K get(@Nullable Object value) {
            void var1_1;
            BiEntry entry = HashBiMap.access$600(HashBiMap.this, value, HashBiMap.hash(value));
            if (entry == null) {
                return null;
            }
            return var1_1.key;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K put(@Nullable V value, @Nullable K key) {
            void var2_2;
            void var1_1;
            return HashBiMap.access$1000(HashBiMap.this, var1_1, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K remove(@Nullable Object value) {
            void var1_1;
            BiEntry entry = HashBiMap.access$600(HashBiMap.this, value, HashBiMap.hash(value));
            if (entry == null) {
                return null;
            }
            HashBiMap.access$200(HashBiMap.this, entry);
            return var1_1.key;
        }

        @Override
        public final Set<V> keySet() {
            return new InverseKeySet();
        }

        @Override
        public final Set<Map.Entry<V, K>> entrySet() {
            return new Maps.EntrySet<V, K>(){

                @Override
                final Map<V, K> map() {
                    return Inverse.this;
                }

                @Override
                public final Iterator<Map.Entry<V, K>> iterator() {
                    return new Itr(){

                        final class InverseEntry
                        extends AbstractMapEntry<V, K> {
                            private BiEntry<K, V> delegate;
                            private /* synthetic */ 1 this$3;

                            /*
                             * WARNING - void declaration
                             */
                            InverseEntry(1 var1_1, BiEntry<K, V> entry) {
                                void var2_2;
                                this.this$3 = var1_1;
                                this.delegate = var2_2;
                            }

                            @Override
                            public final V getKey() {
                                return this.delegate.value;
                            }

                            @Override
                            public final K getValue() {
                                return this.delegate.key;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public final K setValue(K key) {
                                void var2_2;
                                void var1_1;
                                void var3_3;
                                Object oldKey = this.delegate.key;
                                int keyHash = HashBiMap.hash(key);
                                if (keyHash == this.delegate.keyHash && Ascii.equal(key, oldKey)) {
                                    return key;
                                }
                                Ascii.checkArgument(HashBiMap.access$400(this.this$3.HashBiMap.this, key, keyHash) == null, "value already present: %s", key);
                                HashBiMap.access$200(this.this$3.HashBiMap.this, this.delegate);
                                BiEntry newEntry = new BiEntry(key, (int)var3_3, this.delegate.value, this.delegate.valueHash);
                                HashBiMap.access$700(this.this$3.HashBiMap.this, (BiEntry)var1_1);
                                this.this$3.expectedModCount = this.this$3.HashBiMap.this.modCount;
                                return var2_2;
                            }
                        }
                    };
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Inverse(byte by) {
            this();
            void var1_1;
        }

        final class InverseKeySet
        extends Maps.KeySet<V, K> {
            InverseKeySet() {
                super(Inverse.this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean remove(@Nullable Object o) {
                void var1_1;
                BiEntry entry = HashBiMap.access$600(HashBiMap.this, o, HashBiMap.hash(o));
                if (entry == null) {
                    return false;
                }
                HashBiMap.access$200(HashBiMap.this, (BiEntry)var1_1);
                return true;
            }

            @Override
            public final Iterator<V> iterator() {
                return new Itr(this){

                    final V output(BiEntry<K, V> entry) {
                        return entry.value;
                    }
                };
            }
        }
    }

    final class EntrySet
    extends Maps.EntrySet<K, V> {
        private EntrySet() {
        }

        @Override
        final Map<K, V> map() {
            return HashBiMap.this;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new Itr(){

                final class MapEntry
                extends AbstractMapEntry<K, V> {
                    private BiEntry<K, V> delegate;
                    private /* synthetic */ 1 this$2;

                    /*
                     * WARNING - void declaration
                     */
                    MapEntry(1 var1_1, BiEntry<K, V> entry) {
                        void var2_2;
                        this.this$2 = var1_1;
                        this.delegate = var2_2;
                    }

                    @Override
                    public final K getKey() {
                        return this.delegate.key;
                    }

                    @Override
                    public final V getValue() {
                        return this.delegate.value;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final V setValue(V value) {
                        void var2_2;
                        void var1_1;
                        void var3_3;
                        Object oldValue = this.delegate.value;
                        int valueHash = HashBiMap.hash(value);
                        if (valueHash == this.delegate.valueHash && Ascii.equal(value, oldValue)) {
                            return value;
                        }
                        Ascii.checkArgument(HashBiMap.access$600(this.this$2.HashBiMap.this, value, valueHash) == null, "value already present: %s", value);
                        HashBiMap.access$200(this.this$2.HashBiMap.this, this.delegate);
                        BiEntry newEntry = new BiEntry(this.delegate.key, this.delegate.keyHash, value, (int)var3_3);
                        HashBiMap.access$700(this.this$2.HashBiMap.this, newEntry);
                        this.this$2.expectedModCount = this.this$2.HashBiMap.this.modCount;
                        if (this.this$2.toRemove == this.delegate) {
                            this.this$2.toRemove = newEntry;
                        }
                        this.delegate = var1_1;
                        return var2_2;
                    }
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntrySet(byte by) {
            this();
            void var1_1;
        }
    }

    final class KeySet
    extends Maps.KeySet<K, V> {
        KeySet() {
            super(HashBiMap.this);
        }

        @Override
        public final Iterator<K> iterator() {
            return new Itr(this){

                final K output(BiEntry<K, V> entry) {
                    return entry.key;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(@Nullable Object o) {
            void var1_1;
            BiEntry entry = HashBiMap.access$400(HashBiMap.this, o, HashBiMap.hash(o));
            if (entry == null) {
                return false;
            }
            HashBiMap.access$200(HashBiMap.this, (BiEntry)var1_1);
            return true;
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        private int nextBucket = 0;
        private BiEntry<K, V> next = null;
        BiEntry<K, V> toRemove = null;
        int expectedModCount = HashBiMap.access$000(this.this$0);
        private /* synthetic */ HashBiMap this$0;

        Itr(HashBiMap hashBiMap) {
            this.this$0 = hashBiMap;
        }

        private void checkForConcurrentModification() {
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            if (this.next != null) {
                return true;
            }
            while (this.nextBucket < this.this$0.hashTableKToV.length) {
                if (this.this$0.hashTableKToV[this.nextBucket] != null) {
                    this.next = this.this$0.hashTableKToV[this.nextBucket++];
                    return true;
                }
                ++this.nextBucket;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            void var1_1;
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiEntry entry = this.next;
            this.next = entry.nextInKToVBucket;
            this.toRemove = entry;
            return this.output((BiEntry)var1_1);
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            boolean bl = this.toRemove != null;
            Ascii.checkState(bl, "no calls to next() since the last call to remove()");
            HashBiMap.access$200(this.this$0, this.toRemove);
            this.expectedModCount = this.this$0.modCount;
            this.toRemove = null;
        }

        abstract T output(BiEntry<K, V> var1);
    }

    static final class BiEntry<K, V>
    extends ImmutableEntry<K, V> {
        final int keyHash;
        final int valueHash;
        @Nullable
        BiEntry<K, V> nextInKToVBucket;
        @Nullable
        BiEntry<K, V> nextInVToKBucket;

        /*
         * WARNING - void declaration
         */
        BiEntry(K key, int keyHash, V value, int valueHash) {
            super(var1_1, var3_3);
            void var2_2;
            void var3_3;
            void var1_1;
            this.keyHash = var2_2;
            this.valueHash = valueHash;
        }
    }
}

