/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.AbstractBiMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.ObjectArrays;
import com.github.igorsuhorukov.google.common.collect.RegularImmutableAsList;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    private transient ImmutableList<E> asList;

    ImmutableCollection() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object[] toArray() {
        void var1_2;
        int size = this.size();
        if (size == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        Object[] result = new Object[size];
        this.copyIntoArray(result, 0);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] other) {
        void var1_1;
        Ascii.checkNotNull(other);
        int size = this.size();
        if (other.length < size) {
            other = ObjectArrays.newArray(other, size);
        } else if (other.length > size) {
            other[var2_2] = null;
        }
        this.copyIntoArray(other, 0);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(@Nullable Object object) {
        void var1_1;
        return object != null && super.contains(var1_1);
    }

    @Override
    @Deprecated
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean addAll(Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeAll(Collection<?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection<?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public ImmutableList<E> asList() {
        void var1_1;
        ImmutableList<E> list = this.asList;
        if (list == null) {
            this.asList = this.createAsList();
            return this.asList;
        }
        return var1_1;
    }

    ImmutableList<E> createAsList() {
        switch (this.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(this.iterator().next());
            }
        }
        return new RegularImmutableAsList(this, this.toArray());
    }

    abstract boolean isPartialView();

    /*
     * WARNING - void declaration
     */
    int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        for (Object e : this) {
            dst[offset++] = e;
        }
        return (int)var2_2;
    }

    static abstract class ArrayBasedBuilder<E>
    extends Builder<E> {
        Object[] contents;
        int size;

        /*
         * WARNING - void declaration
         */
        ArrayBasedBuilder(int initialCapacity) {
            void var1_1;
            AbstractBiMap.1.checkNonnegative(initialCapacity, "initialCapacity");
            this.contents = new Object[var1_1];
            this.size = 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ArrayBasedBuilder<E> add(E element) {
            void var1_1;
            Ascii.checkNotNull(element);
            int n = this.size + 1;
            ArrayBasedBuilder arrayBasedBuilder = this;
            if (arrayBasedBuilder.contents.length < n) {
                arrayBasedBuilder.contents = ObjectArrays.arraysCopyOf(arrayBasedBuilder.contents, ArrayBasedBuilder.expandedCapacity(arrayBasedBuilder.contents.length, n));
            }
            this.contents[this.size++] = var1_1;
            return this;
        }
    }

    public static abstract class Builder<E> {
        /*
         * WARNING - void declaration
         */
        static int expandedCapacity(int oldCapacity, int minCapacity) {
            int n;
            if (minCapacity < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int newCapacity = oldCapacity + (oldCapacity >> 1) + 1;
            if (newCapacity < minCapacity) {
                void var1_1;
                newCapacity = Integer.highestOneBit((int)(var1_1 - true)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return n;
        }

        Builder() {
        }

        public abstract Builder<E> add(E var1);

        public Builder<E> addAll(Iterator<? extends E> elements) {
            while (elements.hasNext()) {
                this.add(elements.next());
            }
            return this;
        }
    }
}

