/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.ImmutableBiMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableMapEntrySet;
import com.github.igorsuhorukov.google.common.collect.ImmutableSet;
import com.github.igorsuhorukov.google.common.collect.Iterables;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

final class ImmutableEnumMap<K extends Enum<K>, V>
extends ImmutableMap<K, V> {
    private final transient EnumMap<K, V> delegate;

    static <K extends Enum<K>, V> ImmutableMap<K, V> asImmutable(EnumMap<K, V> map) {
        Map.Entry<K, V> entry;
        switch (map.size()) {
            case 0: {
                return ImmutableBiMap.of();
            }
            case 1: {
                Map.Entry<K, V> entry2 = Iterables.getOnlyElement(map.entrySet());
                Object v = entry.getValue();
                entry = entry2.getKey();
                return ImmutableBiMap.of(entry, v);
            }
        }
        return new ImmutableEnumMap<K, V>(entry);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableEnumMap(EnumMap<K, V> delegate) {
        void var1_1;
        this.delegate = delegate;
        Ascii.checkArgument(!var1_1.isEmpty());
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        return new ImmutableSet<K>(this){
            private /* synthetic */ ImmutableEnumMap this$0;
            {
                this.this$0 = immutableEnumMap;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean contains(Object object) {
                void var1_1;
                return this.this$0.delegate.containsKey(var1_1);
            }

            @Override
            public final int size() {
                return this.this$0.size();
            }

            @Override
            public final UnmodifiableIterator<K> iterator() {
                return Iterators.unmodifiableIterator(this.this$0.delegate.keySet().iterator());
            }

            @Override
            final boolean isPartialView() {
                return true;
            }
        };
    }

    @Override
    public final int size() {
        return this.delegate.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(@Nullable Object key) {
        void var1_1;
        return this.delegate.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var1_1;
        return this.delegate.get(var1_1);
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet<K, V>(){

            @Override
            final ImmutableMap<K, V> map() {
                return ImmutableEnumMap.this;
            }

            @Override
            public final UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                return new UnmodifiableIterator<Map.Entry<K, V>>(this){
                    private final Iterator<Map.Entry<K, V>> backingIterator;
                    private /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                        this.backingIterator = this.this$1.ImmutableEnumMap.this.delegate.entrySet().iterator();
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.backingIterator.hasNext();
                    }
                };
            }
        };
    }

    @Override
    final boolean isPartialView() {
        return false;
    }
}

