/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.collect.AbstractBiMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableAsList;
import com.github.igorsuhorukov.google.common.collect.ImmutableCollection;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableSet;
import com.github.igorsuhorukov.google.common.collect.Multiset;
import com.github.igorsuhorukov.google.common.collect.Multisets;
import com.github.igorsuhorukov.google.common.collect.RegularImmutableMultiset;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

public abstract class ImmutableMultiset<E>
extends ImmutableCollection<E>
implements Multiset<E> {
    private transient ImmutableSet<Multiset.Entry<E>> entrySet;

    ImmutableMultiset() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnmodifiableIterator<E> iterator() {
        void var1_1;
        Iterator entryIterator = ((ImmutableSet)this.entrySet()).iterator();
        return new UnmodifiableIterator<E>(this, (Iterator)var1_1){
            private int remaining;
            private E element;
            private /* synthetic */ Iterator val$entryIterator;
            {
                this.val$entryIterator = iterator;
            }

            @Override
            public final boolean hasNext() {
                return this.remaining > 0 || this.val$entryIterator.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final E next() {
                if (this.remaining <= 0) {
                    void var1_1;
                    Multiset.Entry entry = (Multiset.Entry)this.val$entryIterator.next();
                    this.element = entry.getElement();
                    this.remaining = var1_1.getCount();
                }
                --this.remaining;
                return this.element;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(@Nullable Object object) {
        void var1_1;
        return this.count(var1_1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(Collection<?> targets) {
        void var1_1;
        return this.elementSet().containsAll((Collection<?>)var1_1);
    }

    @Override
    @Deprecated
    public final int add(E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int setCount(E element, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean setCount(E element, int oldCount, int newCount) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        for (Multiset.Entry entry : this.entrySet()) {
            Arrays.fill(dst, offset, offset + entry.getCount(), entry.getElement());
            offset += entry.getCount();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object object) {
        void var1_1;
        return Multisets.equalsImpl(this, var1_1);
    }

    @Override
    public int hashCode() {
        return AbstractBiMap.1.hashCodeImpl(this.entrySet());
    }

    @Override
    public String toString() {
        return ((AbstractCollection)((Object)this.entrySet())).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSet<Multiset.Entry<E>> entrySet() {
        void var1_1;
        ImmutableCollection es = this.entrySet;
        if (es == null) {
            es = this;
            this.entrySet = es.isEmpty() ? ImmutableSet.of() : (ImmutableMultiset)es.new EntrySet(0);
            return this.entrySet;
        }
        return var1_1;
    }

    abstract Multiset.Entry<E> getEntry(int var1);

    static {
        new RegularImmutableMultiset(ImmutableMap.of(), 0);
    }

    final class EntrySet
    extends ImmutableSet<Multiset.Entry<E>> {
        private EntrySet() {
        }

        @Override
        final boolean isPartialView() {
            return ImmutableMultiset.this.isPartialView();
        }

        @Override
        public final UnmodifiableIterator<Multiset.Entry<E>> iterator() {
            return this.asList().iterator();
        }

        @Override
        final ImmutableList<Multiset.Entry<E>> createAsList() {
            return new ImmutableAsList<Multiset.Entry<E>>(this){
                private /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = entrySet;
                }

                @Override
                final ImmutableCollection<Multiset.Entry<E>> delegateCollection() {
                    return this.this$1;
                }
            };
        }

        @Override
        public final int size() {
            return ImmutableMultiset.this.elementSet().size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            if (o instanceof Multiset.Entry) {
                void var1_1;
                Multiset.Entry entry = (Multiset.Entry)o;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int n = ImmutableMultiset.this.count(entry.getElement());
                return n == var1_1.getCount();
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return ImmutableMultiset.this.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntrySet(byte by) {
            this();
            void var1_1;
        }
    }
}

