/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.DescendingImmutableSortedSet;
import com.github.igorsuhorukov.google.common.collect.EmptyImmutableSortedSet;
import com.github.igorsuhorukov.google.common.collect.ImmutableSortedSetFauxverideShim;
import com.github.igorsuhorukov.google.common.collect.Iterables;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Ordering;
import com.github.igorsuhorukov.google.common.collect.SortedIterable;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import java.util.Comparator;
import java.util.NavigableSet;

public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedIterable<E>,
NavigableSet<E> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new EmptyImmutableSortedSet<Comparable>(NATURAL_ORDER);
    final transient Comparator<? super E> comparator;
    private transient ImmutableSortedSet<E> descendingSet;

    static <E> ImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        Comparator<? super E> comparator2;
        if (NATURAL_ORDER.equals(comparator)) {
            return NATURAL_EMPTY_SET;
        }
        return new EmptyImmutableSortedSet<E>(comparator2);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSortedSet(Comparator<? super E> comparator) {
        void var1_1;
        this.comparator = var1_1;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> headSet(E toElement) {
        void var1_1;
        return this.headSet((Object)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.headSetImpl(Ascii.checkNotNull(var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        void var2_2;
        void var1_1;
        return this.subSet((Object)var1_1, true, (Object)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        Ascii.checkNotNull(fromElement);
        Ascii.checkNotNull(toElement);
        Ascii.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(var1_1, (boolean)var2_2, var3_3, toInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement) {
        void var1_1;
        return this.tailSet((Object)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.tailSetImpl(Ascii.checkNotNull(var1_1), (boolean)var2_2);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public E lower(E e) {
        void var1_1;
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)var1_1, false)).descendingIterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E floor(E e) {
        void var1_1;
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)var1_1, true)).descendingIterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E ceiling(E e) {
        void var1_1;
        return Iterables.getFirst(this.tailSet((Object)var1_1, true), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E higher(E e) {
        void var1_1;
        return Iterables.getFirst(this.tailSet((Object)var1_1, false), null);
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> descendingSet() {
        void var1_1;
        ImmutableSortedSet<E> result = this.descendingSet;
        if (result == null) {
            result = this.descendingSet = this.createDescendingSet();
            this.descendingSet.descendingSet = this;
        }
        return var1_1;
    }

    ImmutableSortedSet<E> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> descendingIterator();
}

