/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.base.Optional;
import com.github.igorsuhorukov.google.common.base.Predicate;
import com.github.igorsuhorukov.google.common.base.Predicates;
import com.github.igorsuhorukov.google.common.collect.AbstractIndexedListIterator;
import com.github.igorsuhorukov.google.common.collect.AbstractIterator;
import com.github.igorsuhorukov.google.common.collect.Collections2;
import com.github.igorsuhorukov.google.common.collect.PeekingIterator;
import com.github.igorsuhorukov.google.common.collect.TransformedIterator;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.annotation.Nullable;

public final class Iterators {
    private static UnmodifiableListIterator<Object> EMPTY_LIST_ITERATOR = new UnmodifiableListIterator<Object>(){

        @Override
        public final boolean hasNext() {
            return false;
        }

        @Override
        public final Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public final boolean hasPrevious() {
            return false;
        }

        @Override
        public final Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public final int nextIndex() {
            return 0;
        }

        @Override
        public final int previousIndex() {
            return -1;
        }
    };
    private static final Iterator<Object> EMPTY_MODIFIABLE_ITERATOR = new Iterator<Object>(){

        @Override
        public final boolean hasNext() {
            return false;
        }

        @Override
        public final Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            boolean bl = false;
            Ascii.checkState(false, "no calls to next() since the last call to remove()");
        }
    };

    @Deprecated
    public static <T> UnmodifiableIterator<T> emptyIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    static <T> Iterator<T> emptyModifiableIterator() {
        return EMPTY_MODIFIABLE_ITERATOR;
    }

    public static <T> UnmodifiableIterator<T> unmodifiableIterator(Iterator<T> iterator) {
        Iterator<T> iterator2;
        Ascii.checkNotNull(iterator);
        if (iterator instanceof UnmodifiableIterator) {
            return (UnmodifiableIterator)iterator;
        }
        return new UnmodifiableIterator<T>(iterator2){
            private /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$iterator.hasNext();
            }

            @Override
            public final T next() {
                return this.val$iterator.next();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static int size(Iterator<?> iterator) {
        void var1_1;
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(Iterator<?> iterator, @Nullable Object element) {
        void var1_1;
        return Iterators.any(iterator, Predicates.equalTo(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean removeAll(Iterator<?> removeFrom, Collection<?> elementsToRemove) {
        void var1_1;
        return Iterators.removeIf(removeFrom, Predicates.in(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean removeIf(Iterator<T> removeFrom, Predicate<? super T> predicate) {
        void var2_2;
        Ascii.checkNotNull(predicate);
        boolean modified = false;
        while (removeFrom.hasNext()) {
            if (!predicate.apply(removeFrom.next())) continue;
            removeFrom.remove();
            modified = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean retainAll(Iterator<?> removeFrom, Collection<?> elementsToRetain) {
        void var1_1;
        return Iterators.removeIf(removeFrom, Predicates.not(Predicates.in(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        void var1_1;
        while (iterator1.hasNext()) {
            void var3_3;
            void var2_2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            Object o2 = iterator2.next();
            if (Ascii.equal(var2_2, var3_3)) continue;
            return false;
        }
        return !var1_1.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        Iterator<?> iterator2;
        return Collections2.STANDARD_JOINER$7418a432.appendTo(new StringBuilder("["), iterator2).append(']').toString();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getOnlyElement(Iterator<T> iterator) {
        void var2_3;
        Iterator<T> iterator2;
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return (T)first;
        }
        StringBuilder sb = new StringBuilder();
        first = String.valueOf(String.valueOf(first));
        sb.append(new StringBuilder(31 + ((String)first).length()).append("expected one element but was: <").append((String)first).toString());
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            String string = String.valueOf(String.valueOf(iterator.next()));
            sb.append(new StringBuilder(2 + string.length()).append(", ").append(string).toString());
        }
        if (iterator2.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(var2_3.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T getOnlyElement(Iterator<? extends T> iterator, @Nullable T defaultValue) {
        void var1_1;
        if (iterator.hasNext()) {
            Iterator<? extends T> iterator2;
            return Iterators.getOnlyElement(iterator2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        void var2_2;
        Ascii.checkNotNull(addTo);
        Ascii.checkNotNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int frequency(Iterator<?> iterator, @Nullable Object element) {
        void var1_1;
        return Iterators.size(Iterators.filter(iterator, Predicates.equalTo(var1_1)));
    }

    public static <T> Iterator<T> cycle(Iterable<T> iterable) {
        Iterable<T> iterable2;
        Ascii.checkNotNull(iterable);
        return new Iterator<T>(iterable2){
            private Iterator<T> iterator = Iterators.emptyIterator();
            private Iterator<T> removeFrom;
            private /* synthetic */ Iterable val$iterable;
            {
                this.val$iterable = iterable;
            }

            @Override
            public final boolean hasNext() {
                if (!this.iterator.hasNext()) {
                    this.iterator = this.val$iterable.iterator();
                }
                return this.iterator.hasNext();
            }

            @Override
            public final T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeFrom = this.iterator;
                return this.iterator.next();
            }

            @Override
            public final void remove() {
                boolean bl = this.removeFrom != null;
                Ascii.checkState(bl, "no calls to next() since the last call to remove()");
                this.removeFrom.remove();
                this.removeFrom = null;
            }
        };
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> inputs) {
        Iterator<? extends Iterator<? extends T>> iterator;
        Ascii.checkNotNull(inputs);
        return new Iterator<T>(iterator){
            private Iterator<? extends T> current = Iterators.emptyIterator();
            private Iterator<? extends T> removeFrom;
            private /* synthetic */ Iterator val$inputs;
            {
                this.val$inputs = iterator;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean hasNext() {
                void var1_1;
                boolean currentHasNext;
                while (!(currentHasNext = Ascii.checkNotNull(this.current).hasNext()) && this.val$inputs.hasNext()) {
                    this.current = (Iterator)this.val$inputs.next();
                }
                return (boolean)var1_1;
            }

            @Override
            public final T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeFrom = this.current;
                return this.current.next();
            }

            @Override
            public final void remove() {
                boolean bl = this.removeFrom != null;
                Ascii.checkState(bl, "no calls to next() since the last call to remove()");
                this.removeFrom.remove();
                this.removeFrom = null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<List<T>> partition(Iterator<T> iterator, int size) {
        void var1_1;
        return Iterators.partitionImpl(iterator, (int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<List<T>> paddedPartition(Iterator<T> iterator, int size) {
        void var1_1;
        return Iterators.partitionImpl(iterator, (int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> UnmodifiableIterator<List<T>> partitionImpl(Iterator<T> iterator, int size, boolean pad) {
        void var2_2;
        void var1_1;
        Iterator<T> iterator2;
        Ascii.checkNotNull(iterator);
        Ascii.checkArgument(size > 0);
        return new UnmodifiableIterator<List<T>>(iterator2, (int)var1_1, (boolean)var2_2){
            private /* synthetic */ Iterator val$iterator;
            private /* synthetic */ int val$size;
            private /* synthetic */ boolean val$pad;
            {
                this.val$iterator = iterator;
                this.val$size = n;
                this.val$pad = bl;
            }

            @Override
            public final boolean hasNext() {
                return this.val$iterator.hasNext();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<T> filter(Iterator<T> unfiltered, Predicate<? super T> predicate) {
        void var1_1;
        Iterator<T> iterator;
        Ascii.checkNotNull(unfiltered);
        Ascii.checkNotNull(predicate);
        return new AbstractIterator<T>(iterator, (Predicate)var1_1){
            private /* synthetic */ Iterator val$unfiltered;
            private /* synthetic */ Predicate val$predicate;
            {
                this.val$unfiltered = iterator;
                this.val$predicate = predicate;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final T computeNext() {
                while (this.val$unfiltered.hasNext()) {
                    void var1_1;
                    Object element = this.val$unfiltered.next();
                    if (!this.val$predicate.apply(element)) continue;
                    return var1_1;
                }
                return this.endOfData();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<T> filter(Iterator<?> unfiltered, Class<T> type) {
        void var1_1;
        return Iterators.filter(unfiltered, Predicates.instanceOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean any(Iterator<T> iterator, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.indexOf(iterator, var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean all(Iterator<T> iterator, Predicate<? super T> predicate) {
        Ascii.checkNotNull(predicate);
        while (iterator.hasNext()) {
            void var2_2;
            T element = iterator.next();
            if (predicate.apply(var2_2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T find(Iterator<T> iterator, Predicate<? super T> predicate) {
        void var1_1;
        return (T)Iterators.filter(iterator, var1_1).next();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T find(Iterator<? extends T> iterator, Predicate<? super T> predicate, @Nullable T defaultValue) {
        void var2_2;
        void var1_1;
        return Iterators.getNext(Iterators.filter(iterator, var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Optional<T> tryFind(Iterator<T> iterator, Predicate<? super T> predicate) {
        void var1_1;
        Iterator<T> filteredIterator = Iterators.filter(iterator, var1_1);
        if (filteredIterator.hasNext()) {
            Iterator<T> iterator2;
            return Optional.of(iterator2.next());
        }
        return Optional.absent();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int indexOf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Ascii.checkNotNull(predicate, "predicate");
        int i = 0;
        while (iterator.hasNext()) {
            void var3_3;
            T current = iterator.next();
            if (predicate.apply(var3_3)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Iterator<T> transform(Iterator<F> fromIterator, Function<? super F, ? extends T> function) {
        void var1_1;
        Iterator<F> iterator;
        Ascii.checkNotNull(function);
        return new TransformedIterator<F, T>(iterator, (Function)var1_1){
            private /* synthetic */ Function val$function;
            {
                void var1_1;
                this.val$function = function;
                super(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final T transform(F from) {
                void var1_1;
                return this.val$function.apply(var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(Iterator<T> iterator3, int position) {
        Iterator<T> iterator2;
        Iterators.checkNonnegative(position);
        int skipped = Iterators.advance(iterator3, position);
        if (!iterator3.hasNext()) {
            void var2_3;
            void var1_2;
            void iterator3 = var1_2;
            var1_2 = var2_3;
            throw new IndexOutOfBoundsException(new StringBuilder(91).append("position (").append((int)iterator3).append(") must be less than the number of elements that remained (").append((int)var1_2).append(")").toString());
        }
        return iterator2.next();
    }

    static void checkNonnegative(int position) {
        if (position < 0) {
            int n;
            throw new IndexOutOfBoundsException(new StringBuilder(43).append("position (").append(n).append(") must not be negative").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T getNext(Iterator<? extends T> iterator, @Nullable T defaultValue) {
        void var1_1;
        if (iterator.hasNext()) {
            Iterator<T> iterator2;
            return iterator2.next();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getLast(Iterator<T> iterator) {
        void var1_1;
        do {
            T current = iterator.next();
        } while (iterator.hasNext());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T getLast(Iterator<? extends T> iterator, @Nullable T defaultValue) {
        void var1_1;
        if (iterator.hasNext()) {
            Iterator<? extends T> iterator2;
            return Iterators.getLast(iterator2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int advance(Iterator<?> iterator, int numberToAdvance) {
        void var2_2;
        Ascii.checkNotNull(iterator);
        Ascii.checkArgument(numberToAdvance >= 0, "numberToAdvance must be nonnegative");
        for (int i = 0; i < numberToAdvance && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterator<T> limit(Iterator<T> iterator, int limitSize) {
        Iterator<T> iterator2;
        void var1_1;
        Ascii.checkNotNull(iterator);
        Ascii.checkArgument(limitSize >= 0, "limit is negative");
        return new Iterator<T>((int)var1_1, iterator2){
            private int count;
            private /* synthetic */ int val$limitSize;
            private /* synthetic */ Iterator val$iterator;
            {
                this.val$limitSize = n;
                this.val$iterator = iterator;
            }

            @Override
            public final boolean hasNext() {
                return this.count < this.val$limitSize && this.val$iterator.hasNext();
            }

            @Override
            public final T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return this.val$iterator.next();
            }

            @Override
            public final void remove() {
                this.val$iterator.remove();
            }
        };
    }

    public static <T> Iterator<T> consumingIterator(Iterator<T> iterator) {
        Iterator<T> iterator2;
        Ascii.checkNotNull(iterator);
        return new UnmodifiableIterator<T>(iterator2){
            private /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$iterator.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final T next() {
                void var1_1;
                Object next = this.val$iterator.next();
                this.val$iterator.remove();
                return var1_1;
            }

            public final String toString() {
                return "Iterators.consumingIterator(...)";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static <T> T pollNext(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            void var1_1;
            Iterator<T> iterator2;
            T result = iterator.next();
            iterator2.remove();
            return var1_1;
        }
        return null;
    }

    static void clear(Iterator<?> iterator) {
        Ascii.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    static <T> UnmodifiableListIterator<T> forArray(T[] array, int offset, int length, int index) {
        void var1_1;
        T[] TArray;
        void var3_3;
        void var2_2;
        Ascii.checkArgument(length >= 0);
        int end = offset + length;
        Ascii.checkPositionIndexes(offset, end, array.length);
        Ascii.checkPositionIndex(index, length);
        if (length == 0) {
            return EMPTY_LIST_ITERATOR;
        }
        return new AbstractIndexedListIterator<T>((int)var2_2, (int)var3_3, TArray, (int)var1_1){
            private /* synthetic */ Object[] val$array;
            private /* synthetic */ int val$offset;
            {
                void var2_2;
                void var1_1;
                this.val$array = objectArray;
                this.val$offset = n;
                super((int)var1_1, (int)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final T get(int index) {
                void var1_1;
                return this.val$array[this.val$offset + var1_1];
            }
        };
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(@Nullable T value) {
        T t;
        return new UnmodifiableIterator<T>(t){
            private boolean done;
            private /* synthetic */ Object val$value;
            {
                this.val$value = object;
            }

            @Override
            public final boolean hasNext() {
                return !this.done;
            }

            @Override
            public final T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return this.val$value;
            }
        };
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator) {
        Iterator<? extends T> iterator2;
        if (iterator instanceof PeekingImpl) {
            iterator = iterator;
            return iterator;
        }
        return new PeekingImpl<T>(iterator2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterators, Comparator<? super T> comparator) {
        void var1_1;
        Iterable<? extends Iterator<? extends T>> iterable;
        Ascii.checkNotNull(iterators, "iterators");
        Ascii.checkNotNull(comparator, "comparator");
        return new MergingIterator(iterable, var1_1);
    }

    static <T> ListIterator<T> cast(Iterator<T> iterator) {
        return (ListIterator)iterator;
    }

    static final class MergingIterator<T>
    extends UnmodifiableIterator<T> {
        private Queue<PeekingIterator<T>> queue;

        /*
         * WARNING - void declaration
         */
        public MergingIterator(Iterable<? extends Iterator<? extends T>> iterators, Comparator<? super T> itemComparator) {
            Comparator heapComparator = new Comparator<PeekingIterator<T>>(this, itemComparator){
                private /* synthetic */ Comparator val$itemComparator;
                {
                    this.val$itemComparator = comparator;
                }
            };
            this.queue = new PriorityQueue<PeekingIterator<T>>(2, heapComparator);
            for (Iterator<T> iterator : iterators) {
                void var2_2;
                if (!iterator.hasNext()) continue;
                this.queue.add(Iterators.peekingIterator(var2_2));
            }
        }

        @Override
        public final boolean hasNext() {
            return !this.queue.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T next() {
            void var2_2;
            PeekingIterator<T> nextIter = this.queue.remove();
            T next = nextIter.next();
            if (nextIter.hasNext()) {
                void var1_1;
                this.queue.add((PeekingIterator<T>)var1_1);
            }
            return var2_2;
        }
    }

    static final class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        private E peekedElement;

        /*
         * WARNING - void declaration
         */
        public PeekingImpl(Iterator<? extends E> iterator) {
            void var1_1;
            this.iterator = (Iterator)Ascii.checkNotNull(var1_1);
        }

        @Override
        public final boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E next() {
            void var1_1;
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E result = this.peekedElement;
            this.hasPeeked = false;
            this.peekedElement = null;
            return var1_1;
        }

        @Override
        public final void remove() {
            Ascii.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        public final E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return this.peekedElement;
        }
    }
}

