/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Equivalence;
import com.github.igorsuhorukov.google.common.base.Ticker;
import com.github.igorsuhorukov.google.common.collect.AbstractMapEntry;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.MapMaker;
import com.github.igorsuhorukov.google.common.collect.MapMakerInternalMap;
import com.github.igorsuhorukov.google.common.primitives.Ints;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class MapMakerInternalMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    private static final Logger logger = Logger.getLogger(MapMakerInternalMap.class.getName());
    private transient int segmentMask;
    private transient int segmentShift;
    final transient Segment<K, V>[] segments;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    private Strength keyStrength;
    final Strength valueStrength;
    final int maximumSize;
    final long expireAfterAccessNanos;
    final long expireAfterWriteNanos;
    final Queue<MapMaker.RemovalNotification<K, V>> removalNotificationQueue;
    final transient EntryFactory entryFactory;
    final Ticker ticker;
    private static ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public final Object get() {
            return null;
        }

        @Override
        public final ReferenceEntry<Object, Object> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<Object, Object> copyFor(ReferenceQueue<Object> queue, @Nullable Object value, ReferenceEntry<Object, Object> entry) {
            return this;
        }

        @Override
        public final void clear$28155164() {
        }
    };
    static final Queue<? extends Object> DISCARDING_QUEUE = new AbstractQueue<Object>(){

        @Override
        public final boolean offer(Object o) {
            return true;
        }

        @Override
        public final Object peek() {
            return null;
        }

        @Override
        public final Object poll() {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }
    };
    private transient Set<K> keySet;
    private transient Collection<V> values;
    private transient Set<Map.Entry<K, V>> entrySet;

    final boolean expires() {
        MapMakerInternalMap mapMakerInternalMap = this;
        return mapMakerInternalMap.expireAfterWriteNanos > 0L || this.expiresAfterAccess();
    }

    final boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    final boolean usesKeyReferences() {
        return this.keyStrength != Strength.STRONG;
    }

    final boolean usesValueReferences() {
        return this.valueStrength != Strength.STRONG;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private int hash(Object key) {
        void var1_1;
        int n = this.keyEquivalence.hash(var1_1);
        int n2 = n;
        n2 = n;
        n2 = n + (n2 << 15 ^ 0xFFFFCD7D);
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    /*
     * WARNING - void declaration
     */
    final Segment<K, V> segmentFor(int hash) {
        void var1_1;
        return this.segments[var1_1 >>> this.segmentShift & this.segmentMask];
    }

    final boolean isExpired(ReferenceEntry<K, V> entry) {
        return MapMakerInternalMap.isExpired(entry, this.ticker.read());
    }

    static boolean isExpired(ReferenceEntry<K, V> entry, long now) {
        ReferenceEntry referenceEntry;
        return now - referenceEntry.getExpirationTime() > 0L;
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void connectExpirables(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        ReferenceEntry<K, V> referenceEntry;
        void var1_1;
        previous.setNextExpirable(next);
        var1_1.setPreviousExpirable(referenceEntry);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void nullifyExpirable(ReferenceEntry<K, V> nulled) {
        void var1_1;
        ReferenceEntry<K, V> referenceEntry;
        NullEntry nullEntry = NullEntry.INSTANCE;
        nulled.setNextExpirable(nullEntry);
        referenceEntry.setPreviousExpirable((ReferenceEntry<K, V>)var1_1);
    }

    final void processPendingNotifications() {
        while (this.removalNotificationQueue.poll() != null) {
        }
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void connectEvictables(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        ReferenceEntry<K, V> referenceEntry;
        void var1_1;
        previous.setNextEvictable(next);
        var1_1.setPreviousEvictable(referenceEntry);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void nullifyEvictable(ReferenceEntry<K, V> nulled) {
        void var1_1;
        ReferenceEntry<K, V> referenceEntry;
        NullEntry nullEntry = NullEntry.INSTANCE;
        nulled.setNextEvictable(nullEntry);
        referenceEntry.setPreviousEvictable((ReferenceEntry<K, V>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEmpty() {
        int i;
        long sum = 0L;
        Segment<K, V>[] segments = this.segments;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            sum += (long)segments[i].modCount;
        }
        if (sum != 0L) {
            void var1_1;
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count != 0) {
                    return false;
                }
                sum -= (long)segments[i].modCount;
            }
            if (var1_1 != 0L) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        void var2_2;
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        for (int i = 0; i < segments.length; ++i) {
            sum += (long)segments[i].count;
        }
        return Ints.saturatedCast((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(@Nullable Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).get(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(@Nullable Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(var1_1, (int)var2_2);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        Segment<K, V>[] segments = this.segments;
        long last = -1L;
        for (int i = 0; i < 3; ++i) {
            long sum = 0L;
            Segment<K, V>[] arr$ = segments;
            int len$ = segments.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Segment<K, V> segment = arr$[i$];
                int cfr_ignored_0 = segment.count;
                AtomicReferenceArray table = segment.table;
                for (int j = 0; j < table.length(); ++j) {
                    for (ReferenceEntry e = table.get(j); e != null; e = e.getNext()) {
                        Object v;
                        Object v0;
                        ReferenceEntry referenceEntry = e;
                        Segment<K, V> segment2 = segment;
                        if (referenceEntry.getKey() == null) {
                            segment2.tryDrainReferenceQueues();
                            v0 = null;
                        } else {
                            Object v2 = referenceEntry.getValueReference().get();
                            if (v2 == null) {
                                segment2.tryDrainReferenceQueues();
                                v0 = null;
                            } else if (segment2.map.expires() && segment2.map.isExpired(referenceEntry)) {
                                segment2.tryExpireEntries();
                                v0 = null;
                            } else {
                                v0 = v = v2;
                            }
                        }
                        if (v0 == null || !this.valueEquivalence.equivalent(value, v)) continue;
                        return true;
                    }
                }
                sum += (long)segment.modCount;
            }
            if (sum == last) break;
            last = sum;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            void var2_2;
            this.put(e.getKey(), var2_2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(@Nullable Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (key == null || value == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var3_3, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean replace(K key, @Nullable V oldValue, V newValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(newValue);
        if (oldValue == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, hash, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, (int)var3_3, var2_2);
    }

    @Override
    public void clear() {
        Segment<K, V>[] arr$ = this.segments;
        int len$ = this.segments.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Segment segment = arr$[i$];
            Segment segment2 = segment;
            segment2 = segment;
            if (segment.count == 0) continue;
            segment2.lock();
            try {
                int n;
                Serializable serializable = segment2.table;
                if (segment2.map.removalNotificationQueue != DISCARDING_QUEUE) {
                    for (n = 0; n < serializable.length(); ++n) {
                        for (ReferenceEntry referenceEntry = serializable.get(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                            referenceEntry.getValueReference();
                            segment2.enqueueNotification(referenceEntry, MapMaker.RemovalCause.EXPLICIT);
                        }
                    }
                }
                for (n = 0; n < serializable.length(); ++n) {
                    serializable.set(n, null);
                }
                serializable = segment2;
                if (((Segment)serializable).map.usesKeyReferences()) {
                    Serializable serializable2 = serializable;
                    while (((Segment)serializable2).keyReferenceQueue.poll() != null) {
                    }
                }
                if (((Segment)serializable).map.usesValueReferences()) {
                    Serializable serializable3 = serializable;
                    while (((Segment)serializable3).valueReferenceQueue.poll() != null) {
                    }
                }
                segment2.evictionQueue.clear();
                segment2.expirationQueue.clear();
                segment2.readCount.set(0);
                ++segment2.modCount;
                segment2.count = 0;
                continue;
            }
            finally {
                segment2.unlock();
                segment2.runUnlockedCleanup();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        if (ks != null) {
            void var1_1;
            return var1_1;
        }
        this.keySet = new KeySet(this);
        return this.keySet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> values() {
        Collection<V> vs = this.values;
        if (vs != null) {
            void var1_1;
            return var1_1;
        }
        this.values = new Values(this);
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            void var1_1;
            return var1_1;
        }
        this.entrySet = new EntrySet(this);
        return this.entrySet;
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private /* synthetic */ MapMakerInternalMap this$0;

        EntrySet(MapMakerInternalMap mapMakerInternalMap) {
            this.this$0 = mapMakerInternalMap;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.this$0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var2_2;
            void var1_1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.this$0.get(key);
            return v != null && this.this$0.valueEquivalence.equivalent(var1_1.getValue(), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            void var2_2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && this.this$0.remove(var2_2, var1_1.getValue());
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private /* synthetic */ MapMakerInternalMap this$0;

        Values(MapMakerInternalMap mapMakerInternalMap) {
            this.this$0 = mapMakerInternalMap;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsValue(var1_1);
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        private /* synthetic */ MapMakerInternalMap this$0;

        KeySet(MapMakerInternalMap mapMakerInternalMap) {
            this.this$0 = mapMakerInternalMap;
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            return this.this$0.remove(var1_1) != null;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.collect.MapMakerInternalMap$com.google.common.collect.MapMakerInternalMap$HashIterator<java.util.Map$Entry<K, V>>, not com.github.igorsuhorukov.google.common.collect.MapMakerInternalMap$HashIterator - discarding signature.
     */
    final class EntryIterator
    extends HashIterator {
        EntryIterator(MapMakerInternalMap mapMakerInternalMap) {
            super(mapMakerInternalMap);
        }
    }

    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        private K key;
        private V value;
        private /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        WriteThroughEntry(MapMakerInternalMap mapMakerInternalMap, K key, V value) {
            void var3_3;
            void var2_2;
            this.this$0 = mapMakerInternalMap;
            this.key = var2_2;
            this.value = var3_3;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                void var1_1;
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(var1_1.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V newValue) {
            void var2_2;
            void var1_1;
            Object oldValue = this.this$0.put(this.key, newValue);
            this.value = var1_1;
            return var2_2;
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.collect.MapMakerInternalMap$com.google.common.collect.MapMakerInternalMap$HashIterator<V>, not com.github.igorsuhorukov.google.common.collect.MapMakerInternalMap$HashIterator - discarding signature.
     */
    final class ValueIterator
    extends HashIterator {
        ValueIterator(MapMakerInternalMap mapMakerInternalMap) {
            super(mapMakerInternalMap);
        }

        @Override
        public final V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.collect.MapMakerInternalMap$com.google.common.collect.MapMakerInternalMap$HashIterator<K>, not com.github.igorsuhorukov.google.common.collect.MapMakerInternalMap$HashIterator - discarding signature.
     */
    final class KeyIterator
    extends HashIterator {
        KeyIterator(MapMakerInternalMap mapMakerInternalMap) {
            super(mapMakerInternalMap);
        }

        @Override
        public final K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator<E>
    implements Iterator<E> {
        private int nextSegmentIndex;
        private int nextTableIndex;
        private Segment<K, V> currentSegment;
        private AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        private ReferenceEntry<K, V> nextEntry;
        private MapMakerInternalMap.MapMakerInternalMap.WriteThroughEntry nextExternal;
        private MapMakerInternalMap.MapMakerInternalMap.WriteThroughEntry lastReturned;
        private /* synthetic */ MapMakerInternalMap this$0;

        HashIterator(MapMakerInternalMap mapMakerInternalMap) {
            this.this$0 = mapMakerInternalMap;
            this.nextSegmentIndex = mapMakerInternalMap.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        private void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = this.this$0.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        private boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        private boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean advanceTo(ReferenceEntry<K, V> entry) {
            try {
                Object value;
                Object v;
                Object key = entry.getKey();
                ReferenceEntry referenceEntry = entry;
                entry = this.this$0;
                if ((referenceEntry.getKey() == null ? null : ((v = referenceEntry.getValueReference().get()) == null ? null : (value = ((MapMakerInternalMap)entry).expires() && ((MapMakerInternalMap)entry).isExpired(referenceEntry) ? null : v))) != null) {
                    void var1_1;
                    void var2_3;
                    this.nextExternal = new WriteThroughEntry(this.this$0, var2_3, var1_1);
                    return true;
                }
                return false;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextExternal != null;
        }

        final MapMakerInternalMap.WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            boolean bl = this.lastReturned != null;
            Ascii.checkState(bl, "no calls to next() since the last call to remove()");
            this.this$0.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock {
        final MapMakerInternalMap<K, V> map;
        volatile int count;
        int modCount;
        private int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        private int maxSegmentSize;
        final ReferenceQueue<K> keyReferenceQueue;
        final ReferenceQueue<V> valueReferenceQueue;
        private Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount;
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> evictionQueue;
        @GuardedBy(value="Segment.this")
        final Queue<ReferenceEntry<K, V>> expirationQueue;

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (original.getKey() == null) {
                return null;
            }
            ValueReference<K, V> valueReference = original.getValueReference();
            V value = valueReference.get();
            if (value == null) {
                return null;
            }
            ReferenceEntry<K, V> newEntry = this.map.entryFactory.copyEntry(this, original, var2_2);
            newEntry.setValueReference(var3_3.copyFor(this.valueReferenceQueue, value, newEntry));
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="Segment.this")
        private void setValue(ReferenceEntry<K, V> entry, V value) {
            Segment segment;
            void var2_2;
            ValueReference<K, V> valueReference = this.map.valueStrength.referenceValue(this, entry, value);
            entry.setValueReference((ValueReference<K, V>)var2_2);
            var2_2 = segment;
            segment = this;
            segment.drainRecencyQueue();
            segment.evictionQueue.add((ReferenceEntry<K, V>)var2_2);
            if (segment.map.expires()) {
                long l = segment.map.expiresAfterAccess() ? segment.map.expireAfterAccessNanos : segment.map.expireAfterWriteNanos;
                segment.recordExpirationTime((ReferenceEntry<K, V>)var2_2, l);
                segment.expirationQueue.add((ReferenceEntry<K, V>)var2_2);
            }
        }

        final void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        private void drainReferenceQueues() {
            Object object;
            MapMakerInternalMap<K, V> mapMakerInternalMap;
            int n;
            Segment segment;
            if (this.map.usesKeyReferences()) {
                segment = this;
                n = 0;
                while ((mapMakerInternalMap = segment.keyReferenceQueue.poll()) != null) {
                    mapMakerInternalMap = (ReferenceEntry)((Object)mapMakerInternalMap);
                    object = mapMakerInternalMap;
                    mapMakerInternalMap = segment.map;
                    int n2 = object.getHash();
                    mapMakerInternalMap.segmentFor(n2).reclaimKey((ReferenceEntry<K, V>)object, n2);
                    if (++n != 16) continue;
                }
            }
            if (this.map.usesValueReferences()) {
                segment = this;
                n = 0;
                while ((mapMakerInternalMap = segment.valueReferenceQueue.poll()) != null) {
                    mapMakerInternalMap = (ValueReference)((Object)mapMakerInternalMap);
                    object = mapMakerInternalMap;
                    mapMakerInternalMap = segment.map;
                    ReferenceEntry referenceEntry = object.getEntry();
                    int n3 = referenceEntry.getHash();
                    mapMakerInternalMap.segmentFor(n3).reclaimValue((K)referenceEntry.getKey(), n3, (ValueReference<K, V>)object);
                    if (++n != 16) continue;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="Segment.this")
        private void recordLockedRead(ReferenceEntry<K, V> entry) {
            this.evictionQueue.add(entry);
            if (this.map.expiresAfterAccess()) {
                void var1_1;
                this.recordExpirationTime(entry, this.map.expireAfterAccessNanos);
                this.expirationQueue.add((ReferenceEntry<K, V>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="Segment.this")
        private void drainRecencyQueue() {
            ReferenceEntry<K, V> e;
            while ((e = this.recencyQueue.poll()) != null) {
                void var1_1;
                if (this.evictionQueue.contains(e)) {
                    this.evictionQueue.add(e);
                }
                if (!this.map.expiresAfterAccess() || !this.expirationQueue.contains(e)) continue;
                this.expirationQueue.add((ReferenceEntry<K, V>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void recordExpirationTime(ReferenceEntry<K, V> entry, long expirationNanos) {
            void var2_2;
            entry.setExpirationTime(this.map.ticker.read() + var2_2);
        }

        final void tryExpireEntries() {
            if (this.tryLock()) {
                try {
                    this.expireEntries();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="Segment.this")
        private void expireEntries() {
            ReferenceEntry<K, V> e;
            this.drainRecencyQueue();
            if (this.expirationQueue.isEmpty()) {
                return;
            }
            long now = this.map.ticker.read();
            while ((e = this.expirationQueue.peek()) != null && MapMakerInternalMap.isExpired(e, now)) {
                void var3_2;
                if (!this.removeEntry(e, var3_2.getHash(), MapMaker.RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        final void enqueueNotification(ReferenceEntry<K, V> entry, MapMaker.RemovalCause cause) {
            void var2_2;
            void var1_1;
            this.enqueueNotification$4edc571b(entry.getKey(), var1_1.getValueReference().get(), (MapMaker.RemovalCause)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void enqueueNotification$4edc571b(@Nullable K key, @Nullable V value, MapMaker.RemovalCause cause) {
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                void var1_1;
                void var3_3;
                void var2_2;
                MapMaker.RemovalNotification<K, void> notification = new MapMaker.RemovalNotification<K, void>(key, var2_2, (MapMaker.RemovalCause)var3_3);
                this.map.removalNotificationQueue.offer(var1_1);
            }
        }

        @GuardedBy(value="Segment.this")
        private boolean evictEntries() {
            MapMakerInternalMap<K, V> mapMakerInternalMap = this.map;
            if (mapMakerInternalMap.maximumSize != -1 && this.count >= this.maxSegmentSize) {
                this.drainRecencyQueue();
                ReferenceEntry<K, V> e = this.evictionQueue.remove();
                if (!this.removeEntry(e, mapMakerInternalMap.getHash(), MapMaker.RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private ReferenceEntry<K, V> getEntry(Object key, int hash) {
            if (this.count != 0) {
                int n = hash;
                Serializable serializable = this;
                serializable = ((Segment)serializable).table;
                for (ReferenceEntry<K, V> e = ((AtomicReferenceArray)serializable).get(n & ((AtomicReferenceArray)serializable).length() - 1); e != null; e = e.getNext()) {
                    void var3_4;
                    if (e.getHash() != hash) continue;
                    K entryKey = e.getKey();
                    if (entryKey == null) {
                        this.tryDrainReferenceQueues();
                        continue;
                    }
                    if (!this.map.keyEquivalence.equivalent(key, var3_4)) continue;
                    return e;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private ReferenceEntry<K, V> getLiveEntry(Object key, int hash) {
            void var1_1;
            void var2_2;
            ReferenceEntry<K, V> e = this.getEntry(key, (int)var2_2);
            if (e == null) {
                return null;
            }
            if (this.map.expires() && this.map.isExpired(e)) {
                this.tryExpireEntries();
                return null;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final V get(Object key, int hash) {
            try {
                void var2_4;
                Segment segment;
                ReferenceEntry<K, V> e = this.getLiveEntry(key, hash);
                if (e == null) {
                    return null;
                }
                V value = e.getValueReference().get();
                if (value != null) {
                    void var3_5 = segment;
                    segment = this;
                    if (segment.map.expiresAfterAccess()) {
                        segment.recordExpirationTime((ReferenceEntry<K, V>)var3_5, segment.map.expireAfterAccessNanos);
                    }
                    segment.recencyQueue.add((ReferenceEntry<K, V>)var3_5);
                } else {
                    this.tryDrainReferenceQueues();
                }
                segment = var2_4;
                return (V)segment;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean containsKey(Object key, int hash) {
            try {
                if (this.count != 0) {
                    void var1_1;
                    void var2_4;
                    ReferenceEntry<K, V> e = this.getLiveEntry(key, (int)var2_4);
                    if (e == null) {
                        return false;
                    }
                    boolean bl = var1_1.getValueReference().get() != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final V put(K key, int hash2, V value, boolean onlyIfAbsent) {
            this.lock();
            try {
                void var3_5;
                void var1_1;
                void var2_3;
                ReferenceEntry<K, V> first;
                ReferenceEntry<K, V> e;
                int n;
                Segment segment;
                Segment segment2 = this;
                segment2.runLockedCleanup();
                int newCount2 = this.count + 1;
                if (newCount2 > this.threshold) {
                    segment = this;
                    AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = segment.table;
                    n = atomicReferenceArray.length();
                    if (n < 0x40000000) {
                        int n2 = segment.count;
                        newCount2 = n << 1;
                        AtomicReferenceArray<ReferenceEntry<K, V>> newCount2 = new AtomicReferenceArray<ReferenceEntry<K, V>>(newCount2);
                        segment.threshold = newCount2.length() * 3 / 4;
                        int n3 = newCount2.length() - 1;
                        for (int i = 0; i < n; ++i) {
                            int n4;
                            ReferenceEntry<K, V> referenceEntry = atomicReferenceArray.get(i);
                            if (referenceEntry == null) continue;
                            ReferenceEntry<K, V> referenceEntry2 = referenceEntry.getNext();
                            int n5 = referenceEntry.getHash() & n3;
                            if (referenceEntry2 == null) {
                                newCount2.set(n5, referenceEntry);
                                continue;
                            }
                            ReferenceEntry<K, V> referenceEntry3 = referenceEntry;
                            while (referenceEntry2 != null) {
                                n4 = referenceEntry2.getHash() & n3;
                                if (n4 != n5) {
                                    n5 = n4;
                                    referenceEntry3 = referenceEntry2;
                                }
                                referenceEntry2 = referenceEntry2.getNext();
                            }
                            newCount2.set(n5, referenceEntry3);
                            for (referenceEntry2 = referenceEntry; referenceEntry2 != referenceEntry3; referenceEntry2 = referenceEntry2.getNext()) {
                                n4 = referenceEntry2.getHash() & n3;
                                referenceEntry = (ReferenceEntry<K, V>)newCount2.get(n4);
                                if ((referenceEntry = segment.copyEntry(referenceEntry2, referenceEntry)) != null) {
                                    newCount2.set(n4, referenceEntry);
                                    continue;
                                }
                                segment.removeCollectedEntry(referenceEntry2);
                                --n2;
                            }
                        }
                        segment.table = newCount2;
                        segment.count = n2;
                    }
                    newCount2 = this.count + 1;
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash2 & table.length() - 1;
                for (e = first = table.get(index); e != null; e = e.getNext()) {
                    void var2_4;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash2 || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> hash2 = e.getValueReference();
                    V entryValue = hash2.get();
                    if (entryValue == null) {
                        ++this.modCount;
                        this.setValue(e, value);
                        this.enqueueNotification$4edc571b(key, entryValue, MapMaker.RemovalCause.COLLECTED);
                        this.count = newCount2 = this.count;
                        return null;
                    }
                    if (onlyIfAbsent) {
                        this.recordLockedRead(e);
                        key = entryValue;
                        return (V)key;
                    }
                    ++this.modCount;
                    this.enqueueNotification$4edc571b(key, entryValue, MapMaker.RemovalCause.REPLACED);
                    this.setValue(e, value);
                    key = var2_4;
                    return (V)key;
                }
                ++this.modCount;
                ReferenceEntry<K, V> referenceEntry = first;
                n = var2_3;
                e = var1_1;
                segment = this;
                ReferenceEntry<ReferenceEntry<K, V>, V> newEntry = segment.map.entryFactory.newEntry(segment, e, n, referenceEntry);
                this.setValue(newEntry, var3_5);
                table.set(index, newEntry);
                if (this.evictEntries()) {
                    newCount2 = this.count + 1;
                }
                this.count = newCount2;
                return null;
            }
            finally {
                this.unlock();
                Segment newCount2 = this;
                newCount2.runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean replace(K key, int hash, V oldValue, V newValue) {
            Serializable table;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                Segment segment = this;
                segment.runLockedCleanup();
                table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (Segment.isCollected(valueReference)) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            this.enqueueNotification$4edc571b(entryKey, entryValue, MapMaker.RemovalCause.COLLECTED);
                            ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                            int newCount = this.count - 1;
                            table.set(index, (ReferenceEntry<K, V>)var2_5);
                            this.count = var1_2;
                        }
                        return false;
                    }
                    if (this.map.valueEquivalence.equivalent(oldValue, entryValue)) {
                        void var1_1;
                        ++this.modCount;
                        this.enqueueNotification$4edc571b(var1_1, entryValue, MapMaker.RemovalCause.REPLACED);
                        this.setValue(e, newValue);
                        return true;
                    }
                    this.recordLockedRead(e);
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                table = this;
                ((Segment)table).runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final V replace(K key, int hash, V newValue) {
            Serializable table;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                Segment segment = this;
                segment.runLockedCleanup();
                table = this.table;
                int index = hash & ((AtomicReferenceArray)table).length() - 1;
                for (ReferenceEntry<K, V> e = first = ((AtomicReferenceArray)table).get(index); e != null; e = e.getNext()) {
                    V v;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (Segment.isCollected(valueReference)) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            this.enqueueNotification$4edc571b(entryKey, entryValue, MapMaker.RemovalCause.COLLECTED);
                            ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                            int newCount = this.count - 1;
                            ((AtomicReferenceArray)table).set(index, var2_5);
                            this.count = var1_2;
                        }
                        return null;
                    }
                    ++this.modCount;
                    this.enqueueNotification$4edc571b(v, entryValue, MapMaker.RemovalCause.REPLACED);
                    this.setValue(e, newValue);
                    v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                table = this;
                ((Segment)table).runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final V remove(Object key, int hash) {
            Serializable table;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                Segment segment = this;
                segment.runLockedCleanup();
                table = this.table;
                int index = hash & ((AtomicReferenceArray)table).length() - 1;
                for (ReferenceEntry<K, V> e = first = ((AtomicReferenceArray)table).get(index); e != null; e = e.getNext()) {
                    void var2_6;
                    void var1_2;
                    MapMaker.RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue != null) {
                        cause = MapMaker.RemovalCause.EXPLICIT;
                    } else if (Segment.isCollected(cause)) {
                        cause = MapMaker.RemovalCause.COLLECTED;
                    } else {
                        return null;
                    }
                    ++this.modCount;
                    this.enqueueNotification$4edc571b(entryKey, entryValue, cause);
                    ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    ((AtomicReferenceArray)table).set(index, newFirst);
                    this.count = var1_2;
                    void var1_3 = var2_6;
                    return var1_3;
                }
                return null;
            }
            finally {
                this.unlock();
                table = this;
                ((Segment)table).runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean remove(Object key, int hash, Object value) {
            Serializable table;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                Segment segment = this;
                segment.runLockedCleanup();
                table = this.table;
                int index = hash & ((AtomicReferenceArray)table).length() - 1;
                for (ReferenceEntry<K, V> e = first = ((AtomicReferenceArray)table).get(index); e != null; e = e.getNext()) {
                    void var3_6;
                    boolean bl;
                    void var2_5;
                    MapMaker.RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (this.map.valueEquivalence.equivalent(value, entryValue)) {
                        cause = MapMaker.RemovalCause.EXPLICIT;
                    } else if (Segment.isCollected(valueReference)) {
                        cause = MapMaker.RemovalCause.COLLECTED;
                    } else {
                        return false;
                    }
                    ++this.modCount;
                    this.enqueueNotification$4edc571b(entryKey, entryValue, cause);
                    ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    ((AtomicReferenceArray)table).set(index, var2_5);
                    this.count = bl;
                    bl = var3_6 == MapMaker.RemovalCause.EXPLICIT;
                    return bl;
                }
                return false;
            }
            finally {
                this.unlock();
                table = this;
                ((Segment)table).runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> removeFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry) {
            void var3_3;
            ReferenceEntry e;
            this.evictionQueue.remove(entry);
            this.expirationQueue.remove(entry);
            int newCount = this.count;
            ReferenceEntry<K, V> newFirst = entry.getNext();
            while (e != entry) {
                ReferenceEntry<K, V> next = this.copyEntry(e, newFirst);
                if (next != null) {
                    newFirst = next;
                } else {
                    this.removeCollectedEntry(e);
                    --newCount;
                }
                e = e.getNext();
            }
            this.count = var3_3;
            return newFirst;
        }

        /*
         * WARNING - void declaration
         */
        private void removeCollectedEntry(ReferenceEntry<K, V> entry) {
            void var1_1;
            this.enqueueNotification(entry, MapMaker.RemovalCause.COLLECTED);
            this.evictionQueue.remove(entry);
            this.expirationQueue.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final boolean reclaimKey(ReferenceEntry<K, V> entry, int hash) {
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    void var1_2;
                    if (e != entry) continue;
                    ++this.modCount;
                    this.enqueueNotification$4edc571b(e.getKey(), e.getValueReference().get(), MapMaker.RemovalCause.COLLECTED);
                    ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = var1_2;
                    return true;
                }
                return false;
            }
            finally {
                this.unlock();
                Segment index = this;
                index.runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean reclaimValue(K key, int hash2, ValueReference<K, V> valueReference) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash2 & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash2 || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> hash2 = e.getValueReference();
                    if (hash2 == valueReference) {
                        void var1_2;
                        ++this.modCount;
                        this.enqueueNotification$4edc571b(key, valueReference.get(), MapMaker.RemovalCause.COLLECTED);
                        ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                        int newCount = this.count - 1;
                        table.set(index, (ReferenceEntry<K, V>)((Object)segment));
                        this.count = var1_2;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                if (!this.isHeldByCurrentThread()) {
                    segment = this;
                    segment.runUnlockedCleanup();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="Segment.this")
        private boolean removeEntry(ReferenceEntry<K, V> entry, int hash, MapMaker.RemovalCause cause) {
            ReferenceEntry<K, V> first;
            AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
            int index = hash & table.length() - 1;
            for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                void var1_2;
                void var3_4;
                if (e != entry) continue;
                ++this.modCount;
                this.enqueueNotification$4edc571b(e.getKey(), e.getValueReference().get(), cause);
                ReferenceEntry<K, V> newFirst = this.removeFromChain(first, e);
                int newCount = this.count - 1;
                table.set(index, (ReferenceEntry<K, V>)var3_4);
                this.count = var1_2;
                return true;
            }
            return false;
        }

        private static boolean isCollected(ValueReference<K, V> valueReference) {
            return valueReference.get() == null;
        }

        final void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                Segment segment = this;
                segment.runLockedCleanup();
                segment.runUnlockedCleanup();
            }
        }

        private void runLockedCleanup() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    this.expireEntries();
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        final void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                this.map.processPendingNotifications();
            }
        }
    }

    static final class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        private V referent;

        /*
         * WARNING - void declaration
         */
        StrongValueReference(V referent) {
            void var1_1;
            this.referent = var1_1;
        }

        @Override
        public final V get() {
            return this.referent;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public final void clear$28155164() {
        }
    }

    static final class SoftValueReference<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        private ReferenceEntry<K, V> entry;

        /*
         * WARNING - void declaration
         */
        SoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.entry = var3_3;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public final void clear$28155164() {
            this.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new SoftValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3);
        }
    }

    static final class WeakValueReference<K, V>
    extends WeakReference<V>
    implements ValueReference<K, V> {
        private ReferenceEntry<K, V> entry;

        /*
         * WARNING - void declaration
         */
        WeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.entry = var3_3;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public final void clear$28155164() {
            this.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new WeakValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3);
        }
    }

    static final class WeakExpirableEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakExpirableEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setExpirationTime(long time) {
            void var1_1;
            this.time = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextExpirable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousExpirable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextEvictable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousEvictable = var1_1;
        }
    }

    static final class WeakEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakEvictableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextEvictable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousEvictable = var1_1;
        }
    }

    static final class WeakExpirableEntry<K, V>
    extends WeakEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakExpirableEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setExpirationTime(long time) {
            void var1_1;
            this.time = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextExpirable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousExpirable = var1_1;
        }
    }

    static class WeakEntry<K, V>
    extends WeakReference<K>
    implements ReferenceEntry<K, V> {
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = MapMakerInternalMap.unset();

        /*
         * WARNING - void declaration
         */
        WeakEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.hash = var3_3;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return (K)this.get();
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            void var2_2;
            void var1_1;
            ValueReference<K, V> previous = this.valueReference;
            this.valueReference = var1_1;
            var2_2.clear$28155164();
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class StrongExpirableEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongExpirableEvictableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setExpirationTime(long time) {
            void var1_1;
            this.time = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextExpirable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousExpirable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextEvictable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousEvictable = var1_1;
        }
    }

    static final class StrongEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongEvictableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextEvictable(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextEvictable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousEvictable = var1_1;
        }
    }

    static final class StrongExpirableEntry<K, V>
    extends StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private volatile long time = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        private ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongExpirableEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getExpirationTime() {
            return this.time;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setExpirationTime(long time) {
            void var1_1;
            this.time = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextExpirable(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextExpirable = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousExpirable = var1_1;
        }
    }

    static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        private K key;
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = MapMakerInternalMap.unset();

        /*
         * WARNING - void declaration
         */
        StrongEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.hash = var2_2;
            this.next = var3_3;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public long getExpirationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExpirationTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextExpirable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousExpirable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousExpirable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextEvictable(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousEvictable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousEvictable(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            void var2_2;
            void var1_1;
            ValueReference<K, V> previous = this.valueReference;
            this.valueReference = var1_1;
            var2_2.clear$28155164();
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class NullEntry
    extends Enum<NullEntry>
    implements ReferenceEntry<Object, Object> {
        public static final /* enum */ NullEntry INSTANCE;

        @Override
        public final ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public final void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public final int getHash() {
            return 0;
        }

        @Override
        public final Object getKey() {
            return null;
        }

        @Override
        public final long getExpirationTime() {
            return 0L;
        }

        @Override
        public final void setExpirationTime(long time) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextExpirable() {
            return this;
        }

        @Override
        public final void setNextExpirable(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousExpirable() {
            return this;
        }

        @Override
        public final void setPreviousExpirable(ReferenceEntry<Object, Object> previous) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextEvictable() {
            return this;
        }

        @Override
        public final void setNextEvictable(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousEvictable() {
            return this;
        }

        @Override
        public final void setPreviousEvictable(ReferenceEntry<Object, Object> previous) {
        }

        static {
            (new NullEntry[1])[0] = INSTANCE = new NullEntry();
        }
    }

    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        public ReferenceEntry<K, V> getNext();

        public int getHash();

        public K getKey();

        public long getExpirationTime();

        public void setExpirationTime(long var1);

        public ReferenceEntry<K, V> getNextExpirable();

        public void setNextExpirable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousExpirable();

        public void setPreviousExpirable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getNextEvictable();

        public void setNextEvictable(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousEvictable();

        public void setPreviousEvictable(ReferenceEntry<K, V> var1);
    }

    static interface ValueReference<K, V> {
        public V get();

        public ReferenceEntry<K, V> getEntry();

        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, @Nullable V var2, ReferenceEntry<K, V> var3);

        public void clear$28155164();
    }

    static abstract class EntryFactory
    extends Enum<EntryFactory> {
        private static /* enum */ EntryFactory STRONG = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongEntry<void, V>(var2_2, (int)var3_3, next);
            }
        };
        private static /* enum */ EntryFactory STRONG_EXPIRABLE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongExpirableEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                2.copyExpirableEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory STRONG_EVICTABLE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongEvictableEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                3.copyEvictableEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory STRONG_EXPIRABLE_EVICTABLE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongExpirableEvictableEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                4.copyExpirableEntry(original, newEntry);
                4.copyEvictableEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory WEAK = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }
        };
        private static /* enum */ EntryFactory WEAK_EXPIRABLE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakExpirableEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                6.copyExpirableEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory WEAK_EVICTABLE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakEvictableEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                7.copyEvictableEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory WEAK_EXPIRABLE_EVICTABLE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakExpirableEvictableEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                8.copyExpirableEntry(original, newEntry);
                8.copyEvictableEntry(var2_2, newEntry);
                return var1_1;
            }
        };

        private EntryFactory() {
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2, int var3, @Nullable ReferenceEntry<K, V> var4);

        /*
         * WARNING - void declaration
         */
        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.newEntry((Segment<K, V>)var1_1, original.getKey(), var2_2.getHash(), (ReferenceEntry<K, V>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static <K, V> void copyExpirableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            ReferenceEntry<K, V> referenceEntry;
            void var1_1;
            newEntry.setExpirationTime(original.getExpirationTime());
            MapMakerInternalMap.connectExpirables(original.getPreviousExpirable(), newEntry);
            MapMakerInternalMap.connectExpirables(var1_1, original.getNextExpirable());
            MapMakerInternalMap.nullifyExpirable(referenceEntry);
        }

        /*
         * WARNING - void declaration
         */
        static <K, V> void copyEvictableEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            ReferenceEntry<K, V> referenceEntry;
            void var1_1;
            MapMakerInternalMap.connectEvictables(original.getPreviousEvictable(), newEntry);
            MapMakerInternalMap.connectEvictables(var1_1, original.getNextEvictable());
            MapMakerInternalMap.nullifyEvictable(referenceEntry);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntryFactory(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            EntryFactory[] entryFactoryArray = new EntryFactory[]{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE, WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE};
            EntryFactory[][] entryFactoryArrayArray = new EntryFactory[][]{{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE}, new EntryFactory[0], {WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE}};
        }
    }

    static abstract class Strength
    extends Enum<Strength> {
        public static final /* enum */ Strength STRONG = new Strength(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                void var3_3;
                return new StrongValueReference(var3_3);
            }
        };
        private static /* enum */ Strength SOFT = new Strength(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                void var2_2;
                void var3_3;
                void var1_1;
                return new SoftValueReference(var1_1.valueReferenceQueue, var3_3, var2_2);
            }
        };
        private static /* enum */ Strength WEAK = new Strength(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value) {
                void var2_2;
                void var3_3;
                void var1_1;
                return new WeakValueReference(var1_1.valueReferenceQueue, var3_3, var2_2);
            }
        };

        private Strength() {
        }

        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3);

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Strength(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            Strength[] strengthArray = new Strength[]{STRONG, SOFT, WEAK};
        }
    }
}

