/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.base.Joiner$MapJoiner;
import com.github.igorsuhorukov.google.common.base.Predicate;
import com.github.igorsuhorukov.google.common.base.Predicates;
import com.github.igorsuhorukov.google.common.collect.AbstractBiMap;
import com.github.igorsuhorukov.google.common.collect.AbstractMapEntry;
import com.github.igorsuhorukov.google.common.collect.Collections2;
import com.github.igorsuhorukov.google.common.collect.ForwardingMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableEntry;
import com.github.igorsuhorukov.google.common.collect.Iterables;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Ordering;
import com.github.igorsuhorukov.google.common.collect.Sets$ImprovedAbstractSet;
import com.github.igorsuhorukov.google.common.collect.TransformedIterator;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

public final class Maps {
    private static Joiner$MapJoiner STANDARD_JOINER = Collections2.STANDARD_JOINER$7418a432.withKeyValueSeparator("=");

    static <K, V> Iterator<K> keyIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        return Iterators.transform(entryIterator, EntryFunction.KEY);
    }

    static <K, V> Iterator<V> valueIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        return Iterators.transform(entryIterator, EntryFunction.VALUE);
    }

    static <K, V> UnmodifiableIterator<V> valueIterator(UnmodifiableIterator<Map.Entry<K, V>> entryIterator) {
        UnmodifiableIterator<Map.Entry<K, V>> unmodifiableIterator;
        return new UnmodifiableIterator<V>(unmodifiableIterator){
            private /* synthetic */ UnmodifiableIterator val$entryIterator;
            {
                this.val$entryIterator = unmodifiableIterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$entryIterator.hasNext();
            }

            @Override
            public final V next() {
                return ((Map.Entry)this.val$entryIterator.next()).getValue();
            }
        };
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            AbstractBiMap.1.checkNonnegative(expectedSize, "expectedSize");
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            int n;
            return expectedSize + n / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> Iterator<Map.Entry<K, V>> asMapEntryIterator(Set<K> set, Function<? super K, V> function) {
        void var1_1;
        Set<K> set2;
        return new TransformedIterator<K, Map.Entry<K, V>>(set2.iterator(), (Function)var1_1){
            private /* synthetic */ Function val$function;
            {
                void var1_1;
                this.val$function = function;
                super(var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map.Entry<K, V> immutableEntry(@Nullable K key, @Nullable V value) {
        void var1_1;
        K k;
        return new ImmutableEntry<K, void>(k, var1_1);
    }

    static <V> Predicate<Map.Entry<?, V>> valuePredicateOnEntries(Predicate<? super V> valuePredicate) {
        return Predicates.compose(valuePredicate, EntryFunction.VALUE);
    }

    /*
     * WARNING - void declaration
     */
    static <V> V safeGet(Map<?, V> map, @Nullable Object key) {
        Ascii.checkNotNull(map);
        try {
            void var1_1;
            Map<?, V> map2;
            return map2.get(var1_1);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean safeContainsKey(Map<?, ?> map, Object key) {
        Ascii.checkNotNull(map);
        try {
            void var1_1;
            Map<?, ?> map2;
            return map2.containsKey(var1_1);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static <V> V safeRemove(Map<?, V> map, Object key) {
        Ascii.checkNotNull(map);
        try {
            void var1_1;
            Map<?, V> map2;
            return map2.remove(var1_1);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> boolean containsEntryImpl(Collection<Map.Entry<K, V>> c, Object o) {
        void var1_1;
        Map.Entry entry;
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Collection<Map.Entry<K, V>> collection = entry;
        entry = (Map.Entry)var1_1;
        Ascii.checkNotNull(entry);
        return collection.contains(new AbstractMapEntry<K, V>(entry){
            private /* synthetic */ Map.Entry val$entry;
            {
                this.val$entry = entry;
            }

            @Override
            public final K getKey() {
                return this.val$entry.getKey();
            }

            @Override
            public final V getValue() {
                return this.val$entry.getValue();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Map<?, ?> map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            void var1_1;
            Map<?, ?> map2;
            Map o = (Map)object;
            return map2.entrySet().equals(var1_1.entrySet());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static String toStringImpl(Map<?, ?> map) {
        void var1_1;
        Object object;
        StringBuilder sb = Collections2.newStringBuilderForCollection(map.size()).append('{');
        Joiner$MapJoiner joiner$MapJoiner = STANDARD_JOINER;
        Object object2 = object;
        StringBuilder stringBuilder = sb;
        object = joiner$MapJoiner;
        object2 = object2.entrySet();
        object = joiner$MapJoiner;
        joiner$MapJoiner.appendTo(stringBuilder, object2.iterator());
        return var1_1.append('}').toString();
    }

    @Nullable
    static <K> K keyOrNull(@Nullable Map.Entry<K, ?> entry) {
        Map.Entry<K, ?> entry2;
        if (entry == null) {
            return null;
        }
        return entry2.getKey();
    }

    static abstract class DescendingMap<K, V>
    extends ForwardingMap<K, V>
    implements NavigableMap<K, V> {
        private transient Comparator<? super K> comparator;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient NavigableSet<K> navigableKeySet;

        DescendingMap() {
        }

        abstract NavigableMap<K, V> forward();

        @Override
        protected final Map<K, V> delegate() {
            return this.forward();
        }

        @Override
        public Comparator<? super K> comparator() {
            Ordering ordering;
            Comparator<? super K> result = this.comparator;
            if (result == null) {
                Comparator forwardCmp = this.forward().comparator();
                if (forwardCmp == null) {
                    forwardCmp = Ordering.natural();
                }
                this.comparator = Ordering.from(ordering).reverse();
                ordering = this.comparator;
            }
            return ordering;
        }

        @Override
        public K firstKey() {
            return this.forward().lastKey();
        }

        @Override
        public K lastKey() {
            return this.forward().firstKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            void var1_1;
            return this.forward().higherEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lowerKey(K key) {
            void var1_1;
            return this.forward().higherKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            void var1_1;
            return this.forward().ceilingEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floorKey(K key) {
            void var1_1;
            return this.forward().ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            void var1_1;
            return this.forward().floorEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceilingKey(K key) {
            void var1_1;
            return this.forward().floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            void var1_1;
            return this.forward().lowerEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higherKey(K key) {
            void var1_1;
            return this.forward().lowerKey(var1_1);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.forward().lastEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.forward().firstEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.forward().pollLastEntry();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.forward().pollFirstEntry();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return this.forward();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            void var1_1;
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                result = this;
                this.entrySet = new EntrySet<K, V>((DescendingMap)((Object)result)){
                    private /* synthetic */ DescendingMap this$0;
                    {
                        this.this$0 = descendingMap;
                    }

                    @Override
                    final Map<K, V> map() {
                        return this.this$0;
                    }

                    @Override
                    public final Iterator<Map.Entry<K, V>> iterator() {
                        return this.this$0.entryIterator();
                    }
                };
                return this.entrySet;
            }
            return var1_1;
        }

        abstract Iterator<Map.Entry<K, V>> entryIterator();

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> navigableKeySet() {
            void var1_1;
            NavigableSet<K> result = this.navigableKeySet;
            if (result == null) {
                this.navigableKeySet = new NavigableKeySet(this);
                return this.navigableKeySet;
            }
            return var1_1;
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.forward().navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            void var2_2;
            void var1_1;
            void var3_3;
            return this.forward().subMap(var3_3, toInclusive, var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.forward().tailMap(var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.forward().headMap(var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            void var2_2;
            void var1_1;
            return this.subMap(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> headMap(K toKey) {
            void var1_1;
            return this.headMap(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            void var1_1;
            return this.tailMap(var1_1, true);
        }

        @Override
        public Collection<V> values() {
            return new Values(this);
        }

        @Override
        public String toString() {
            DescendingMap descendingMap = this;
            return Maps.toStringImpl(descendingMap);
        }
    }

    static abstract class EntrySet<K, V>
    extends Sets$ImprovedAbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        abstract Map<K, V> map();

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                void var2_2;
                void var3_3;
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                V value = Maps.safeGet(this.map(), key);
                return Ascii.equal(value, var1_1.getValue()) && (var3_3 != null || this.map().containsKey(var2_2));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                return this.map().keySet().remove(var1_1.getKey());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll(Ascii.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var1_1;
                return AbstractBiMap.1.removeAllImpl(this, var1_1.iterator());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll(Ascii.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_3;
                int n = c.size();
                HashSet keys = new HashSet(Maps.capacity(n));
                for (Object o : c) {
                    void var3_4;
                    if (!this.contains(o)) continue;
                    Map.Entry entry = (Map.Entry)o;
                    keys.add(var3_4.getKey());
                }
                return this.map().keySet().retainAll((Collection<?>)var2_3);
            }
        }
    }

    static class Values<K, V>
    extends AbstractCollection<V> {
        private Map<K, V> map;

        /*
         * WARNING - void declaration
         */
        Values(Map<K, V> map) {
            void var1_1;
            this.map = (Map)Ascii.checkNotNull(var1_1);
        }

        @Override
        public Iterator<V> iterator() {
            Values values = this;
            return Maps.valueIterator(values.map.entrySet().iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            try {
                return super.remove(o);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Values values = this;
                Object i$ = values.map.entrySet().iterator();
                while (i$.hasNext()) {
                    void var3_3;
                    Map.Entry<K, V> entry = i$.next();
                    if (!Ascii.equal(o, entry.getValue())) continue;
                    i$ = this;
                    ((Values)i$).map.remove(var3_3.getKey());
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll(Ascii.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                HashSet<K> toRemove = new HashSet<K>();
                Values values = this;
                for (Map.Entry<K, V> entry : values.map.entrySet()) {
                    if (!c.contains(entry.getValue())) continue;
                    toRemove.add(entry.getKey());
                }
                values = this;
                return values.map.keySet().removeAll((Collection<?>)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll(Ascii.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                HashSet<K> toRetain = new HashSet<K>();
                Values values = this;
                for (Map.Entry<K, V> entry : values.map.entrySet()) {
                    if (!c.contains(entry.getValue())) continue;
                    toRetain.add(entry.getKey());
                }
                values = this;
                return values.map.keySet().retainAll((Collection<?>)var2_2);
            }
        }

        @Override
        public int size() {
            Values values = this;
            return values.map.size();
        }

        @Override
        public boolean isEmpty() {
            Values values = this;
            return values.map.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(@Nullable Object o) {
            void var1_1;
            Values values = this;
            return values.map.containsValue(var1_1);
        }

        @Override
        public void clear() {
            Values values = this;
            values.map.clear();
        }
    }

    static final class NavigableKeySet<K, V>
    extends SortedKeySet<K, V>
    implements NavigableSet<K> {
        /*
         * WARNING - void declaration
         */
        NavigableKeySet(NavigableMap<K, V> map) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K lower(K e) {
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).lowerKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K floor(K e) {
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K ceiling(K e) {
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K higher(K e) {
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).higherKey(var1_1);
        }

        @Override
        public final K pollFirst() {
            NavigableKeySet navigableKeySet = this;
            return Maps.keyOrNull(((NavigableMap)navigableKeySet.map).pollFirstEntry());
        }

        @Override
        public final K pollLast() {
            NavigableKeySet navigableKeySet = this;
            return Maps.keyOrNull(((NavigableMap)navigableKeySet.map).pollLastEntry());
        }

        @Override
        public final NavigableSet<K> descendingSet() {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).descendingKeySet();
        }

        @Override
        public final Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).subMap(var1_1, (boolean)var2_2, var3_3, toInclusive).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<K> headSet(K toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).headMap(var1_1, (boolean)var2_2).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).tailMap(var1_1, (boolean)var2_2).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final SortedSet<K> subSet(K fromElement, K toElement) {
            void var2_2;
            void var1_1;
            return this.subSet(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final SortedSet<K> headSet(K toElement) {
            void var1_1;
            return this.headSet(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final SortedSet<K> tailSet(K fromElement) {
            void var1_1;
            return this.tailSet(var1_1, true);
        }
    }

    static class SortedKeySet<K, V>
    extends KeySet<K, V>
    implements SortedSet<K> {
        /*
         * WARNING - void declaration
         */
        SortedKeySet(SortedMap<K, V> map) {
            super(var1_1);
            void var1_1;
        }

        @Override
        SortedMap<K, V> map() {
            return (SortedMap)super.map();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map().comparator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            void var2_2;
            void var1_1;
            return new SortedKeySet(this.map().subMap(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> headSet(K toElement) {
            void var1_1;
            return new SortedKeySet(this.map().headMap(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> tailSet(K fromElement) {
            void var1_1;
            return new SortedKeySet(this.map().tailMap(var1_1));
        }

        @Override
        public K first() {
            return this.map().firstKey();
        }

        @Override
        public K last() {
            return this.map().lastKey();
        }
    }

    static class KeySet<K, V>
    extends Sets$ImprovedAbstractSet<K> {
        final Map<K, V> map;

        /*
         * WARNING - void declaration
         */
        KeySet(Map<K, V> map) {
            void var1_1;
            this.map = (Map)Ascii.checkNotNull(var1_1);
        }

        Map<K, V> map() {
            return this.map;
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(this.map().entrySet().iterator());
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.map().containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                void var1_1;
                this.map().remove(var1_1);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }

    static abstract class ImprovedAbstractMap<K, V>
    extends AbstractMap<K, V> {
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Set<K> keySet;
        private transient Collection<V> values;

        ImprovedAbstractMap() {
        }

        abstract Set<Map.Entry<K, V>> createEntrySet();

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            void var1_1;
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                this.entrySet = this.createEntrySet();
                return this.entrySet;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<K> keySet() {
            void var1_1;
            Set<K> result = this.keySet;
            if (result == null) {
                this.keySet = this.createKeySet();
                return this.keySet;
            }
            return var1_1;
        }

        Set<K> createKeySet() {
            return new KeySet(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> values() {
            void var1_1;
            Collection<V> result = this.values;
            if (result == null) {
                this.values = this.createValues();
                return this.values;
            }
            return var1_1;
        }

        Collection<V> createValues() {
            return new Values(this);
        }
    }

    static final class FilteredMapValues<K, V>
    extends Values<K, V> {
        private Map<K, V> unfiltered;
        private Predicate<? super Map.Entry<K, V>> predicate;

        /*
         * WARNING - void declaration
         */
        FilteredMapValues(Map<K, V> filteredMap, Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
            super(var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.unfiltered = var2_2;
            this.predicate = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            return Iterables.removeFirstMatching(this.unfiltered.entrySet(), Predicates.and(this.predicate, Maps.valuePredicateOnEntries(Predicates.equalTo(var1_1)))) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private boolean removeIf(Predicate<? super V> valuePredicate) {
            void var1_1;
            return Iterables.removeIf(this.unfiltered.entrySet(), Predicates.and(this.predicate, Maps.valuePredicateOnEntries(var1_1)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<?> collection) {
            void var1_1;
            return this.removeIf(Predicates.in(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<?> collection) {
            void var1_1;
            return this.removeIf(Predicates.not(Predicates.in(var1_1)));
        }

        @Override
        public final Object[] toArray() {
            return AbstractBiMap.1.newArrayList(this.iterator()).toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T[] toArray(T[] array) {
            void var1_1;
            return AbstractBiMap.1.newArrayList(this.iterator()).toArray((T[])var1_1);
        }
    }

    static abstract class AbstractFilteredMap<K, V>
    extends ImprovedAbstractMap<K, V> {
        private Map<K, V> unfiltered;
        private Predicate<? super Map.Entry<K, V>> predicate;

        /*
         * WARNING - void declaration
         */
        private boolean apply(@Nullable Object key, @Nullable V value) {
            void var2_2;
            void var1_1;
            Object k = key;
            return this.predicate.apply(Maps.immutableEntry(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(K key, V value) {
            void var2_2;
            void var1_1;
            Ascii.checkArgument(this.apply(key, value));
            return this.unfiltered.put(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            void var1_1;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                void var3_3;
                Ascii.checkArgument(this.apply(entry.getKey(), var3_3.getValue()));
            }
            this.unfiltered.putAll((Map<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.unfiltered.containsKey(key) && this.apply(key, this.unfiltered.get(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            void var1_1;
            V value = this.unfiltered.get(key);
            if (value != null && this.apply(var1_1, value)) {
                void var2_2;
                return var2_2;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(Object key) {
            if (this.containsKey(key)) {
                void var1_1;
                return this.unfiltered.remove(var1_1);
            }
            return null;
        }

        @Override
        final Collection<V> createValues() {
            return new FilteredMapValues<K, V>(this, this.unfiltered, this.predicate);
        }
    }

    static abstract class EntryFunction
    extends Enum<EntryFunction>
    implements Function<Map.Entry<?, ?>, Object> {
        public static final /* enum */ EntryFunction KEY = new EntryFunction(){};
        public static final /* enum */ EntryFunction VALUE = new EntryFunction(){};

        private EntryFunction() {
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntryFunction(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            EntryFunction[] entryFunctionArray = new EntryFunction[]{KEY, VALUE};
        }
    }
}

