/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.AbstractBiMap;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Multiset;
import com.github.igorsuhorukov.google.common.collect.Ordering;
import com.github.igorsuhorukov.google.common.collect.Sets$ImprovedAbstractSet;
import com.github.igorsuhorukov.google.common.collect.TransformedIterator;
import com.github.igorsuhorukov.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public final class Multisets {
    /*
     * WARNING - void declaration
     */
    public static <E> Multiset.Entry<E> immutableEntry(@Nullable E e, int n) {
        void var1_1;
        E e2;
        return new ImmutableEntry<E>(e2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Multiset<?> multiset, @Nullable Object object) {
        if (object == multiset) {
            return true;
        }
        if (object instanceof Multiset) {
            Multiset that = (Multiset)object;
            if (multiset.size() != that.size() || multiset.entrySet().size() != that.entrySet().size()) {
                return false;
            }
            for (Multiset.Entry entry : that.entrySet()) {
                void var2_2;
                if (multiset.count(entry.getElement()) == var2_2.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static <E> boolean addAllImpl(Multiset<E> self, Collection<? extends E> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        if (elements instanceof Multiset) {
            elements = elements;
            for (Multiset.Entry entry : elements.entrySet()) {
                void var2_2;
                self.add(entry.getElement(), var2_2.getCount());
            }
        } else {
            void var1_1;
            Multiset<E> multiset;
            Iterators.addAll(multiset, var1_1.iterator());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static boolean removeAllImpl(Multiset<?> self, Collection<?> elementsToRemove) {
        void var1_1;
        Multiset<?> multiset;
        void collection;
        collection = elementsToRemove instanceof Multiset ? ((Multiset)elementsToRemove).elementSet() : collection;
        return multiset.elementSet().removeAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean retainAllImpl(Multiset<?> self, Collection<?> elementsToRetain) {
        void var1_1;
        Multiset<?> multiset;
        void collection;
        Ascii.checkNotNull(elementsToRetain);
        collection = elementsToRetain instanceof Multiset ? ((Multiset)elementsToRetain).elementSet() : collection;
        return multiset.elementSet().retainAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <E> int setCountImpl(Multiset<E> self, E element, int count) {
        void var3_3;
        AbstractBiMap.1.checkNonnegative(count, "count");
        int oldCount = self.count(element);
        int delta = count - oldCount;
        if (delta > 0) {
            self.add(element, delta);
        } else if (delta < 0) {
            void var2_2;
            void var1_1;
            Multiset<E> multiset;
            multiset.remove(var1_1, (int)(-var2_2));
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static <E> boolean setCountImpl(Multiset<E> self, E element, int oldCount, int newCount) {
        void var2_2;
        AbstractBiMap.1.checkNonnegative(oldCount, "oldCount");
        AbstractBiMap.1.checkNonnegative(newCount, "newCount");
        if (self.count(element) == var2_2) {
            void var3_3;
            void var1_1;
            Multiset<void> multiset;
            multiset.setCount(var1_1, (int)var3_3);
            return true;
        }
        return false;
    }

    static <E> Iterator<E> iteratorImpl(Multiset<E> multiset) {
        Multiset<E> multiset2;
        return new MultisetIteratorImpl<E>(multiset, multiset2.entrySet().iterator());
    }

    /*
     * WARNING - void declaration
     */
    static int sizeImpl(Multiset<?> multiset) {
        void var1_1;
        long size = 0L;
        for (Multiset.Entry entry : multiset.entrySet()) {
            size += (long)entry.getCount();
        }
        return Ints.saturatedCast((long)var1_1);
    }

    static {
        new Ordering<Multiset.Entry<?>>(){};
    }

    static final class MultisetIteratorImpl<E>
    implements Iterator<E> {
        private final Multiset<E> multiset;
        private final Iterator<Multiset.Entry<E>> entryIterator;
        private Multiset.Entry<E> currentEntry;
        private int laterCount;
        private int totalCount;
        private boolean canRemove;

        /*
         * WARNING - void declaration
         */
        MultisetIteratorImpl(Multiset<E> multiset, Iterator<Multiset.Entry<E>> entryIterator) {
            void var2_2;
            void var1_1;
            this.multiset = var1_1;
            this.entryIterator = var2_2;
        }

        @Override
        public final boolean hasNext() {
            return this.laterCount > 0 || this.entryIterator.hasNext();
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.laterCount == 0) {
                this.currentEntry = this.entryIterator.next();
                this.totalCount = this.laterCount = this.currentEntry.getCount();
            }
            --this.laterCount;
            this.canRemove = true;
            return this.currentEntry.getElement();
        }

        @Override
        public final void remove() {
            boolean bl = this.canRemove;
            Ascii.checkState(bl, "no calls to next() since the last call to remove()");
            if (this.totalCount == 1) {
                this.entryIterator.remove();
            } else {
                this.multiset.remove(this.currentEntry.getElement());
            }
            --this.totalCount;
            this.canRemove = false;
        }
    }

    static abstract class EntrySet<E>
    extends Sets$ImprovedAbstractSet<Multiset.Entry<E>> {
        EntrySet() {
        }

        abstract Multiset<E> multiset();

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(@Nullable Object o) {
            if (o instanceof Multiset.Entry) {
                void var1_1;
                Multiset.Entry entry = (Multiset.Entry)o;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int n = this.multiset().count(entry.getElement());
                return n == var1_1.getCount();
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object object) {
            if (object instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)object;
                Object element = entry.getElement();
                int entryCount = entry.getCount();
                if (entryCount != 0) {
                    void var1_2;
                    void var2_3;
                    Multiset<void> multiset = this.multiset();
                    return multiset.setCount(var2_3, (int)var1_2, 0);
                }
            }
            return false;
        }

        @Override
        public void clear() {
            this.multiset().clear();
        }
    }

    static abstract class ElementSet<E>
    extends Sets$ImprovedAbstractSet<E> {
        ElementSet() {
        }

        abstract Multiset<E> multiset();

        @Override
        public void clear() {
            this.multiset().clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.multiset().contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            return this.multiset().containsAll((Collection<?>)var1_1);
        }

        @Override
        public boolean isEmpty() {
            return this.multiset().isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new TransformedIterator<Multiset.Entry<E>, E>(this, this.multiset().entrySet().iterator()){
                {
                    void var2_2;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            int count = this.multiset().count(o);
            if (count > 0) {
                void var2_2;
                void var1_1;
                this.multiset().remove(var1_1, (int)var2_2);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.multiset().entrySet().size();
        }
    }

    static abstract class AbstractEntry<E>
    implements Multiset.Entry<E> {
        AbstractEntry() {
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(@Nullable Object object) {
            if (object instanceof Multiset.Entry) {
                void var1_1;
                Multiset.Entry that = (Multiset.Entry)object;
                return this.getCount() == that.getCount() && Ascii.equal(this.getElement(), var1_1.getElement());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            Object e = this.getElement();
            return (e == null ? 0 : var1_1.hashCode()) ^ this.getCount();
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var2_2;
            String string;
            String text = String.valueOf(this.getElement());
            int n = this.getCount();
            if (n == 1) {
                return text;
            }
            string = String.valueOf(String.valueOf(string));
            return new StringBuilder(14 + string.length()).append(string).append(" x ").append((int)var2_2).toString();
        }
    }

    static final class ImmutableEntry<E>
    extends AbstractEntry<E>
    implements Serializable {
        @Nullable
        private E element;
        private int count;

        /*
         * WARNING - void declaration
         */
        ImmutableEntry(@Nullable E element, int count) {
            void var2_2;
            void var1_1;
            this.element = var1_1;
            this.count = count;
            AbstractBiMap.1.checkNonnegative((int)var2_2, "count");
        }

        @Override
        @Nullable
        public final E getElement() {
            return this.element;
        }

        @Override
        public final int getCount() {
            return this.count;
        }
    }
}

