/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.collect.ByFunctionOrdering;
import com.github.igorsuhorukov.google.common.collect.ComparatorOrdering;
import com.github.igorsuhorukov.google.common.collect.NaturalOrdering;
import com.github.igorsuhorukov.google.common.collect.ReverseOrdering;
import java.util.Comparator;
import javax.annotation.Nullable;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        Comparator<T> comparator2;
        if (comparator instanceof Ordering) {
            return (Ordering)comparator;
        }
        return new ComparatorOrdering<T>(comparator2);
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    /*
     * WARNING - void declaration
     */
    public final <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        void var1_1;
        return new ByFunctionOrdering(var1_1, this);
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);
}

