/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.base.Predicate;
import com.github.igorsuhorukov.google.common.collect.Cut;
import com.github.igorsuhorukov.google.common.collect.Ordering;
import java.io.Serializable;
import javax.annotation.Nullable;

public final class Range<C extends Comparable>
implements Predicate<C>,
Serializable {
    final Cut<C> lowerBound;
    final Cut<C> upperBound;

    /*
     * WARNING - void declaration
     */
    private Range(Cut<C> lowerBound, Cut<C> upperBound) {
        void var2_2;
        void var1_1;
        if (lowerBound.compareTo(upperBound) > 0 || lowerBound == Cut.aboveAll() || upperBound == Cut.belowAll()) {
            String string = String.valueOf(Range.toString(lowerBound, upperBound));
            throw new IllegalArgumentException(string.length() != 0 ? "Invalid range: ".concat(string) : new String("Invalid range: "));
        }
        this.lowerBound = (Cut)Ascii.checkNotNull(var1_1);
        this.upperBound = (Cut)Ascii.checkNotNull(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(@Nullable Object object) {
        if (object instanceof Range) {
            void var1_1;
            Range other = (Range)object;
            return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(var1_1.upperBound);
        }
        return false;
    }

    public final int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public final String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    /*
     * WARNING - void declaration
     */
    private static String toString(Cut<?> lowerBound, Cut<?> upperBound) {
        void var2_2;
        void var1_1;
        Cut<?> cut;
        StringBuilder sb = new StringBuilder(16);
        cut.describeAsLowerBound(sb);
        sb.append('\u2025');
        var1_1.describeAsUpperBound(sb);
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static int compareOrThrow(Comparable left, Comparable right) {
        void var1_1;
        return left.compareTo(var1_1);
    }

    static {
        new Function<Range, Cut>(){};
        new Function<Range, Cut>(){};
        new Ordering<Range<?>>(){};
        new Range(Cut.belowAll(), Cut.aboveAll());
    }
}

