/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import java.util.List;
import javax.annotation.Nullable;

final class SingletonImmutableList<E>
extends ImmutableList<E> {
    private transient E element;

    /*
     * WARNING - void declaration
     */
    SingletonImmutableList(E element) {
        void var1_1;
        this.element = Ascii.checkNotNull(var1_1);
    }

    @Override
    public final E get(int index) {
        Ascii.checkElementIndex(index, 1);
        return this.element;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(@Nullable Object object) {
        void var1_1;
        if (this.element.equals(var1_1)) {
            return 0;
        }
        return -1;
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lastIndexOf(@Nullable Object object) {
        void var1_1;
        return this.indexOf(var1_1);
    }

    @Override
    public final int size() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableList<E> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        Ascii.checkPositionIndexes(fromIndex, toIndex, 1);
        if (var1_1 == var2_2) {
            return ImmutableList.of();
        }
        return this;
    }

    @Override
    public final ImmutableList<E> reverse() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(@Nullable Object object) {
        void var1_1;
        return this.element.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof List) {
            void var1_1;
            List that = (List)object;
            return that.size() == 1 && this.element.equals(var1_1.get(0));
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return 31 + this.element.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        String elementToString = this.element.toString();
        return new StringBuilder(elementToString.length() + 2).append('[').append((String)var1_1).append(']').toString();
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        dst[offset] = this.element;
        return (int)(var2_2 + true);
    }
}

