/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.collect.ImmutableCollection;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableSet;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.collect.RegularImmutableTable;
import com.github.igorsuhorukov.google.common.collect.Table;
import java.util.AbstractCollection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
final class SparseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    private final ImmutableMap<R, Map<C, V>> rowMap;
    private final ImmutableMap<C, Map<R, V>> columnMap;
    private final int[] iterationOrderRow;
    private final int[] iterationOrderColumn;

    /*
     * WARNING - void declaration
     */
    SparseImmutableTable(ImmutableList<Table.Cell<R, C, V>> cellList, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
        void var2_2;
        void var3_3;
        Object rowIndex = Maps.newHashMap();
        LinkedHashMap rows = Maps.newLinkedHashMap();
        for (Object row : rowSpace) {
            rowIndex.put(row, rows.size());
            rows.put(row, new LinkedHashMap());
        }
        Object columns = Maps.newLinkedHashMap();
        for (Object col : columnSpace) {
            columns.put(col, new LinkedHashMap());
        }
        int[] iterationOrderRow = new int[((AbstractCollection)cellList).size()];
        Object iterationOrderColumn = new int[((AbstractCollection)cellList).size()];
        for (int i = 0; i < ((AbstractCollection)cellList).size(); ++i) {
            Table.Cell cell = (Table.Cell)cellList.get(i);
            Object rowKey = cell.getRowKey();
            Object columnKey = cell.getColumnKey();
            Object value = cell.getValue();
            iterationOrderRow[i] = (Integer)rowIndex.get(rowKey);
            Map thisRow = (Map)rows.get(rowKey);
            iterationOrderColumn[i] = thisRow.size();
            Object oldValue = thisRow.put(columnKey, value);
            if (oldValue != null) {
                cellList = String.valueOf(String.valueOf(rowKey));
                columns = String.valueOf(String.valueOf(columnKey));
                iterationOrderColumn = String.valueOf(String.valueOf(value));
                rowIndex = String.valueOf(String.valueOf(oldValue));
                throw new IllegalArgumentException(new StringBuilder(37 + ((String)cellList).length() + ((String)columns).length() + ((String)iterationOrderColumn).length() + ((String)rowIndex).length()).append("Duplicate value for row=").append((String)cellList).append(", column=").append((String)columns).append(": ").append((String)iterationOrderColumn).append(", ").append((String)rowIndex).toString());
            }
            ((Map)columns.get(columnKey)).put(rowKey, value);
        }
        this.iterationOrderRow = iterationOrderRow;
        this.iterationOrderColumn = var3_3;
        ImmutableMap.Builder rowBuilder = ImmutableMap.builder();
        for (Map.Entry row : rows.entrySet()) {
            rowBuilder.put(row.getKey(), ImmutableMap.copyOf((Map)row.getValue()));
        }
        this.rowMap = rowBuilder.build();
        ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
        for (Map.Entry col : var2_2.entrySet()) {
            columnBuilder.put(col.getKey(), ImmutableMap.copyOf((Map)col.getValue()));
        }
        this.columnMap = columnBuilder.build();
    }

    @Override
    public final ImmutableMap<C, Map<R, V>> columnMap() {
        return this.columnMap;
    }

    @Override
    public final ImmutableMap<R, Map<C, V>> rowMap() {
        return this.rowMap;
    }

    @Override
    public final int size() {
        return this.iterationOrderRow.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Table.Cell<R, C, V> getCell(int index) {
        void var1_2;
        void var2_4;
        void var3_5;
        int rowIndex = this.iterationOrderRow[index];
        Map.Entry rowEntry = (Map.Entry)((ImmutableCollection)((Object)this.rowMap.entrySet())).asList().get(rowIndex);
        ImmutableMap row = (ImmutableMap)rowEntry.getValue();
        int columnIndex = this.iterationOrderColumn[index];
        Map.Entry colEntry = (Map.Entry)((ImmutableCollection)((Object)var3_5.entrySet())).asList().get(columnIndex);
        return SparseImmutableTable.cellOf(var2_4.getKey(), colEntry.getKey(), var1_2.getValue());
    }
}

