/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.base.Supplier;
import com.github.igorsuhorukov.google.common.collect.AbstractTable;
import com.github.igorsuhorukov.google.common.collect.Collections2;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.collect.Sets$ImprovedAbstractSet;
import com.github.igorsuhorukov.google.common.collect.Table;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class StandardTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    final Map<R, Map<C, V>> backingMap;
    private Supplier<? extends Map<C, V>> factory;
    private transient Map<R, Map<C, V>> rowMap;

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsRow(@Nullable Object rowKey) {
        void var1_1;
        return rowKey != null && Maps.safeContainsKey(this.backingMap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        void var2_2;
        void var1_1;
        if (rowKey == null || columnKey == null) {
            return null;
        }
        return super.get(var1_1, var2_2);
    }

    @Override
    public final boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int size() {
        void var1_1;
        int size = 0;
        for (Map<C, V> map : this.backingMap.values()) {
            void var3_3;
            size += var3_3.size();
        }
        return (int)var1_1;
    }

    @Override
    public final void clear() {
        this.backingMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(R rowKey, C columnKey, V value) {
        void var3_3;
        void var2_2;
        StandardTable standardTable;
        Ascii.checkNotNull(rowKey);
        Ascii.checkNotNull(columnKey);
        Ascii.checkNotNull(value);
        void var4_4 = standardTable;
        standardTable = this;
        Map<C, void> map = standardTable.backingMap.get(var4_4);
        if (map == null) {
            map = standardTable.factory.get();
            standardTable.backingMap.put(var4_4, map);
        }
        return map.put(var2_2, var3_3);
    }

    @Override
    public final Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    @Override
    final Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new CellIterator(this, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<C, V> row(R rowKey) {
        void var1_1;
        return new Row(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<R, Map<C, V>> rowMap() {
        void var1_1;
        Map<R, Map<C, V>> result = this.rowMap;
        if (result == null) {
            result = this;
            this.rowMap = (StandardTable)((Object)result).new RowMap();
            return this.rowMap;
        }
        return var1_1;
    }

    final class RowMap
    extends Maps.ImprovedAbstractMap<R, Map<C, V>> {
        RowMap() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return StandardTable.this.containsRow(var1_1);
        }

        @Override
        protected final Set<Map.Entry<R, Map<C, V>>> createEntrySet() {
            return new EntrySet();
        }

        /*
         * Signature claims super is com.github.igorsuhorukov.google.common.collect.StandardTable$com.google.common.collect.StandardTable$TableSet<java.util.Map$Entry<R, java.util.Map<C, V>>>, not com.github.igorsuhorukov.google.common.collect.StandardTable$TableSet - discarding signature.
         */
        final class EntrySet
        extends TableSet {
            EntrySet() {
                super(StandardTable.this, (byte)0);
            }

            @Override
            public final Iterator<Map.Entry<R, Map<C, V>>> iterator() {
                return Maps.asMapEntryIterator(StandardTable.this.backingMap.keySet(), new Function<R, Map<C, V>>(this){
                    private /* synthetic */ EntrySet this$2;
                    {
                        this.this$2 = entrySet;
                    }
                });
            }

            @Override
            public final int size() {
                return StandardTable.this.backingMap.size();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean contains(Object obj) {
                if (obj instanceof Map.Entry) {
                    void var1_1;
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && Collections2.safeContains(StandardTable.this.backingMap.entrySet(), var1_1);
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean remove(Object obj) {
                if (obj instanceof Map.Entry) {
                    void var1_1;
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && StandardTable.this.backingMap.entrySet().remove(var1_1);
                }
                return false;
            }
        }
    }

    final class Row
    extends Maps.ImprovedAbstractMap<C, V> {
        private R rowKey;
        private Map<C, V> backingRowMap;
        private /* synthetic */ StandardTable this$0;

        /*
         * WARNING - void declaration
         */
        Row(StandardTable standardTable, R rowKey) {
            void var2_2;
            this.this$0 = standardTable;
            this.rowKey = Ascii.checkNotNull(var2_2);
        }

        final Map<C, V> backingRowMap() {
            if (this.backingRowMap == null || this.backingRowMap.isEmpty() && this.this$0.backingMap.containsKey(this.rowKey)) {
                Row row = this;
                this.backingRowMap = row.this$0.backingMap.get(row.rowKey);
                return this.backingRowMap;
            }
            return this.backingRowMap;
        }

        final void maintainEmptyInvariant() {
            if (this.backingRowMap() != null && this.backingRowMap.isEmpty()) {
                this.this$0.backingMap.remove(this.rowKey);
                this.backingRowMap = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            void var2_2;
            Map backingRowMap = this.backingRowMap();
            return key != null && backingRowMap != null && Maps.safeContainsKey(var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(Object key) {
            Map backingRowMap = this.backingRowMap();
            if (key != null && backingRowMap != null) {
                void var1_1;
                void var2_2;
                return Maps.safeGet(var2_2, var1_1);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V put(C key, V value) {
            void var2_2;
            void var1_1;
            Ascii.checkNotNull(key);
            Ascii.checkNotNull(value);
            if (this.backingRowMap != null && !this.backingRowMap.isEmpty()) {
                return this.backingRowMap.put(key, value);
            }
            return this.this$0.put(this.rowKey, var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V remove(Object key) {
            void var1_1;
            void var2_2;
            Map backingRowMap = this.backingRowMap();
            if (backingRowMap == null) {
                return null;
            }
            Object result = Maps.safeRemove(var2_2, key);
            this.maintainEmptyInvariant();
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void clear() {
            Map backingRowMap = this.backingRowMap();
            if (backingRowMap != null) {
                void var1_1;
                var1_1.clear();
            }
            this.maintainEmptyInvariant();
        }

        @Override
        protected final Set<Map.Entry<C, V>> createEntrySet() {
            return new RowEntrySet(0);
        }

        final class RowEntrySet
        extends Maps.EntrySet<C, V> {
            private RowEntrySet() {
            }

            @Override
            final Map<C, V> map() {
                return Row.this;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int size() {
                void var1_1;
                Map map = Row.this.backingRowMap();
                if (map == null) {
                    return 0;
                }
                return var1_1.size();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Iterator<Map.Entry<C, V>> iterator() {
                void var1_1;
                Map map = Row.this.backingRowMap();
                if (map == null) {
                    return Iterators.emptyModifiableIterator();
                }
                Iterator iterator = map.entrySet().iterator();
                return new Iterator<Map.Entry<C, V>>(this, (Iterator)var1_1){
                    private /* synthetic */ Iterator val$iterator;
                    private /* synthetic */ RowEntrySet this$2;
                    {
                        this.this$2 = rowEntrySet;
                        this.val$iterator = iterator;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.val$iterator.hasNext();
                    }

                    @Override
                    public final void remove() {
                        this.val$iterator.remove();
                        this.this$2.Row.this.maintainEmptyInvariant();
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            /* synthetic */ RowEntrySet(byte by) {
                this();
                void var1_1;
            }
        }
    }

    final class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        private Iterator<Map.Entry<R, Map<C, V>>> rowIterator;
        private Map.Entry<R, Map<C, V>> rowEntry;
        private Iterator<Map.Entry<C, V>> columnIterator;
        private /* synthetic */ StandardTable this$0;

        private CellIterator(StandardTable standardTable) {
            this.this$0 = standardTable;
            this.rowIterator = this.this$0.backingMap.entrySet().iterator();
            this.columnIterator = Iterators.emptyModifiableIterator();
        }

        @Override
        public final boolean hasNext() {
            return this.rowIterator.hasNext() || this.columnIterator.hasNext();
        }

        @Override
        public final void remove() {
            this.columnIterator.remove();
            if (this.rowEntry.getValue().isEmpty()) {
                this.rowIterator.remove();
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ CellIterator(StandardTable x0, byte by) {
            this((StandardTable)var1_1);
            void var1_1;
        }
    }

    abstract class TableSet<T>
    extends Sets$ImprovedAbstractSet<T> {
        private /* synthetic */ StandardTable this$0;

        private TableSet(StandardTable standardTable) {
            this.this$0 = standardTable;
        }

        @Override
        public boolean isEmpty() {
            return this.this$0.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            this.this$0.backingMap.clear();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ TableSet(StandardTable x0, byte by) {
            this((StandardTable)var1_1);
            void var1_1;
        }
    }
}

