/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.util.concurrent;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.util.concurrent.ExecutionList;
import com.github.igorsuhorukov.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import javax.annotation.Nullable;

public abstract class AbstractFuture<V>
implements ListenableFuture<V> {
    private final Sync<V> sync = new Sync();
    private final ExecutionList executionList = new ExecutionList();

    protected AbstractFuture() {
    }

    /*
     * WARNING - void declaration
     */
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        void var1_1;
        void var3_2;
        return this.sync.get(var3_2.toNanos((long)var1_1));
    }

    public V get() throws InterruptedException, ExecutionException {
        return this.sync.get();
    }

    public boolean isDone() {
        return this.sync.isDone();
    }

    public boolean isCancelled() {
        return this.sync.isCancelled();
    }

    /*
     * WARNING - void declaration
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        void var1_1;
        if (!this.sync.cancel((boolean)var1_1)) {
            return false;
        }
        this.executionList.execute();
        return true;
    }

    protected final boolean wasInterrupted() {
        return this.sync.wasInterrupted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addListener(Runnable listener, Executor exec) {
        void var2_2;
        void var1_1;
        this.executionList.add((Runnable)var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean set(@Nullable V value) {
        void var1_2;
        boolean result = this.sync.set(value);
        if (result) {
            this.executionList.execute();
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setException(Throwable throwable) {
        void var1_2;
        boolean result = this.sync.setException(Ascii.checkNotNull(throwable));
        if (result) {
            this.executionList.execute();
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static final CancellationException cancellationExceptionWithCause(@Nullable String message, @Nullable Throwable cause) {
        CancellationException cancellationException;
        void var1_1;
        CancellationException exception = new CancellationException(message);
        exception.initCause((Throwable)var1_1);
        return cancellationException;
    }

    static final class Sync<V>
    extends AbstractQueuedSynchronizer {
        private V value;
        private Throwable exception;

        Sync() {
        }

        @Override
        protected final int tryAcquireShared(int ignored) {
            if (this.isDone()) {
                return 1;
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final boolean tryReleaseShared(int finalState) {
            void var1_1;
            this.setState((int)var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        final V get(long nanos) throws TimeoutException, CancellationException, ExecutionException, InterruptedException {
            void var1_1;
            if (!this.tryAcquireSharedNanos(-1, (long)var1_1)) {
                throw new TimeoutException("Timeout waiting for task.");
            }
            return this.getValue();
        }

        final V get() throws CancellationException, ExecutionException, InterruptedException {
            this.acquireSharedInterruptibly(-1);
            return this.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private V getValue() throws CancellationException, ExecutionException {
            void var1_1;
            int state = this.getState();
            switch (state) {
                case 2: {
                    if (this.exception != null) {
                        throw new ExecutionException(this.exception);
                    }
                    return this.value;
                }
                case 4: 
                case 8: {
                    throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", this.exception);
                }
            }
            throw new IllegalStateException(new StringBuilder(49).append("Error, synchronizer in invalid state: ").append((int)var1_1).toString());
        }

        final boolean isDone() {
            return (this.getState() & 0xE) != 0;
        }

        final boolean isCancelled() {
            return (this.getState() & 0xC) != 0;
        }

        final boolean wasInterrupted() {
            return this.getState() == 8;
        }

        /*
         * WARNING - void declaration
         */
        final boolean set(@Nullable V v) {
            void var1_1;
            return this.complete(var1_1, null, 2);
        }

        /*
         * WARNING - void declaration
         */
        final boolean setException(Throwable t) {
            void var1_1;
            return this.complete(null, (Throwable)var1_1, 2);
        }

        /*
         * WARNING - void declaration
         */
        final boolean cancel(boolean interrupt) {
            void var1_1;
            return this.complete(null, null, var1_1 != false ? 8 : 4);
        }

        /*
         * WARNING - void declaration
         */
        private boolean complete(@Nullable V v, @Nullable Throwable t, int finalState) {
            boolean doCompletion = this.compareAndSetState(0, 1);
            if (doCompletion) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.value = var1_1;
                this.exception = (finalState & 0xC) != 0 ? new CancellationException("Future.cancel() was called.") : var2_2;
                this.releaseShared((int)var3_3);
            } else if (this.getState() == 1) {
                this.acquireShared(-1);
            }
            return doCompletion;
        }
    }
}

