/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.util.concurrent;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.util.concurrent.MoreExecutors$DirectExecutor;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class ExecutionList {
    private static Logger log = Logger.getLogger(ExecutionList.class.getName());
    @GuardedBy(value="this")
    private RunnableExecutorPair runnables;
    @GuardedBy(value="this")
    private boolean executed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void add(Runnable runnable, Executor executor) {
        void var2_3;
        void var1_1;
        Ascii.checkNotNull(runnable, "Runnable was null.");
        Ascii.checkNotNull(executor, "Executor was null.");
        ExecutionList executionList = this;
        synchronized (executionList) {
            if (!this.executed) {
                this.runnables = new RunnableExecutorPair(runnable, executor, this.runnables);
                return;
            }
        }
        ExecutionList.executeListener((Runnable)var1_1, (Executor)var2_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void execute() {
        RunnableExecutorPair list;
        ExecutionList executionList = this;
        synchronized (executionList) {
            if (this.executed) {
                return;
            }
            this.executed = true;
            list = this.runnables;
            this.runnables = null;
        }
        RunnableExecutorPair reversedList = null;
        while (list != null) {
            void var3_4;
            RunnableExecutorPair tmp = list;
            list = list.next;
            tmp.next = reversedList;
            reversedList = var3_4;
        }
        while (reversedList != null) {
            ExecutionList.executeListener(reversedList.runnable, reversedList.executor);
            reversedList = reversedList.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (RuntimeException e) {
            void var2_2;
            String string;
            String string2;
            string2 = String.valueOf(String.valueOf(string2));
            string = String.valueOf(String.valueOf(string));
            log.log(Level.SEVERE, new StringBuilder(57 + string2.length() + string.length()).append("RuntimeException while executing runnable ").append(string2).append(" with executor ").append(string).toString(), (Throwable)var2_2);
            return;
        }
    }

    public static final class RunnableExecutorPair {
        final Runnable runnable;
        final Executor executor;
        @Nullable
        RunnableExecutorPair next;

        /*
         * WARNING - void declaration
         */
        RunnableExecutorPair(Runnable runnable, Executor executor, RunnableExecutorPair next) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.runnable = var1_1;
            this.executor = var2_2;
            this.next = var3_3;
        }

        public static Executor directExecutor() {
            return MoreExecutors$DirectExecutor.INSTANCE;
        }
    }
}

