/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.jodd.util;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.jodd.core.JoddCore;
import com.github.igorsuhorukov.jodd.util.ReflectUtil;
import com.github.igorsuhorukov.jodd.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    private static final String[] MANIFESTS = new String[]{"Manifest.mf", "manifest.mf", "MANIFEST.MF"};

    /*
     * WARNING - void declaration
     */
    public static ClassLoader getDefaultClassLoader() {
        void var0;
        Object cl = ClassLoaderUtil.getContextClassLoader();
        if (cl == null) {
            cl = ReflectUtil.getCallerClass(2);
            cl = ((Class)cl).getClassLoader();
        }
        return var0;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        ClassLoader classLoader2;
        Thread.currentThread().setContextClassLoader(classLoader2);
    }

    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    /*
     * WARNING - void declaration
     */
    public static void addFileToClassPath(File path, ClassLoader classLoader) {
        try {
            ClassLoaderUtil.addUrlToClassPath(Ascii.toURL(path), classLoader);
            return;
        }
        catch (MalformedURLException muex) {
            void var1_2;
            File file;
            throw new IllegalArgumentException("Invalid path: " + file, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addUrlToClassPath(URL url, ClassLoader classLoader) {
        try {
            ReflectUtil.invokeDeclared(URLClassLoader.class, classLoader, "addURL", new Class[]{URL.class}, new Object[]{url});
            return;
        }
        catch (Exception ex) {
            void var1_2;
            URL uRL;
            throw new IllegalArgumentException("Add URL failed: " + uRL, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Class defineClass(String className, byte[] classData) {
        void var1_1;
        return ClassLoaderUtil.defineClass(className, (byte[])var1_1, ClassLoaderUtil.getDefaultClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    public static Class defineClass(String className, byte[] classData, ClassLoader classLoader) {
        try {
            void var2_3;
            return (Class)ReflectUtil.invokeDeclared(ClassLoader.class, var2_3, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{className, classData, 0, classData.length});
        }
        catch (Throwable th) {
            void var1_2;
            String string;
            throw new RuntimeException("Define class failed: " + string, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Class findClass(String className, File[] classPath, ClassLoader parent) {
        void var2_2;
        String string;
        URL[] urls = new URL[classPath.length];
        for (int i = 0; i < classPath.length; ++i) {
            File file = classPath[i];
            try {
                urls[i] = Ascii.toURL(file);
                continue;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return ClassLoaderUtil.findClass(string, (URL[])var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Class findClass(String className, URL[] classPath, ClassLoader parent) {
        void var2_3;
        URLClassLoader tempClassLoader = parent != null ? new URLClassLoader(classPath, (ClassLoader)var2_3) : new URLClassLoader(classPath);
        try {
            return (Class)ReflectUtil.invokeDeclared(URLClassLoader.class, tempClassLoader, "findClass", new Class[]{String.class}, new Object[]{className});
        }
        catch (Throwable th) {
            void var1_2;
            String string;
            throw new RuntimeException("Class not found: " + string, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File findToolsJar() {
        String tools = new File(SystemUtil.getJavaHome()).getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "tools.jar";
        File toolsFile = new File(tools);
        if (toolsFile.exists()) {
            void var0;
            return var0;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest getClasspathItemManifest(File classpathItem) {
        void var3_9;
        File file;
        void var1_1;
        Manifest manifest = null;
        if (((File)classpathItem).isFile()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream((File)classpathItem);
                    classpathItem = new JarFile((File)classpathItem);
                    manifest = ((JarFile)classpathItem).getManifest();
                }
                catch (IOException iOException) {
                    Object var4_5 = null;
                    Ascii.close(fis);
                    return var1_1;
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                Ascii.close(fis);
                throw throwable;
            }
            Ascii.close(fis);
            return var1_1;
        }
        File metaDir = new File((File)classpathItem, "META-INF");
        File manifestFile = null;
        if (metaDir.isDirectory()) {
            String[] arr$ = MANIFESTS;
            int len$ = MANIFESTS.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String m = arr$[i$];
                File mFile = new File(metaDir, m);
                if (!mFile.isFile()) continue;
                manifestFile = mFile;
                break;
            }
        }
        if (manifestFile == null) return var1_1;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                manifest = new Manifest(fis);
            }
            catch (IOException iOException) {
                file = null;
                Ascii.close((InputStream)var3_9);
                return var1_1;
            }
            file = null;
        }
        catch (Throwable throwable) {
            file = null;
            Ascii.close((InputStream)var3_9);
            throw throwable;
        }
        Ascii.close((InputStream)var3_9);
        return var1_1;
    }

    public static String getClasspathItemBaseDir(File classpathItem) {
        String string;
        String base;
        base = classpathItem.isFile() ? classpathItem.getParent() : ((File)((Object)base)).toString();
        return string;
    }

    public static File[] getDefaultClasspath() {
        return ClassLoaderUtil.getDefaultClasspath(ClassLoaderUtil.getDefaultClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    public static File[] getDefaultClasspath(ClassLoader classLoader) {
        void var1_2;
        URL[] uRLArray;
        TreeSet<File> classpaths = new TreeSet<File>();
        while (classLoader != null) {
            if (classLoader instanceof URLClassLoader) {
                URL[] arr$ = uRLArray = ((URLClassLoader)classLoader).getURLs();
                int len$ = uRLArray.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    URL uRL = arr$[i$];
                    File f = Ascii.toFile(uRL);
                    if (f == null || !f.exists()) continue;
                    try {
                        f = f.getCanonicalFile();
                        boolean bl = classpaths.add(f);
                        if (!bl) continue;
                        ClassLoaderUtil.addInnerClasspathItems(classpaths, f);
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
            classLoader = classLoader.getParent();
        }
        String[] bootstrap = SystemUtil.getSunBoothClassPath();
        if (bootstrap != null) {
            String[] arr$ = bootstrap = Ascii.splitc((String)bootstrap, File.pathSeparatorChar);
            int len$ = bootstrap.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String bootstrapFile = arr$[i$];
                File f = new File(bootstrapFile);
                if (!f.exists()) continue;
                try {
                    f = f.getCanonicalFile();
                    boolean bl = classpaths.add(f);
                    if (!bl) continue;
                    ClassLoaderUtil.addInnerClasspathItems(classpaths, f);
                    continue;
                }
                catch (IOException iOException) {}
            }
        }
        File[] result = new File[classpaths.size()];
        return (File[])var1_2.toArray(uRLArray);
    }

    private static void addInnerClasspathItems(Set<File> classpaths, File item) {
        Manifest manifest = ClassLoaderUtil.getClasspathItemManifest(item);
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return;
        }
        String[] s = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (s == null) {
            return;
        }
        String base = ClassLoaderUtil.getClasspathItemBaseDir(item);
        String[] arr$ = s = Ascii.splitc((String)s, ' ');
        int len$ = s.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File file;
            String t = arr$[i$];
            try {
                File file2 = new File(base, t);
                file = file2.getCanonicalFile();
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception exception) {
                file = null;
            }
            if (file == null) {
                try {
                    file = new File(t);
                    file = file.getCanonicalFile();
                    if (!file.exists()) {
                        file = null;
                    }
                }
                catch (Exception exception) {
                    file = null;
                }
            }
            if (file == null) {
                try {
                    URL url = new URL(t);
                    file = new File(url.getFile());
                    file = file.getCanonicalFile();
                    if (!file.exists()) {
                        file = null;
                    }
                }
                catch (Exception exception) {
                    file = null;
                }
            }
            if (file == null || !file.exists()) continue;
            classpaths.add(file);
        }
    }

    public static URL getResourceUrl(String resourceName) {
        return ClassLoaderUtil.getResourceUrl(resourceName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static URL getResourceUrl(String resourceName, ClassLoader classLoader) {
        String string;
        void var3_3;
        void var1_1;
        Serializable resourceUrl;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if (classLoader != null && (resourceUrl = classLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentThreadClassLoader != null && currentThreadClassLoader != classLoader && (resourceUrl = currentThreadClassLoader.getResource(resourceName)) != null) {
            return resourceUrl;
        }
        resourceUrl = ReflectUtil.getCallerClass(2);
        ClassLoader callerClassLoader = ((Class)resourceUrl).getClassLoader();
        if (callerClassLoader != var1_1 && callerClassLoader != var3_3 && (resourceUrl = callerClassLoader.getResource(string)) != null) {
            void var2_2;
            return var2_2;
        }
        return null;
    }

    public static File getResourceFile(String resourceName) {
        return ClassLoaderUtil.getResourceFile(resourceName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static File getResourceFile(String resourceName, ClassLoader classLoader) {
        try {
            void var1_1;
            String string;
            return new File(ClassLoaderUtil.getResourceUrl(string, (ClassLoader)var1_1).toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resourceName) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(resourceName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getResourceAsStream(String resourceName, boolean useCache) throws IOException {
        void var1_1;
        return ClassLoaderUtil.getResourceAsStream(resourceName, null, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass) throws IOException {
        void var1_1;
        URL url = ClassLoaderUtil.getResourceUrl(resourceName, (ClassLoader)var1_1);
        if (url != null) {
            URL uRL;
            return uRL.openStream();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getResourceAsStream(String resourceName, ClassLoader callingClass, boolean useCache) throws IOException {
        void var1_1;
        URLConnection url = ClassLoaderUtil.getResourceUrl(resourceName, (ClassLoader)var1_1);
        if (url != null) {
            URLConnection uRLConnection;
            void var2_2;
            URLConnection urlConnection = ((URL)((Object)url)).openConnection();
            urlConnection.setUseCaches((boolean)var2_2);
            return uRLConnection.getInputStream();
        }
        return null;
    }

    public static InputStream getClassAsStream(Class clazz) throws IOException {
        Class clazz2;
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(clazz), clazz2.getClassLoader());
    }

    public static InputStream getClassAsStream(String className) throws IOException {
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(className));
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getClassAsStream(String className, ClassLoader classLoader) throws IOException {
        void var1_1;
        return ClassLoaderUtil.getResourceAsStream(ClassLoaderUtil.getClassFileName(className), (ClassLoader)var1_1);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        String string;
        return JoddCore.classLoaderStrategy.loadClass(string, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        void var1_1;
        String string;
        return JoddCore.classLoaderStrategy.loadClass(string, (ClassLoader)var1_1);
    }

    public static String getClassFileName(Class clazz) {
        Class clazz2;
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return ClassLoaderUtil.getClassFileName(clazz2.getName());
    }

    public static String getClassFileName(String className) {
        String string;
        return string.replace('.', '/') + ".class";
    }
}

