/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.sonatype.plexus.components.sec.dispatcher;

import com.github.igorsuhorukov.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import com.github.igorsuhorukov.sonatype.plexus.components.sec.dispatcher.model.Config;
import com.github.igorsuhorukov.sonatype.plexus.components.sec.dispatcher.model.ConfigProperty;
import com.github.igorsuhorukov.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;
import com.github.igorsuhorukov.sonatype.plexus.components.sec.dispatcher.model.io.xpp3.SecurityConfigurationXpp3Reader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SecUtil {
    public static final String PROTOCOL_DELIM = "://";
    public static final int PROTOCOL_DELIM_LEN = "://".length();
    public static final String[] URL_PROTOCOLS = new String[]{"http", "https", "dav", "file", "davs", "webdav", "webdavs", "dav+http", "dav+https"};

    /*
     * Loose catch block
     */
    public static SettingsSecurity read(String location, boolean cycle) throws SecDispatcherException {
        SettingsSecurity settingsSecurity;
        InputStream in;
        block12: {
            SettingsSecurity sec;
            block10: {
                SettingsSecurity settingsSecurity2;
                block11: {
                    if (location == null) {
                        throw new SecDispatcherException("location to read from is null");
                    }
                    in = null;
                    in = SecUtil.toStream(location);
                    sec = new SecurityConfigurationXpp3Reader().read(in);
                    in.close();
                    if (!cycle || sec.getRelocation() == null) break block10;
                    settingsSecurity2 = SecUtil.read(sec.getRelocation(), true);
                    Object var6_7 = null;
                    if (in == null) break block11;
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return settingsSecurity2;
            }
            settingsSecurity = sec;
            Object var6_8 = null;
            if (in == null) break block12;
            try {
                in.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return settingsSecurity;
        catch (Exception e) {
            try {
                throw new SecDispatcherException(e);
            }
            catch (Throwable throwable) {
                block13: {
                    Object var6_9 = null;
                    if (in == null) break block13;
                    try {
                        in.close();
                    }
                    catch (Exception e2) {}
                }
                throw throwable;
            }
        }
    }

    private static InputStream toStream(String resource) throws MalformedURLException, IOException {
        if (resource == null) {
            return null;
        }
        int ind = resource.indexOf(PROTOCOL_DELIM);
        if (ind > 1) {
            String protocol = resource.substring(0, ind);
            resource = resource.substring(ind + PROTOCOL_DELIM_LEN);
            for (int i = 0; i < URL_PROTOCOLS.length; ++i) {
                String p = URL_PROTOCOLS[i];
                if (!protocol.regionMatches(true, 0, p, 0, p.length())) continue;
                return new URL(p + PROTOCOL_DELIM + resource).openStream();
            }
        }
        return new FileInputStream(new File(resource));
    }

    public static Map getConfig(SettingsSecurity sec, String name) {
        if (name == null) {
            return null;
        }
        List cl = sec.getConfigurations();
        if (cl == null) {
            return null;
        }
        Iterator i = cl.iterator();
        while (i.hasNext()) {
            Config cf = (Config)i.next();
            if (!name.equals(cf.getName())) continue;
            List pl = cf.getProperties();
            if (pl == null || pl.isEmpty()) {
                return null;
            }
            HashMap<String, String> res = new HashMap<String, String>(pl.size());
            Iterator j = pl.iterator();
            while (j.hasNext()) {
                ConfigProperty p = (ConfigProperty)j.next();
                res.put(p.getName(), p.getValue());
            }
            return res;
        }
        return null;
    }
}

