/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.springframework.boot.cli.compiler;

import com.github.igorsuhorukov.apache.maven.settings.Settings;
import com.github.igorsuhorukov.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import com.github.igorsuhorukov.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import com.github.igorsuhorukov.apache.maven.settings.building.SettingsBuildingException;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.grape.RepositoryConfiguration;
import com.github.igorsuhorukov.springframework.util.StringUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public final class RepositoryConfigurationFactory {
    private static final RepositoryConfiguration MAVEN_CENTRAL = new RepositoryConfiguration("central", URI.create("http://repo1.maven.org/maven2/"), false);
    private static final RepositoryConfiguration SPRING_MILESTONE = new RepositoryConfiguration("spring-milestone", URI.create("http://repo.spring.io/milestone"), false);
    private static final RepositoryConfiguration SPRING_SNAPSHOT = new RepositoryConfiguration("spring-snapshot", URI.create("http://repo.spring.io/snapshot"), true);

    /*
     * WARNING - void declaration
     */
    public static List<RepositoryConfiguration> createDefaultRepositoryConfiguration() {
        void var0;
        ArrayList<RepositoryConfiguration> repositoryConfiguration = new ArrayList<RepositoryConfiguration>();
        repositoryConfiguration.add(MAVEN_CENTRAL);
        if (!Boolean.getBoolean("disableSpringSnapshotRepos")) {
            repositoryConfiguration.add(SPRING_MILESTONE);
            repositoryConfiguration.add(SPRING_SNAPSHOT);
        }
        RepositoryConfigurationFactory.addDefaultCacheAsRespository(repositoryConfiguration);
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static void addDefaultCacheAsRespository(List<RepositoryConfiguration> repositoryConfiguration) {
        RepositoryConfiguration repository = new RepositoryConfiguration("local", RepositoryConfigurationFactory.getLocalRepositoryDirectory().toURI(), true);
        if (!repositoryConfiguration.contains(repository)) {
            void var1_1;
            List<RepositoryConfiguration> list;
            list.add(0, (RepositoryConfiguration)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static File getLocalRepositoryDirectory() {
        String localRepository = RepositoryConfigurationFactory.loadSettings().getLocalRepository();
        if (StringUtils.hasText(localRepository)) {
            void var0;
            return new File((String)var0);
        }
        return new File(RepositoryConfigurationFactory.getM2HomeDirectory(), "repository");
    }

    /*
     * WARNING - void declaration
     */
    private static Settings loadSettings() {
        File settingsFile = new File(System.getProperty("user.home"), ".m2/settings.xml");
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(settingsFile);
        request.setSystemProperties(System.getProperties());
        try {
            return new DefaultSettingsBuilderFactory().newInstance().build(request).getEffectiveSettings();
        }
        catch (SettingsBuildingException ex) {
            void var1_2;
            void var0;
            throw new IllegalStateException("Failed to build settings from " + var0, (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static File getM2HomeDirectory() {
        String mavenRoot = System.getProperty("maven.home");
        if (StringUtils.hasLength(mavenRoot)) {
            void var0;
            return new File((String)var0);
        }
        return new File(System.getProperty("user.home"), ".m2");
    }
}

