/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.springframework.boot.cli.compiler.grape;

import com.github.igorsuhorukov.apache.maven.settings.Mirror;
import com.github.igorsuhorukov.apache.maven.settings.Server;
import com.github.igorsuhorukov.apache.maven.settings.Settings;
import com.github.igorsuhorukov.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import com.github.igorsuhorukov.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import com.github.igorsuhorukov.apache.maven.settings.building.SettingsBuildingException;
import com.github.igorsuhorukov.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import com.github.igorsuhorukov.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import com.github.igorsuhorukov.apache.maven.settings.crypto.SettingsDecrypter;
import com.github.igorsuhorukov.apache.maven.settings.crypto.SettingsDecryptionRequest;
import com.github.igorsuhorukov.apache.maven.settings.crypto.SettingsDecryptionResult;
import com.github.igorsuhorukov.eclipse.aether.DefaultRepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.RepositorySystem;
import com.github.igorsuhorukov.eclipse.aether.RepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.repository.Authentication;
import com.github.igorsuhorukov.eclipse.aether.repository.AuthenticationSelector;
import com.github.igorsuhorukov.eclipse.aether.repository.LocalRepository;
import com.github.igorsuhorukov.eclipse.aether.repository.MirrorSelector;
import com.github.igorsuhorukov.eclipse.aether.repository.Proxy;
import com.github.igorsuhorukov.eclipse.aether.repository.ProxySelector;
import com.github.igorsuhorukov.eclipse.aether.util.repository.AuthenticationBuilder;
import com.github.igorsuhorukov.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import com.github.igorsuhorukov.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import com.github.igorsuhorukov.eclipse.aether.util.repository.DefaultMirrorSelector;
import com.github.igorsuhorukov.eclipse.aether.util.repository.DefaultProxySelector;
import com.github.igorsuhorukov.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import com.github.igorsuhorukov.sonatype.plexus.components.cipher.PlexusCipherException;
import com.github.igorsuhorukov.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.grape.RepositorySystemSessionAutoConfiguration;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;

public class SettingsXmlRepositorySystemSessionAutoConfiguration
implements RepositorySystemSessionAutoConfiguration {
    private final String homeDir;

    public SettingsXmlRepositorySystemSessionAutoConfiguration() {
        this(System.getProperty("user.home"));
    }

    /*
     * WARNING - void declaration
     */
    SettingsXmlRepositorySystemSessionAutoConfiguration(String homeDir) {
        void var1_1;
        this.homeDir = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(DefaultRepositorySystemSession session, RepositorySystem repositorySystem) {
        Settings settings = this.loadSettings();
        SettingsDecryptionResult decryptionResult = this.decryptSettings(settings);
        if (!decryptionResult.getProblems().isEmpty()) {
            String string = "Maven settings decryption failed. Some Maven repositories may be inaccessible";
            System.err.println(string);
        }
        session.setOffline(settings.isOffline());
        session.setMirrorSelector(this.createMirrorSelector(settings));
        session.setAuthenticationSelector(this.createAuthenticationSelector(decryptionResult.getServers()));
        session.setProxySelector(this.createProxySelector(decryptionResult.getProxies()));
        String localRepository = settings.getLocalRepository();
        if (localRepository != null) {
            void var3_3;
            void var1_1;
            void var2_2;
            session.setLocalRepositoryManager(var2_2.newLocalRepositoryManager((RepositorySystemSession)var1_1, new LocalRepository((String)var3_3)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Settings loadSettings() {
        File settingsFile = new File(this.homeDir, ".m2/settings.xml");
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(settingsFile);
        request.setSystemProperties(System.getProperties());
        try {
            return new DefaultSettingsBuilderFactory().newInstance().build(request).getEffectiveSettings();
        }
        catch (SettingsBuildingException ex) {
            void var2_3;
            void var1_1;
            throw new IllegalStateException("Failed to build settings from " + var1_1, (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SettingsDecryptionResult decryptSettings(Settings settings) {
        void var1_1;
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(settings);
        return this.createSettingsDecrypter().decrypt((SettingsDecryptionRequest)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private SettingsDecrypter createSettingsDecrypter() {
        void var1_1;
        DefaultSettingsDecrypter settingsDecrypter = new DefaultSettingsDecrypter();
        this.setField(DefaultSettingsDecrypter.class, "securityDispatcher", settingsDecrypter, new SpringBootSecDispatcher(this));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void setField(Class<?> clazz, String fieldName, Object target, Object value) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
            return;
        }
        catch (Exception e) {
            void var1_2;
            void var3_4;
            void var2_3;
            throw new IllegalStateException("Failed to set field '" + (String)var2_3 + "' on '" + var3_4 + "'", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private MirrorSelector createMirrorSelector(Settings settings) {
        void var2_2;
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : settings.getMirrors()) {
            void var3_3;
            selector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), var3_3.getMirrorOfLayouts());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private AuthenticationSelector createAuthenticationSelector(List<Server> servers) {
        void var2_2;
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        for (Server server : servers) {
            void var3_3;
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername()).addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(var3_3.getId(), auth.build());
        }
        return new ConservativeAuthenticationSelector((AuthenticationSelector)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ProxySelector createProxySelector(List<com.github.igorsuhorukov.apache.maven.settings.Proxy> proxies) {
        void var2_2;
        DefaultProxySelector selector = new DefaultProxySelector();
        for (com.github.igorsuhorukov.apache.maven.settings.Proxy proxy : proxies) {
            void var3_3;
            Authentication authentication = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            selector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), authentication), var3_3.getNonProxyHosts());
        }
        return var2_2;
    }

    private final class SpringBootSecDispatcher
    extends DefaultSecDispatcher {
        /*
         * WARNING - void declaration
         */
        public SpringBootSecDispatcher(SettingsXmlRepositorySystemSessionAutoConfiguration settingsXmlRepositorySystemSessionAutoConfiguration) {
            this._configurationFile = new File(settingsXmlRepositorySystemSessionAutoConfiguration.homeDir, ".m2/settings-security.xml").getAbsolutePath();
            try {
                this._cipher = new DefaultPlexusCipher();
                return;
            }
            catch (PlexusCipherException e) {
                void var1_2;
                throw new IllegalStateException((Throwable)var1_2);
            }
        }
    }
}

