/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.springframework.boot.dependency.tools;

import com.github.igorsuhorukov.springframework.boot.dependency.tools.Assert;
import com.github.igorsuhorukov.springframework.boot.dependency.tools.Dependencies;
import com.github.igorsuhorukov.springframework.boot.dependency.tools.Dependency;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

abstract class AbstractDependencies
implements Dependencies {
    private final Map<ArtifactAndGroupId, Dependency> byArtifactAndGroupId = new LinkedHashMap<ArtifactAndGroupId, Dependency>();
    private final Map<String, Dependency> byArtifactId = new LinkedHashMap<String, Dependency>();

    /*
     * WARNING - void declaration
     */
    @Override
    public Dependency find(String groupId, String artifactId) {
        void var2_2;
        void var1_1;
        return this.byArtifactAndGroupId.get(new ArtifactAndGroupId((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Dependency find(String artifactId) {
        void var1_1;
        return this.byArtifactId.get(var1_1);
    }

    @Override
    public Iterator<Dependency> iterator() {
        return this.byArtifactAndGroupId.values().iterator();
    }

    /*
     * WARNING - void declaration
     */
    protected final void add(ArtifactAndGroupId artifactAndGroupId, Dependency dependency) {
        void var2_2;
        void var1_1;
        Dependency existing = this.byArtifactAndGroupId.get(artifactAndGroupId);
        if (existing != null) {
            Dependency dependency2;
            void v0 = dependency2;
            dependency2 = dependency;
            dependency = v0;
            LinkedHashSet<Dependency.Exclusion> linkedHashSet = new LinkedHashSet<Dependency.Exclusion>();
            linkedHashSet.addAll(dependency.getExclusions());
            linkedHashSet.addAll(dependency2.getExclusions());
            dependency = new Dependency(dependency2.getGroupId(), dependency2.getArtifactId(), dependency2.getVersion(), new ArrayList<Dependency.Exclusion>(linkedHashSet));
        }
        this.byArtifactAndGroupId.put((ArtifactAndGroupId)var1_1, dependency);
        this.byArtifactId.put(dependency.getArtifactId(), (Dependency)var2_2);
    }

    protected static final class ArtifactAndGroupId {
        private final String groupId;
        private final String artifactId;

        /*
         * WARNING - void declaration
         */
        public ArtifactAndGroupId(Dependency dependency) {
            this(dependency.getGroupId(), var1_1.getArtifactId());
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ArtifactAndGroupId(String groupId, String artifactId) {
            void var2_2;
            void var1_1;
            Assert.notNull(groupId, "GroupId must not be null");
            Assert.notNull(artifactId, "ArtifactId must not be null");
            this.groupId = var1_1;
            this.artifactId = var2_2;
        }

        public final int hashCode() {
            return this.groupId.hashCode() * 31 + this.artifactId.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                void var1_1;
                ArtifactAndGroupId other = (ArtifactAndGroupId)obj;
                boolean bl = true & this.groupId.equals(other.groupId);
                return bl &= this.artifactId.equals(var1_1.artifactId);
            }
            return false;
        }
    }
}

