/*
 * Decompiled with CFR 0.152.
 */
package com.github.javiersantos.licensing;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.vending.licensing.ILicenseResultListener;
import com.android.vending.licensing.ILicensingService;
import com.github.javiersantos.licensing.LibraryCheckerCallback;
import com.github.javiersantos.licensing.LibraryValidator;
import com.github.javiersantos.licensing.NullDeviceLimiter;
import com.github.javiersantos.licensing.Policy;
import com.github.javiersantos.licensing.util.Base64;
import com.github.javiersantos.licensing.util.Base64DecoderException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

@SuppressLint(value={"SimpleDateFormat", "HardwareIds"})
public class LibraryChecker
implements ServiceConnection {
    private static final String TAG = "LibraryChecker";
    private static final String KEY_FACTORY_ALGORITHM = "RSA";
    private static final int TIMEOUT_MS = 10000;
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final boolean DEBUG_LICENSE_ERROR = false;
    private final Context mContext;
    private final Policy mPolicy;
    private final String mPackageName;
    private final String mVersionCode;
    private final Set<LibraryValidator> mChecksInProgress = new HashSet<LibraryValidator>();
    private final Queue<LibraryValidator> mPendingChecks = new LinkedList<LibraryValidator>();
    private ILicensingService mService;
    private PublicKey mPublicKey;
    private Handler mHandler;

    public LibraryChecker(Context context, Policy policy, String encodedPublicKey) {
        this.mContext = context;
        this.mPolicy = policy;
        this.mPublicKey = LibraryChecker.generatePublicKey(encodedPublicKey);
        this.mPackageName = this.mContext.getPackageName();
        this.mVersionCode = LibraryChecker.getVersionCode(context, this.mPackageName);
        HandlerThread handlerThread = new HandlerThread("background thread");
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
    }

    private static PublicKey generatePublicKey(String encodedPublicKey) {
        try {
            byte[] decodedKey = Base64.decode(encodedPublicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_FACTORY_ALGORITHM);
            return keyFactory.generatePublic(new X509EncodedKeySpec(decodedKey));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (Base64DecoderException e) {
            Log.e((String)TAG, (String)"Could not decode from Base64.");
            throw new IllegalArgumentException(e);
        }
        catch (InvalidKeySpecException e) {
            Log.e((String)TAG, (String)"Invalid key specification.");
            throw new IllegalArgumentException(e);
        }
    }

    private static String getVersionCode(Context context, String packageName) {
        try {
            return String.valueOf(context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Package not found. could not get version code.");
            return "";
        }
    }

    public synchronized void checkAccess(LibraryCheckerCallback callback2) {
        block8: {
            if (this.mPolicy.allowAccess()) {
                Log.i((String)TAG, (String)"Using cached license response");
                callback2.allow(2954);
            } else {
                LibraryValidator validator = new LibraryValidator(this.mPolicy, new NullDeviceLimiter(), callback2, this.generateNonce(), this.mPackageName, this.mVersionCode);
                if (this.mService == null) {
                    Log.i((String)TAG, (String)"Binding to licensing service.");
                    try {
                        boolean bindResult = this.mContext.bindService(new Intent(new String(Base64.decode("Y29tLmFuZHJvaWQudmVuZGluZy5saWNlbnNpbmcuSUxpY2Vuc2luZ1NlcnZpY2U="))).setPackage(new String(Base64.decode("Y29tLmFuZHJvaWQudmVuZGluZw=="))), (ServiceConnection)this, 1);
                        if (bindResult) {
                            this.mPendingChecks.offer(validator);
                            break block8;
                        }
                        Log.e((String)TAG, (String)"Could not bind to service.");
                        this.handleServiceConnectionError(validator);
                    }
                    catch (SecurityException e) {
                        callback2.applicationError(6);
                    }
                    catch (Base64DecoderException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.mPendingChecks.offer(validator);
                    this.runChecks();
                }
            }
        }
    }

    private void runChecks() {
        LibraryValidator validator;
        while ((validator = this.mPendingChecks.poll()) != null) {
            try {
                Log.i((String)TAG, (String)("Calling checkLicense on service for " + validator.getPackageName()));
                this.mService.checkLicense(validator.getNonce(), validator.getPackageName(), new ResultListener(validator));
                this.mChecksInProgress.add(validator);
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"RemoteException in checkLicense call.", (Throwable)e);
                this.handleServiceConnectionError(validator);
            }
        }
    }

    public synchronized void finishAllChecks() {
        for (LibraryValidator validator : this.mChecksInProgress) {
            try {
                this.finishCheck(validator);
            }
            catch (Exception exception) {}
        }
        for (LibraryValidator validator : this.mPendingChecks) {
            try {
                this.mPendingChecks.remove(validator);
            }
            catch (Exception exception) {}
        }
    }

    private synchronized void finishCheck(LibraryValidator validator) {
        this.mChecksInProgress.remove(validator);
        if (this.mChecksInProgress.isEmpty()) {
            this.cleanupService();
        }
    }

    public synchronized void onServiceConnected(ComponentName name, IBinder service) {
        this.mService = ILicensingService.Stub.asInterface(service);
        this.runChecks();
    }

    public synchronized void onServiceDisconnected(ComponentName name) {
        Log.w((String)TAG, (String)"Service unexpectedly disconnected.");
        this.mService = null;
    }

    private synchronized void handleServiceConnectionError(LibraryValidator validator) {
        this.mPolicy.processServerResponse(3144, null);
        if (this.mPolicy.allowAccess()) {
            validator.getCallback().allow(3144);
        } else {
            validator.getCallback().dontAllow(3144);
        }
    }

    private void cleanupService() {
        if (this.mService != null) {
            try {
                this.mContext.unbindService((ServiceConnection)this);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)"Unable to unbind from licensing service (already unbound)");
            }
            this.mService = null;
        }
    }

    public synchronized void onDestroy() {
        this.cleanupService();
        this.mHandler.getLooper().quit();
    }

    private int generateNonce() {
        return RANDOM.nextInt();
    }

    public class ResultListener
    extends ILicenseResultListener.Stub {
        private static final int ERROR_CONTACTING_SERVER = 257;
        private static final int ERROR_INVALID_PACKAGE_NAME = 258;
        private static final int ERROR_NON_MATCHING_UID = 259;
        private final LibraryValidator mValidator;
        private Runnable mOnTimeout;

        public ResultListener(LibraryValidator validator) {
            this.mValidator = validator;
            this.mOnTimeout = new Runnable(){

                @Override
                public void run() {
                    Log.i((String)LibraryChecker.TAG, (String)"Check timed out.");
                    LibraryChecker.this.handleServiceConnectionError(ResultListener.this.mValidator);
                    LibraryChecker.this.finishCheck(ResultListener.this.mValidator);
                }
            };
            this.startTimeout();
        }

        @Override
        public void verifyLicense(final int responseCode, final String signedData, final String signature) {
            LibraryChecker.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Log.i((String)LibraryChecker.TAG, (String)"Received response.");
                    if (LibraryChecker.this.mChecksInProgress.contains(ResultListener.this.mValidator)) {
                        ResultListener.this.clearTimeout();
                        ResultListener.this.mValidator.check(LibraryChecker.this.mPublicKey, responseCode, signedData, Calendar.getInstance(), signature);
                        LibraryChecker.this.finishCheck(ResultListener.this.mValidator);
                    }
                }
            });
        }

        private void startTimeout() {
            Log.i((String)LibraryChecker.TAG, (String)"Start monitoring timeout.");
            LibraryChecker.this.mHandler.postDelayed(this.mOnTimeout, 10000L);
        }

        private void clearTimeout() {
            Log.i((String)LibraryChecker.TAG, (String)"Clearing timeout.");
            LibraryChecker.this.mHandler.removeCallbacks(this.mOnTimeout);
        }
    }
}

