/*
 * Decompiled with CFR 0.152.
 */
package com.github.javiersantos.licensing;

import android.text.TextUtils;
import android.util.Log;
import com.github.javiersantos.licensing.DeviceLimiter;
import com.github.javiersantos.licensing.LibraryCheckerCallback;
import com.github.javiersantos.licensing.Policy;
import com.github.javiersantos.licensing.ResponseData;
import com.github.javiersantos.licensing.util.Base64;
import com.github.javiersantos.licensing.util.Base64DecoderException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Calendar;

class LibraryValidator {
    private static final String TAG = "LibraryValidator";
    private static final int LICENSED = 0;
    private static final int NOT_LICENSED = 1;
    private static final int LICENSED_OLD_KEY = 2;
    private static final int ERROR_NOT_MARKET_MANAGED = 3;
    private static final int ERROR_SERVER_FAILURE = 4;
    private static final int ERROR_OVER_QUOTA = 5;
    private static final int ERROR_CONTACTING_SERVER = 257;
    private static final int ERROR_INVALID_PACKAGE_NAME = 258;
    private static final int ERROR_NON_MATCHING_UID = 259;
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private final Policy mPolicy;
    private final LibraryCheckerCallback mCallback;
    private final int mNonce;
    private final String mPackageName;
    private final String mVersionCode;
    private final DeviceLimiter mDeviceLimiter;

    LibraryValidator(Policy policy, DeviceLimiter deviceLimiter, LibraryCheckerCallback callback2, int nonce, String packageName, String versionCode) {
        this.mPolicy = policy;
        this.mDeviceLimiter = deviceLimiter;
        this.mCallback = callback2;
        this.mNonce = nonce;
        this.mPackageName = packageName;
        this.mVersionCode = versionCode;
    }

    public LibraryCheckerCallback getCallback() {
        return this.mCallback;
    }

    public int getNonce() {
        return this.mNonce;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public void check(PublicKey publicKey, int responseCode, String signedData, Calendar calendar, String signature) {
        String userId = null;
        ResponseData data = null;
        if (calendar == null) {
            this.handleInvalidResponse();
        } else if (responseCode == 0 || responseCode == 1 || responseCode == 2) {
            try {
                if (TextUtils.isEmpty((CharSequence)signedData)) {
                    Log.e((String)TAG, (String)"Signature verification failed: signedData is empty. (Device not signed-in to any Google accounts?)");
                    this.handleInvalidResponse();
                    return;
                }
                Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
                sig.initVerify(publicKey);
                sig.update(signedData.getBytes());
                if (!sig.verify(Base64.decode(signature))) {
                    Log.e((String)TAG, (String)"Signature verification failed.");
                    this.handleInvalidResponse();
                    return;
                }
            }
            catch (NoSuchAlgorithmException | SignatureException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                this.handleApplicationError(5);
                return;
            }
            catch (Base64DecoderException e) {
                Log.e((String)TAG, (String)"Could not Base64-decode signature.");
                this.handleInvalidResponse();
                return;
            }
            try {
                data = ResponseData.parse(signedData);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)"Could not parse response.");
                this.handleInvalidResponse();
                return;
            }
            if (data.responseCode != responseCode) {
                Log.e((String)TAG, (String)"Response codes don't match.");
                this.handleInvalidResponse();
                return;
            }
            if (data.nonce != this.mNonce) {
                Log.e((String)TAG, (String)"Nonce doesn't match.");
                this.handleInvalidResponse();
                return;
            }
            if (!data.packageName.equals(this.mPackageName)) {
                Log.e((String)TAG, (String)"Package name doesn't match.");
                this.handleInvalidResponse();
                return;
            }
            if (!data.versionCode.equals(this.mVersionCode)) {
                Log.e((String)TAG, (String)"Version codes don't match.");
                this.handleInvalidResponse();
                return;
            }
            userId = data.userId;
            if (TextUtils.isEmpty((CharSequence)userId)) {
                Log.e((String)TAG, (String)"User identifier is empty.");
                this.handleInvalidResponse();
                return;
            }
        }
        switch (responseCode) {
            case 0: 
            case 2: {
                int limiterResponse = this.mDeviceLimiter.isDeviceAllowed(userId);
                this.handleResponse(limiterResponse, data);
                break;
            }
            case 1: {
                this.handleResponse(435, data);
                break;
            }
            case 257: {
                Log.w((String)TAG, (String)"Error contacting licensing server.");
                this.handleResponse(3144, data);
                break;
            }
            case 4: {
                Log.w((String)TAG, (String)"An error has occurred on the licensing server.");
                this.handleResponse(3144, data);
                break;
            }
            case 5: {
                Log.w((String)TAG, (String)"Licensing server is refusing to talk to this device, over quota.");
                this.handleResponse(3144, data);
                break;
            }
            case 258: {
                this.handleApplicationError(1);
                break;
            }
            case 259: {
                this.handleApplicationError(2);
                break;
            }
            case 3: {
                this.handleApplicationError(3);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Unknown response code for license check.");
                this.handleInvalidResponse();
            }
        }
    }

    private void handleResponse(int response, ResponseData rawData) {
        this.mPolicy.processServerResponse(response, rawData);
        if (this.mPolicy.allowAccess()) {
            this.mCallback.allow(response);
        } else {
            this.mCallback.dontAllow(response);
        }
    }

    private void handleApplicationError(int code) {
        this.mCallback.applicationError(code);
    }

    private void handleInvalidResponse() {
        this.mCallback.dontAllow(435);
    }
}

