/*
 * Decompiled with CFR 0.152.
 */
package com.github.javiersantos.licensing;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.github.javiersantos.licensing.Obfuscator;
import com.github.javiersantos.licensing.Policy;
import com.github.javiersantos.licensing.PreferenceObfuscator;
import com.github.javiersantos.licensing.ResponseData;
import com.github.javiersantos.licensing.util.URIQueryDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class ServerManagedPolicy
implements Policy {
    private static final String TAG = "ServerManagedPolicy";
    private static final String PREFS_FILE = "com.github.javiersantos.licensing.ServerManagedPolicy";
    private static final String PREF_LAST_RESPONSE = "lastResponse";
    private static final String PREF_VALIDITY_TIMESTAMP = "validityTimestamp";
    private static final String PREF_RETRY_UNTIL = "retryUntil";
    private static final String PREF_MAX_RETRIES = "maxRetries";
    private static final String PREF_RETRY_COUNT = "retryCount";
    private static final String DEFAULT_VALIDITY_TIMESTAMP = "0";
    private static final String DEFAULT_RETRY_UNTIL = "0";
    private static final String DEFAULT_MAX_RETRIES = "0";
    private static final String DEFAULT_RETRY_COUNT = "0";
    private static final long MILLIS_PER_MINUTE = 60000L;
    private long mValidityTimestamp;
    private long mRetryUntil;
    private long mMaxRetries;
    private long mRetryCount;
    private long mLastResponseTime = 0L;
    private int mLastResponse;
    private PreferenceObfuscator mPreferences;

    public ServerManagedPolicy(Context context, Obfuscator obfuscator) {
        SharedPreferences sp = context.getSharedPreferences(PREFS_FILE, 0);
        this.mPreferences = new PreferenceObfuscator(sp, obfuscator);
        this.mLastResponse = Integer.parseInt(this.mPreferences.getString(PREF_LAST_RESPONSE, Integer.toString(3144)));
        this.mValidityTimestamp = Long.parseLong(this.mPreferences.getString(PREF_VALIDITY_TIMESTAMP, "0"));
        this.mRetryUntil = Long.parseLong(this.mPreferences.getString(PREF_RETRY_UNTIL, "0"));
        this.mMaxRetries = Long.parseLong(this.mPreferences.getString(PREF_MAX_RETRIES, "0"));
        this.mRetryCount = Long.parseLong(this.mPreferences.getString(PREF_RETRY_COUNT, "0"));
    }

    @Override
    public void processServerResponse(int response, ResponseData rawData) {
        if (response != 3144) {
            this.setRetryCount(0L);
        } else {
            this.setRetryCount(this.mRetryCount + 1L);
        }
        if (response == 2954) {
            Map<String, String> extras = this.decodeExtras(rawData.extra);
            this.mLastResponse = response;
            this.setValidityTimestamp(extras.get("VT"));
            this.setRetryUntil(extras.get("GT"));
            this.setMaxRetries(extras.get("GR"));
        } else if (response == 435) {
            this.setValidityTimestamp("0");
            this.setRetryUntil("0");
            this.setMaxRetries("0");
        }
        this.setLastResponse(response);
        this.mPreferences.commit();
    }

    private void setLastResponse(int l) {
        this.mLastResponseTime = System.currentTimeMillis();
        this.mLastResponse = l;
        this.mPreferences.putString(PREF_LAST_RESPONSE, Integer.toString(l));
    }

    public long getRetryCount() {
        return this.mRetryCount;
    }

    private void setRetryCount(long c) {
        this.mRetryCount = c;
        this.mPreferences.putString(PREF_RETRY_COUNT, Long.toString(c));
    }

    public long getValidityTimestamp() {
        return this.mValidityTimestamp;
    }

    private void setValidityTimestamp(String validityTimestamp) {
        Long lValidityTimestamp;
        try {
            lValidityTimestamp = Long.parseLong(validityTimestamp);
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)"License validity timestamp (VT) missing, caching for a minute");
            lValidityTimestamp = System.currentTimeMillis() + 60000L;
            validityTimestamp = Long.toString(lValidityTimestamp);
        }
        this.mValidityTimestamp = lValidityTimestamp;
        this.mPreferences.putString(PREF_VALIDITY_TIMESTAMP, validityTimestamp);
    }

    public long getRetryUntil() {
        return this.mRetryUntil;
    }

    private void setRetryUntil(String retryUntil) {
        Long lRetryUntil;
        try {
            lRetryUntil = Long.parseLong(retryUntil);
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)"License retry timestamp (GT) missing, grace period disabled");
            retryUntil = "0";
            lRetryUntil = 0L;
        }
        this.mRetryUntil = lRetryUntil;
        this.mPreferences.putString(PREF_RETRY_UNTIL, retryUntil);
    }

    public long getMaxRetries() {
        return this.mMaxRetries;
    }

    private void setMaxRetries(String maxRetries) {
        Long lMaxRetries;
        try {
            lMaxRetries = Long.parseLong(maxRetries);
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)"Licence retry count (GR) missing, grace period disabled");
            maxRetries = "0";
            lMaxRetries = 0L;
        }
        this.mMaxRetries = lMaxRetries;
        this.mPreferences.putString(PREF_MAX_RETRIES, maxRetries);
    }

    @Override
    public boolean allowAccess() {
        long ts = System.currentTimeMillis();
        if (this.mLastResponse == 2954) {
            if (ts <= this.mValidityTimestamp) {
                return true;
            }
        } else if (this.mLastResponse == 3144 && ts < this.mLastResponseTime + 60000L) {
            return ts <= this.mRetryUntil || this.mRetryCount <= this.mMaxRetries;
        }
        return false;
    }

    private Map<String, String> decodeExtras(String extras) {
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            URI rawExtras = new URI("?" + extras);
            URIQueryDecoder.DecodeQuery(rawExtras, results);
        }
        catch (URISyntaxException e) {
            Log.w((String)TAG, (String)"Invalid syntax error while decoding extras data from server.");
        }
        return results;
    }
}

