/*
 * Decompiled with CFR 0.152.
 */
package com.github.javiersantos.licensing.util;

import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Scanner;

public class URIQueryDecoder {
    private static final String TAG = "URIQueryDecoder";

    public static void DecodeQuery(URI encodedURI, Map<String, String> results) {
        Scanner scanner = new Scanner(encodedURI.getRawQuery());
        scanner.useDelimiter("&");
        try {
            while (scanner.hasNext()) {
                String value;
                String param = scanner.next();
                String[] valuePair = param.split("=");
                if (valuePair.length == 1) {
                    value = null;
                } else if (valuePair.length == 2) {
                    value = URLDecoder.decode(valuePair[1], "UTF-8");
                } else {
                    throw new IllegalArgumentException("query parameter invalid");
                }
                String name = URLDecoder.decode(valuePair[0], "UTF-8");
                results.put(name, value);
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"UTF-8 Not Recognized as a charset.  Device configuration Error.");
        }
    }
}

