/*
 * Decompiled with CFR 0.152.
 */
package com.github.javiersantos.piracychecker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.provider.Settings;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import com.github.javiersantos.licensing.AESObfuscator;
import com.github.javiersantos.licensing.LibraryChecker;
import com.github.javiersantos.licensing.LibraryCheckerCallback;
import com.github.javiersantos.licensing.ServerManagedPolicy;
import com.github.javiersantos.piracychecker.PiracyChecker;
import com.github.javiersantos.piracychecker.PiracyCheckerDialog;
import com.github.javiersantos.piracychecker.R;
import com.github.javiersantos.piracychecker.activities.LicenseActivity;
import com.github.javiersantos.piracychecker.callbacks.AllowCallback;
import com.github.javiersantos.piracychecker.callbacks.DoNotAllowCallback;
import com.github.javiersantos.piracychecker.callbacks.OnErrorCallback;
import com.github.javiersantos.piracychecker.callbacks.PiracyCheckerCallback;
import com.github.javiersantos.piracychecker.enums.AppType;
import com.github.javiersantos.piracychecker.enums.Display;
import com.github.javiersantos.piracychecker.enums.InstallerID;
import com.github.javiersantos.piracychecker.enums.PiracyCheckerError;
import com.github.javiersantos.piracychecker.enums.PirateApp;
import com.github.javiersantos.piracychecker.utils.LibraryUtilsKt;
import com.github.javiersantos.piracychecker.utils.SaltUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\f\b\u0007\u0018\u0000 b2\u00020\u0001:\u0001bB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\b\u0012\b\b\u0001\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020&J\u001f\u0010?\u001a\u00020\u00002\u0012\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020&06\"\u00020&\u00a2\u0006\u0002\u0010BJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010C\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u0010D\u001a\u00020\u0006J\u0016\u0010C\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010F\u001a\u00020GJ\u0006\u0010H\u001a\u00020IJ\b\u0010J\u001a\u00020IH\u0002J\b\u0010K\u001a\u00020IH\u0002J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010L\u001a\u00020I2\u0006\u0010M\u001a\u00020\u0012H\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010N\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0000J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0006J\u001f\u0010Q\u001a\u00020\u00002\u0012\u0010R\u001a\n\u0012\u0006\b\u0001\u0012\u00020)06\"\u00020)\u00a2\u0006\u0002\u0010SJ\u0010\u0010!\u001a\u00020\u00002\u0006\u0010T\u001a\u00020\u0006H\u0007J\u001f\u0010U\u001a\u00020\u00002\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000606\"\u00020\u0006\u00a2\u0006\u0002\u0010VJ\u0014\u0010U\u001a\u00020\u00002\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00060WJ\u0006\u0010\"\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010X\u001a\u00020/J\u0016\u0010Y\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u0010D\u001a\u00020\u0006J\u0016\u0010Y\u001a\u00020\u00002\u0006\u0010E\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u0006J\u0012\u00104\u001a\u00020I2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u0012\u00104\u001a\u00020I2\b\u0010E\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010Z\u001a\u00020IJ\b\u0010[\u001a\u00020IH\u0002J\b\u0010\\\u001a\u00020\u0012H\u0002J\b\u0010]\u001a\u00020\u0012H\u0002J\b\u0010^\u001a\u00020\u0012H\u0002J\"\u0010_\u001a\u00020\u00002\b\b\u0001\u0010\u0013\u001a\u00020\b2\b\b\u0001\u0010\u0014\u001a\u00020\b2\u0006\u0010>\u001a\u00020\u0012J\u0010\u0010`\u001a\u00020\u00002\b\b\u0001\u0010a\u001a\u00020\bR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u000606X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00107R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00109\"\u0004\b=\u0010;R\u000e\u0010>\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/github/javiersantos/piracychecker/PiracyChecker;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "title", "", "(Landroid/content/Context;Ljava/lang/String;)V", "", "(Landroid/content/Context;I)V", "description", "(Landroid/content/Context;II)V", "unlicensedDialogTitle", "unlicensedDialogDescription", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "allowCallback", "Lcom/github/javiersantos/piracychecker/callbacks/AllowCallback;", "blockUnauthorized", "", "colorPrimary", "colorPrimaryDark", "dialog", "Lcom/github/javiersantos/piracychecker/PiracyCheckerDialog;", "display", "Lcom/github/javiersantos/piracychecker/enums/Display;", "doNotAllowCallback", "Lcom/github/javiersantos/piracychecker/callbacks/DoNotAllowCallback;", "enableAPKCheck", "enableDebugCheck", "enableDeepEmulatorCheck", "enableEmulatorCheck", "enableFoldersCheck", "enableLVL", "enableSigningCertificate", "enableStoresCheck", "enableUnauthorizedAppsCheck", "extraApps", "Ljava/util/ArrayList;", "Lcom/github/javiersantos/piracychecker/enums/PirateApp;", "installerIDs", "", "Lcom/github/javiersantos/piracychecker/enums/InstallerID;", "layoutXML", "libraryLVLChecker", "Lcom/github/javiersantos/licensing/LibraryChecker;", "licenseBase64", "onErrorCallback", "Lcom/github/javiersantos/piracychecker/callbacks/OnErrorCallback;", "preferenceBlockUnauthorized", "preferenceSaveResult", "preferences", "Landroid/content/SharedPreferences;", "saveToSharedPreferences", "signatures", "", "[Ljava/lang/String;", "getUnlicensedDialogDescription", "()Ljava/lang/String;", "setUnlicensedDialogDescription", "(Ljava/lang/String;)V", "getUnlicensedDialogTitle", "setUnlicensedDialogTitle", "withLightStatusBar", "addAppToCheck", "app", "apps", "([Lcom/github/javiersantos/piracychecker/enums/PirateApp;)Lcom/github/javiersantos/piracychecker/PiracyChecker;", "blockIfUnauthorizedAppUninstalled", "preferenceName", "preferencesName", "callback", "Lcom/github/javiersantos/piracychecker/callbacks/PiracyCheckerCallback;", "destroy", "", "destroyLVLChecker", "dismissDialog", "doExtraVerification", "possibleSuccess", "deepCheck", "enableGooglePlayLicensing", "licenseKeyBase64", "enableInstallerId", "installerID", "([Lcom/github/javiersantos/piracychecker/enums/InstallerID;)Lcom/github/javiersantos/piracychecker/PiracyChecker;", "signature", "enableSigningCertificates", "([Ljava/lang/String;)Lcom/github/javiersantos/piracychecker/PiracyChecker;", "", "errorCallback", "saveResultToSharedPreferences", "start", "verify", "verifyInstallerId", "verifySigningCertificate", "verifyUnauthorizedApp", "withActivityColors", "withActivityLayout", "layout", "Companion", "library_release"})
@SuppressLint(value={"HardwareIds"})
public final class PiracyChecker {
    private Display display;
    @ColorRes
    private int colorPrimary;
    @ColorRes
    private int colorPrimaryDark;
    private boolean withLightStatusBar;
    @LayoutRes
    private int layoutXML;
    private boolean enableLVL;
    private boolean enableSigningCertificate;
    private boolean enableUnauthorizedAppsCheck;
    private boolean enableStoresCheck;
    private boolean enableEmulatorCheck;
    private boolean enableDeepEmulatorCheck;
    private boolean enableDebugCheck;
    private boolean enableFoldersCheck;
    private boolean enableAPKCheck;
    private boolean saveToSharedPreferences;
    private boolean blockUnauthorized;
    private SharedPreferences preferences;
    private String preferenceSaveResult;
    private String preferenceBlockUnauthorized;
    private String licenseBase64;
    private String[] signatures;
    private final List<InstallerID> installerIDs;
    private final ArrayList<PirateApp> extraApps;
    private AllowCallback allowCallback;
    private DoNotAllowCallback doNotAllowCallback;
    private OnErrorCallback onErrorCallback;
    private LibraryChecker libraryLVLChecker;
    private PiracyCheckerDialog dialog;
    private Context context;
    @Nullable
    private String unlicensedDialogTitle;
    @Nullable
    private String unlicensedDialogDescription;
    private static final String LIBRARY_PREFERENCES_NAME = "license_check";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final PiracyChecker enableGooglePlayLicensing(@NotNull String licenseKeyBase64) {
        Intrinsics.checkNotNullParameter((Object)licenseKeyBase64, (String)"licenseKeyBase64");
        this.enableLVL = true;
        this.licenseBase64 = licenseKeyBase64;
        return this;
    }

    @Deprecated(message="Deprecated in favor of enableSigningCertificates so you can check for multiple signatures", replaceWith=@ReplaceWith(imports={}, expression="enableSigningCertificates(signature)"))
    @NotNull
    public final PiracyChecker enableSigningCertificate(@NotNull String signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.enableSigningCertificate = true;
        this.signatures = new String[]{signature};
        return this;
    }

    @NotNull
    public final PiracyChecker enableSigningCertificates(String ... signatures) {
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        this.enableSigningCertificate = true;
        this.signatures = Arrays.copyOf(signatures, signatures.length);
        return this;
    }

    @NotNull
    public final PiracyChecker enableSigningCertificates(@NotNull List<String> signatures) {
        Intrinsics.checkNotNullParameter(signatures, (String)"signatures");
        this.enableSigningCertificate = true;
        Collection $this$toTypedArray$iv = signatures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this.signatures = stringArray;
        return this;
    }

    @NotNull
    public final PiracyChecker enableInstallerId(InstallerID ... installerID) {
        Intrinsics.checkNotNullParameter((Object)installerID, (String)"installerID");
        this.installerIDs.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(installerID, installerID.length)));
        return this;
    }

    @NotNull
    public final PiracyChecker enableUnauthorizedAppsCheck() {
        this.enableUnauthorizedAppsCheck = true;
        return this;
    }

    @NotNull
    public final PiracyChecker blockIfUnauthorizedAppUninstalled(@NotNull SharedPreferences preferences, @NotNull String preferenceName) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)preferenceName, (String)"preferenceName");
        this.blockUnauthorized = true;
        this.preferenceBlockUnauthorized = preferenceName;
        this.saveToSharedPreferences(preferences);
        return this;
    }

    @NotNull
    public final PiracyChecker blockIfUnauthorizedAppUninstalled(@NotNull String preferencesName, @NotNull String preferenceName) {
        Intrinsics.checkNotNullParameter((Object)preferencesName, (String)"preferencesName");
        Intrinsics.checkNotNullParameter((Object)preferenceName, (String)"preferenceName");
        this.blockUnauthorized = true;
        this.preferenceBlockUnauthorized = preferenceName;
        this.saveToSharedPreferences(preferencesName);
        return this;
    }

    @NotNull
    public final PiracyChecker enableStoresCheck() {
        this.enableStoresCheck = true;
        return this;
    }

    @NotNull
    public final PiracyChecker enableDebugCheck() {
        this.enableDebugCheck = true;
        return this;
    }

    @NotNull
    public final PiracyChecker enableAPKCheck() {
        this.enableAPKCheck = true;
        return this;
    }

    @NotNull
    public final PiracyChecker enableEmulatorCheck(boolean deepCheck) {
        this.enableEmulatorCheck = true;
        this.enableDeepEmulatorCheck = deepCheck;
        return this;
    }

    @NotNull
    public final PiracyChecker enableFoldersCheck() {
        this.enableFoldersCheck = true;
        return this;
    }

    @NotNull
    public final PiracyChecker addAppToCheck(PirateApp ... apps) {
        Intrinsics.checkNotNullParameter((Object)apps, (String)"apps");
        this.extraApps.addAll((Collection<PirateApp>)Arrays.asList(Arrays.copyOf(apps, apps.length)));
        return this;
    }

    @NotNull
    public final PiracyChecker addAppToCheck(@NotNull PirateApp app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        this.extraApps.add(app);
        return this;
    }

    @NotNull
    public final PiracyChecker saveResultToSharedPreferences(@NotNull SharedPreferences preferences, @NotNull String preferenceName) {
        Intrinsics.checkNotNullParameter((Object)preferences, (String)"preferences");
        Intrinsics.checkNotNullParameter((Object)preferenceName, (String)"preferenceName");
        this.saveToSharedPreferences = true;
        this.preferenceSaveResult = preferenceName;
        this.saveToSharedPreferences(preferences);
        return this;
    }

    @NotNull
    public final PiracyChecker saveResultToSharedPreferences(@NotNull String preferencesName, @NotNull String preferenceName) {
        Intrinsics.checkNotNullParameter((Object)preferencesName, (String)"preferencesName");
        Intrinsics.checkNotNullParameter((Object)preferenceName, (String)"preferenceName");
        this.saveToSharedPreferences = true;
        this.preferenceSaveResult = preferenceName;
        this.saveToSharedPreferences(preferencesName);
        return this;
    }

    private final void saveToSharedPreferences(SharedPreferences preferences) {
        if (preferences != null) {
            this.preferences = preferences;
        } else {
            try {
                Context context = this.context;
                if (!(context instanceof Activity)) {
                    context = null;
                }
                Activity activity = (Activity)context;
                this.preferences = activity != null ? activity.getPreferences(0) : null;
            }
            catch (Exception e) {
                Context context = this.context;
                this.preferences = context != null ? context.getSharedPreferences(LIBRARY_PREFERENCES_NAME, 0) : null;
            }
        }
    }

    private final void saveToSharedPreferences(String preferencesName) {
        if (preferencesName != null) {
            Context context = this.context;
            this.preferences = context != null ? context.getSharedPreferences(preferencesName, 0) : null;
        } else {
            try {
                Context context = this.context;
                if (!(context instanceof Activity)) {
                    context = null;
                }
                Activity activity = (Activity)context;
                this.preferences = activity != null ? activity.getPreferences(0) : null;
            }
            catch (Exception e) {
                Context context = this.context;
                this.preferences = context != null ? context.getSharedPreferences(LIBRARY_PREFERENCES_NAME, 0) : null;
            }
        }
    }

    @NotNull
    public final PiracyChecker display(@NotNull Display display) {
        Intrinsics.checkNotNullParameter((Object)((Object)display), (String)"display");
        this.display = display;
        return this;
    }

    @NotNull
    public final PiracyChecker withActivityColors(@ColorRes int colorPrimary, @ColorRes int colorPrimaryDark, boolean withLightStatusBar) {
        this.colorPrimary = colorPrimary;
        this.colorPrimaryDark = colorPrimaryDark;
        this.withLightStatusBar = withLightStatusBar;
        return this;
    }

    @NotNull
    public final PiracyChecker withActivityLayout(@LayoutRes int layout2) {
        this.layoutXML = layout2;
        return this;
    }

    @NotNull
    public final PiracyChecker allowCallback(@NotNull AllowCallback allowCallback) {
        Intrinsics.checkNotNullParameter((Object)allowCallback, (String)"allowCallback");
        this.allowCallback = allowCallback;
        return this;
    }

    @NotNull
    public final PiracyChecker doNotAllowCallback(@NotNull DoNotAllowCallback doNotAllowCallback) {
        Intrinsics.checkNotNullParameter((Object)doNotAllowCallback, (String)"doNotAllowCallback");
        this.doNotAllowCallback = doNotAllowCallback;
        return this;
    }

    @NotNull
    public final PiracyChecker onErrorCallback(@NotNull OnErrorCallback errorCallback) {
        Intrinsics.checkNotNullParameter((Object)errorCallback, (String)"errorCallback");
        this.onErrorCallback = errorCallback;
        return this;
    }

    @NotNull
    public final PiracyChecker callback(@NotNull PiracyCheckerCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        this.allowCallback = new AllowCallback(callback2){
            final /* synthetic */ PiracyCheckerCallback $callback;

            public void allow() {
                this.$callback.allow();
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        };
        this.doNotAllowCallback = new DoNotAllowCallback(callback2){
            final /* synthetic */ PiracyCheckerCallback $callback;

            public void doNotAllow(@NotNull PiracyCheckerError error, @Nullable PirateApp app) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                this.$callback.doNotAllow(error, app);
            }
            {
                this.$callback = $captured_local_variable$0;
            }

            @Deprecated(message="dontAllow has been deprecated in favor of doNotAllow", replaceWith=@ReplaceWith(imports={}, expression="doNotAllow"))
            public void dontAllow(@NotNull PiracyCheckerError error, @Nullable PirateApp app) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                DoNotAllowCallback.DefaultImpls.dontAllow(this, error, app);
            }
        };
        this.onErrorCallback = new OnErrorCallback(callback2){
            final /* synthetic */ PiracyCheckerCallback $callback;

            public void onError(@NotNull PiracyCheckerError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                OnErrorCallback.DefaultImpls.onError(this, error);
                this.$callback.onError(error);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        };
        return this;
    }

    public final void destroy() {
        this.dismissDialog();
        this.destroyLVLChecker();
        this.context = null;
    }

    public final void start() {
        if (this.allowCallback == null && this.doNotAllowCallback == null) {
            this.callback(new PiracyCheckerCallback(this){
                final /* synthetic */ PiracyChecker this$0;

                public void allow() {
                }

                public void doNotAllow(@NotNull PiracyCheckerError error, @Nullable PirateApp app) {
                    String dialogContent;
                    String string2;
                    boolean bl;
                    String string3;
                    Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                    if (PiracyChecker.access$getContext$p(this.this$0) instanceof Activity) {
                        Context context = PiracyChecker.access$getContext$p(this.this$0);
                        if (context == null) {
                            throw new NullPointerException("null cannot be cast to non-null type android.app.Activity");
                        }
                        if (((Activity)context).isFinishing()) {
                            return;
                        }
                    }
                    if (app != null) {
                        Context context = PiracyChecker.access$getContext$p(this.this$0);
                        string3 = context != null ? context.getString(R.string.unauthorized_app_found, new Object[]{app.getName()}) : null;
                        bl = false;
                        string2 = string3;
                        if (string2 == null) {
                            string2 = "";
                        }
                    } else if (error == PiracyCheckerError.BLOCK_PIRATE_APP) {
                        Context context = PiracyChecker.access$getContext$p(this.this$0);
                        string3 = context != null ? context.getString(R.string.unauthorized_app_blocked) : null;
                        bl = false;
                        string2 = string3;
                        if (string2 == null) {
                            string2 = "";
                        }
                    } else {
                        string2 = dialogContent = this.this$0.getUnlicensedDialogDescription();
                    }
                    if (PiracyChecker.access$getDisplay$p(this.this$0) == Display.DIALOG) {
                        PiracyChecker.access$dismissDialog(this.this$0);
                        string3 = this.this$0.getUnlicensedDialogTitle();
                        bl = false;
                        String string4 = string3;
                        if (string4 == null) {
                            string4 = "";
                        }
                        string3 = dialogContent;
                        bl = false;
                        String string5 = string3;
                        if (string5 == null) {
                            string5 = "";
                        }
                        PiracyChecker.access$setDialog$p(this.this$0, PiracyCheckerDialog.Companion.newInstance(string4, string5));
                        Context context = PiracyChecker.access$getContext$p(this.this$0);
                        if (context != null) {
                            string3 = context;
                            bl = false;
                            boolean bl2 = false;
                            String it = string3;
                            boolean bl3 = false;
                            PiracyCheckerDialog piracyCheckerDialog = PiracyChecker.access$getDialog$p(this.this$0);
                            if (piracyCheckerDialog != null) {
                                piracyCheckerDialog.show((Context)it);
                            } else {
                                ((Function0)start.doNotAllow.1.1.INSTANCE).invoke();
                            }
                        }
                    } else {
                        Context context;
                        Intent intent = new Intent(PiracyChecker.access$getContext$p(this.this$0), LicenseActivity.class).putExtra("content", dialogContent).putExtra("colorPrimary", PiracyChecker.access$getColorPrimary$p(this.this$0)).putExtra("colorPrimaryDark", PiracyChecker.access$getColorPrimaryDark$p(this.this$0)).putExtra("withLightStatusBar", PiracyChecker.access$getWithLightStatusBar$p(this.this$0)).putExtra("layoutXML", PiracyChecker.access$getLayoutXML$p(this.this$0));
                        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, LicenseA\u2026a(\"layoutXML\", layoutXML)");
                        Intent intent2 = intent;
                        Context context2 = PiracyChecker.access$getContext$p(this.this$0);
                        if (context2 != null) {
                            context2.startActivity(intent2);
                        }
                        if (!((context = PiracyChecker.access$getContext$p(this.this$0)) instanceof Activity)) {
                            context = null;
                        }
                        Activity activity = (Activity)context;
                        if (activity != null) {
                            activity.finish();
                        }
                        this.this$0.destroy();
                    }
                }
                {
                    this.this$0 = this$0;
                }
            });
        }
        this.verify();
    }

    private final void verify() {
        if (!this.verifySigningCertificate()) {
            DoNotAllowCallback doNotAllowCallback = this.doNotAllowCallback;
            if (doNotAllowCallback != null) {
                doNotAllowCallback.doNotAllow(PiracyCheckerError.SIGNATURE_NOT_VALID, null);
            }
        } else if (!this.verifyInstallerId()) {
            DoNotAllowCallback doNotAllowCallback = this.doNotAllowCallback;
            if (doNotAllowCallback != null) {
                doNotAllowCallback.doNotAllow(PiracyCheckerError.INVALID_INSTALLER_ID, null);
            }
        } else if (!this.verifyUnauthorizedApp()) {
            DoNotAllowCallback doNotAllowCallback = this.doNotAllowCallback;
            if (doNotAllowCallback != null) {
                doNotAllowCallback.doNotAllow(PiracyCheckerError.BLOCK_PIRATE_APP, null);
            }
        } else if (this.enableLVL) {
            Context context = this.context;
            String deviceId = Settings.Secure.getString((ContentResolver)(context != null ? context.getContentResolver() : null), (String)"android_id");
            this.destroyLVLChecker();
            Context context2 = this.context;
            LibraryChecker libraryChecker = this.libraryLVLChecker = new LibraryChecker(this.context, new ServerManagedPolicy(this.context, new AESObfuscator(SaltUtils.INSTANCE.getSalt(this.context), context2 != null ? context2.getPackageName() : null, deviceId)), this.licenseBase64);
            if (libraryChecker != null) {
                libraryChecker.checkAccess(new LibraryCheckerCallback(this){
                    final /* synthetic */ PiracyChecker this$0;

                    public void allow(int reason) {
                        PiracyChecker.access$doExtraVerification(this.this$0, true);
                    }

                    public void dontAllow(int reason) {
                        PiracyChecker.access$doExtraVerification(this.this$0, false);
                    }

                    public void applicationError(int errorCode) {
                        block0: {
                            OnErrorCallback onErrorCallback = PiracyChecker.access$getOnErrorCallback$p(this.this$0);
                            if (onErrorCallback == null) break block0;
                            onErrorCallback.onError(PiracyCheckerError.Companion.getCheckerErrorFromCode(errorCode));
                        }
                    }
                    {
                        this.this$0 = this$0;
                    }
                });
            }
        } else {
            this.doExtraVerification(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean verifySigningCertificate() {
        if (!this.enableSigningCertificate) return true;
        Context context = this.context;
        if (context == null) return false;
        if (!LibraryUtilsKt.verifySigningCertificates(context, this.signatures)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean verifyInstallerId() {
        if (this.installerIDs.isEmpty()) return true;
        Context context = this.context;
        if (context == null) return false;
        if (!LibraryUtilsKt.verifyInstallerId(context, this.installerIDs)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean verifyUnauthorizedApp() {
        if (!this.blockUnauthorized) return true;
        SharedPreferences sharedPreferences = this.preferences;
        if (sharedPreferences == null) return true;
        boolean bl = sharedPreferences.getBoolean(this.preferenceBlockUnauthorized, false);
        if (bl) return false;
        return true;
    }

    private final void doExtraVerification(boolean possibleSuccess) {
        block10: {
            SharedPreferences sharedPreferences;
            block13: {
                SharedPreferences sharedPreferences2;
                SharedPreferences sharedPreferences3;
                PirateApp app;
                block8: {
                    SharedPreferences sharedPreferences4;
                    block12: {
                        SharedPreferences sharedPreferences5;
                        SharedPreferences sharedPreferences6;
                        block11: {
                            SharedPreferences sharedPreferences7;
                            block9: {
                                SharedPreferences sharedPreferences8;
                                Context context = this.context;
                                PirateApp pirateApp = app = context != null ? LibraryUtilsKt.getPirateApp(context, this.enableUnauthorizedAppsCheck, this.enableStoresCheck, this.enableFoldersCheck, this.enableAPKCheck, this.extraApps) : null;
                                if (!possibleSuccess) break block8;
                                if (!this.enableDebugCheck) break block9;
                                Context context2 = this.context;
                                if (context2 == null) break block9;
                                if (!LibraryUtilsKt.isDebug(context2)) break block9;
                                if (this.saveToSharedPreferences && (sharedPreferences8 = this.preferences) != null && (sharedPreferences8 = sharedPreferences8.edit()) != null && (sharedPreferences8 = sharedPreferences8.putBoolean(this.preferenceSaveResult, false)) != null) {
                                    sharedPreferences8.apply();
                                }
                                DoNotAllowCallback doNotAllowCallback = this.doNotAllowCallback;
                                if (doNotAllowCallback == null) break block10;
                                doNotAllowCallback.doNotAllow(PiracyCheckerError.USING_DEBUG_APP, null);
                                break block10;
                            }
                            if (!this.enableEmulatorCheck || !LibraryUtilsKt.isInEmulator(this.enableDeepEmulatorCheck)) break block11;
                            if (this.saveToSharedPreferences && (sharedPreferences7 = this.preferences) != null && (sharedPreferences7 = sharedPreferences7.edit()) != null && (sharedPreferences7 = sharedPreferences7.putBoolean(this.preferenceSaveResult, false)) != null) {
                                sharedPreferences7.apply();
                            }
                            DoNotAllowCallback doNotAllowCallback = this.doNotAllowCallback;
                            if (doNotAllowCallback == null) break block10;
                            doNotAllowCallback.doNotAllow(PiracyCheckerError.USING_APP_IN_EMULATOR, null);
                            break block10;
                        }
                        if (app == null) break block12;
                        if (this.saveToSharedPreferences && (sharedPreferences6 = this.preferences) != null && (sharedPreferences6 = sharedPreferences6.edit()) != null && (sharedPreferences6 = sharedPreferences6.putBoolean(this.preferenceSaveResult, false)) != null) {
                            sharedPreferences6.apply();
                        }
                        if (this.blockUnauthorized && app.getType() == AppType.PIRATE && (sharedPreferences5 = this.preferences) != null && (sharedPreferences5 = sharedPreferences5.edit()) != null && (sharedPreferences5 = sharedPreferences5.putBoolean(this.preferenceBlockUnauthorized, true)) != null) {
                            sharedPreferences5.apply();
                        }
                        DoNotAllowCallback doNotAllowCallback = this.doNotAllowCallback;
                        if (doNotAllowCallback == null) break block10;
                        doNotAllowCallback.doNotAllow(app.getType() == AppType.STORE ? PiracyCheckerError.THIRD_PARTY_STORE_INSTALLED : PiracyCheckerError.PIRATE_APP_INSTALLED, app);
                        break block10;
                    }
                    if (this.saveToSharedPreferences && (sharedPreferences4 = this.preferences) != null && (sharedPreferences4 = sharedPreferences4.edit()) != null && (sharedPreferences4 = sharedPreferences4.putBoolean(this.preferenceSaveResult, true)) != null) {
                        sharedPreferences4.apply();
                    }
                    AllowCallback allowCallback = this.allowCallback;
                    if (allowCallback == null) break block10;
                    allowCallback.allow();
                    break block10;
                }
                if (app == null) break block13;
                if (this.saveToSharedPreferences && (sharedPreferences3 = this.preferences) != null && (sharedPreferences3 = sharedPreferences3.edit()) != null && (sharedPreferences3 = sharedPreferences3.putBoolean(this.preferenceSaveResult, false)) != null) {
                    sharedPreferences3.apply();
                }
                if (this.blockUnauthorized && app.getType() == AppType.PIRATE && (sharedPreferences2 = this.preferences) != null && (sharedPreferences2 = sharedPreferences2.edit()) != null && (sharedPreferences2 = sharedPreferences2.putBoolean(this.preferenceBlockUnauthorized, true)) != null) {
                    sharedPreferences2.apply();
                }
                DoNotAllowCallback doNotAllowCallback = this.doNotAllowCallback;
                if (doNotAllowCallback == null) break block10;
                doNotAllowCallback.doNotAllow(app.getType() == AppType.STORE ? PiracyCheckerError.THIRD_PARTY_STORE_INSTALLED : PiracyCheckerError.PIRATE_APP_INSTALLED, app);
                break block10;
            }
            if (this.saveToSharedPreferences && (sharedPreferences = this.preferences) != null && (sharedPreferences = sharedPreferences.edit()) != null && (sharedPreferences = sharedPreferences.putBoolean(this.preferenceSaveResult, false)) != null) {
                sharedPreferences.apply();
            }
            DoNotAllowCallback doNotAllowCallback = this.doNotAllowCallback;
            if (doNotAllowCallback == null) break block10;
            doNotAllowCallback.doNotAllow(PiracyCheckerError.NOT_LICENSED, null);
        }
    }

    private final void dismissDialog() {
        PiracyCheckerDialog piracyCheckerDialog = this.dialog;
        if (piracyCheckerDialog != null) {
            piracyCheckerDialog.dismiss();
        }
        this.dialog = null;
    }

    private final void destroyLVLChecker() {
        LibraryChecker libraryChecker = this.libraryLVLChecker;
        if (libraryChecker != null) {
            libraryChecker.finishAllChecks();
        }
        LibraryChecker libraryChecker2 = this.libraryLVLChecker;
        if (libraryChecker2 != null) {
            libraryChecker2.onDestroy();
        }
        this.libraryLVLChecker = null;
    }

    @Nullable
    public final String getUnlicensedDialogTitle() {
        return this.unlicensedDialogTitle;
    }

    public final void setUnlicensedDialogTitle(@Nullable String string2) {
        this.unlicensedDialogTitle = string2;
    }

    @Nullable
    public final String getUnlicensedDialogDescription() {
        return this.unlicensedDialogDescription;
    }

    public final void setUnlicensedDialogDescription(@Nullable String string2) {
        this.unlicensedDialogDescription = string2;
    }

    public PiracyChecker(@Nullable Context context, @Nullable String unlicensedDialogTitle, @Nullable String unlicensedDialogDescription) {
        this.context = context;
        this.unlicensedDialogTitle = unlicensedDialogTitle;
        this.unlicensedDialogDescription = unlicensedDialogDescription;
        this.layoutXML = -1;
        this.signatures = new String[0];
        this.display = Display.DIALOG;
        this.installerIDs = new ArrayList();
        this.extraApps = new ArrayList();
        this.colorPrimary = R.color.colorPrimary;
        this.colorPrimaryDark = R.color.colorPrimaryDark;
    }

    public /* synthetic */ PiracyChecker(Context context, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        String string4;
        if ((n & 2) != 0) {
            Context context2 = context;
            string4 = context2 != null ? context2.getString(R.string.app_unlicensed) : null;
            bl = false;
            String string5 = string4;
            if (string5 == null) {
                string5 = string2 = "";
            }
        }
        if ((n & 4) != 0) {
            Context context3 = context;
            string4 = context3 != null ? context3.getString(R.string.app_unlicensed_description) : null;
            bl = false;
            String string6 = string4;
            if (string6 == null) {
                string6 = "";
            }
            string3 = string6;
        }
        this(context, string2, string3);
    }

    public PiracyChecker(@Nullable Context context) {
        Context context2 = context;
        String string2 = context2 != null ? context2.getString(R.string.app_unlicensed) : null;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        Context context3 = context;
        string2 = context3 != null ? context3.getString(R.string.app_unlicensed_description) : null;
        bl = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        this(context, string3, string4);
    }

    public PiracyChecker(@Nullable Context context, @Nullable String title) {
        String string2 = title;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        Context context2 = context;
        string2 = context2 != null ? context2.getString(R.string.app_unlicensed_description) : null;
        bl = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        this(context, string3, string4);
    }

    public PiracyChecker(@Nullable Context context, @StringRes int title) {
        String string2;
        if (title != 0) {
            Context context2 = context;
            String string3 = context2 != null ? context2.getString(title) : null;
            boolean bl = false;
            string2 = string3;
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        this(context, string2);
    }

    public PiracyChecker(@Nullable Context context, @StringRes int title, @StringRes int description) {
        String string2;
        String string3;
        boolean bl;
        String string4;
        if (title != 0) {
            Context context2 = context;
            string4 = context2 != null ? context2.getString(title) : null;
            bl = false;
            string3 = string4;
            if (string3 == null) {
                string3 = "";
            }
        } else {
            string3 = "";
        }
        if (description != 0) {
            Context context3 = context;
            string4 = context3 != null ? context3.getString(description) : null;
            bl = false;
            string2 = string4;
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        this(context, string3, string2);
    }

    public static final /* synthetic */ Context access$getContext$p(PiracyChecker $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$setContext$p(PiracyChecker $this, Context context) {
        $this.context = context;
    }

    public static final /* synthetic */ Display access$getDisplay$p(PiracyChecker $this) {
        return $this.display;
    }

    public static final /* synthetic */ void access$setDisplay$p(PiracyChecker $this, Display display) {
        $this.display = display;
    }

    public static final /* synthetic */ void access$dismissDialog(PiracyChecker $this) {
        $this.dismissDialog();
    }

    public static final /* synthetic */ PiracyCheckerDialog access$getDialog$p(PiracyChecker $this) {
        return $this.dialog;
    }

    public static final /* synthetic */ void access$setDialog$p(PiracyChecker $this, PiracyCheckerDialog piracyCheckerDialog) {
        $this.dialog = piracyCheckerDialog;
    }

    public static final /* synthetic */ int access$getColorPrimary$p(PiracyChecker $this) {
        return $this.colorPrimary;
    }

    public static final /* synthetic */ void access$setColorPrimary$p(PiracyChecker $this, int n) {
        $this.colorPrimary = n;
    }

    public static final /* synthetic */ int access$getColorPrimaryDark$p(PiracyChecker $this) {
        return $this.colorPrimaryDark;
    }

    public static final /* synthetic */ void access$setColorPrimaryDark$p(PiracyChecker $this, int n) {
        $this.colorPrimaryDark = n;
    }

    public static final /* synthetic */ boolean access$getWithLightStatusBar$p(PiracyChecker $this) {
        return $this.withLightStatusBar;
    }

    public static final /* synthetic */ void access$setWithLightStatusBar$p(PiracyChecker $this, boolean bl) {
        $this.withLightStatusBar = bl;
    }

    public static final /* synthetic */ int access$getLayoutXML$p(PiracyChecker $this) {
        return $this.layoutXML;
    }

    public static final /* synthetic */ void access$setLayoutXML$p(PiracyChecker $this, int n) {
        $this.layoutXML = n;
    }

    public static final /* synthetic */ void access$doExtraVerification(PiracyChecker $this, boolean possibleSuccess) {
        $this.doExtraVerification(possibleSuccess);
    }

    public static final /* synthetic */ OnErrorCallback access$getOnErrorCallback$p(PiracyChecker $this) {
        return $this.onErrorCallback;
    }

    public static final /* synthetic */ void access$setOnErrorCallback$p(PiracyChecker $this, OnErrorCallback onErrorCallback) {
        $this.onErrorCallback = onErrorCallback;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/javiersantos/piracychecker/PiracyChecker$Companion;", "", "()V", "LIBRARY_PREFERENCES_NAME", "", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

