/*
 * Decompiled with CFR 0.152.
 */
package com.github.joelittlejohn.embedmongo;

import com.github.joelittlejohn.embedmongo.PortUtils;
import com.github.joelittlejohn.embedmongo.log.Loggers;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfig;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.GenericVersion;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.exceptions.DistributionException;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class StartEmbeddedMongoMojo
extends AbstractMojo {
    private static final String PACKAGE_NAME = StartEmbeddedMongoMojo.class.getPackage().getName();
    public static final String MONGOD_CONTEXT_PROPERTY_NAME = PACKAGE_NAME + ".mongod";
    private int port;
    private boolean randomPort;
    private String version;
    private File databaseDirectory;
    private String bindIp;
    private String proxyHost;
    private int proxyPort;
    private boolean wait;
    private String logging;
    private String logFile;
    private String logFileEncoding;
    private String proxyUser;
    private String proxyPassword;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MongodExecutable executable;
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            this.addProxySelector();
        }
        try {
            IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaults(Command.MongoD).processOutput(this.getOutputConfig()).build();
            if (this.randomPort) {
                this.port = PortUtils.allocateRandomPort();
            }
            this.savePortToProjectProperties();
            MongodConfig mongoConfig = new MongodConfig(this.getVersion(), new AbstractMongoConfig.Net(this.bindIp, this.port, Network.localhostIsIPv6()), new AbstractMongoConfig.Storage(this.getDataDirectory(), null, 0), new AbstractMongoConfig.Timeout());
            executable = (MongodExecutable)MongodStarter.getInstance((IRuntimeConfig)runtimeConfig).prepare((ExecutableProcessConfig)mongoConfig);
        }
        catch (UnknownHostException e) {
            throw new MojoExecutionException("Unable to determine if localhost is ipv6", (Exception)e);
        }
        catch (DistributionException e) {
            throw new MojoExecutionException("Failed to download MongoDB distribution: " + e.withDistribution(), (Exception)((Object)e));
        }
        try {
            MongodProcess mongod = (MongodProcess)executable.start();
            if (this.wait) {
                try {
                    while (true) {
                        TimeUnit.MINUTES.sleep(5L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.getPluginContext().put(MONGOD_CONTEXT_PROPERTY_NAME, mongod);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to start the mongod", (Exception)e);
        }
    }

    private void savePortToProjectProperties() {
        this.project.getProperties().put("embedmongo.port", String.valueOf(this.port));
    }

    private ProcessOutput getOutputConfig() throws MojoFailureException {
        Loggers.LoggingStyle loggingStyle = Loggers.LoggingStyle.valueOf(this.logging.toUpperCase());
        switch (loggingStyle) {
            case CONSOLE: {
                return Loggers.console();
            }
            case FILE: {
                return Loggers.file(this.logFile, this.logFileEncoding);
            }
            case NONE: {
                return Loggers.none();
            }
        }
        throw new MojoFailureException("Unexpected logging style encountered: \"" + this.logging + "\" -> " + (Object)((Object)loggingStyle));
    }

    private void addProxySelector() {
        if (this.proxyUser != null && this.proxyPassword != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(StartEmbeddedMongoMojo.this.proxyUser, StartEmbeddedMongoMojo.this.proxyPassword.toCharArray());
                }
            });
        }
        final ProxySelector defaultProxySelector = ProxySelector.getDefault();
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                if (uri.getHost().equals("fastdl.mongodb.org")) {
                    return Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(StartEmbeddedMongoMojo.this.proxyHost, StartEmbeddedMongoMojo.this.proxyPort)));
                }
                return defaultProxySelector.select(uri);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        });
    }

    private IVersion getVersion() {
        String versionEnumName = this.version.toUpperCase().replaceAll("\\.", "_");
        if (versionEnumName.charAt(0) != 'V') {
            versionEnumName = "V" + versionEnumName;
        }
        try {
            return Version.valueOf((String)versionEnumName);
        }
        catch (IllegalArgumentException e) {
            this.getLog().warn((CharSequence)("Unrecognised MongoDB version '" + this.version + "', this might be a new version that we don't yet know about. Attemping download anyway..."));
            return new GenericVersion(this.version);
        }
    }

    private String getDataDirectory() {
        if (this.databaseDirectory != null) {
            return this.databaseDirectory.getAbsolutePath();
        }
        return null;
    }
}

