/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import java.util.LinkedList;
import org.jsfr.json.JsonPathListener;
import org.jsfr.json.ParsingContext;
import org.jsfr.json.SurfingConfiguration;

public class BufferedListener
implements JsonPathListener {
    private SurfingConfiguration config;
    private JsonPathListener underlyingListener;
    private LinkedList<ValueAndContext> buffer;

    public BufferedListener(SurfingConfiguration config, JsonPathListener underlyingListener) {
        this.config = config;
        this.underlyingListener = underlyingListener;
        this.buffer = new LinkedList();
    }

    @Override
    public void onValue(Object value, ParsingContext context) {
        this.buffer.add(new ValueAndContext(value, context));
    }

    public void invokeBufferedValue() {
        while (!this.buffer.isEmpty()) {
            ValueAndContext valueAndContext = this.buffer.poll();
            if (valueAndContext.context.isStopped()) break;
            try {
                this.underlyingListener.onValue(valueAndContext.value, valueAndContext.context);
            }
            catch (Exception e) {
                this.config.getErrorHandlingStrategy().handleExceptionFromListener(e, valueAndContext.context);
            }
        }
    }

    class ValueAndContext {
        Object value;
        ParsingContext context;

        ValueAndContext(Object value, ParsingContext context) {
            this.value = value;
            this.context = context;
        }
    }
}

