/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.core;

import com.github.jtreport.annotation.TestClassReport;
import com.github.jtreport.annotation.TestSingleReport;
import com.github.jtreport.core.PrinterGlobalTypeEnum;
import com.github.jtreport.core.ReportSummary;
import com.github.jtreport.core.ReportTypePrinterEnum;
import com.github.jtreport.core.StateTestEnum;
import com.github.jtreport.core.TestClassResult;
import com.github.jtreport.core.TestMethodResult;
import com.github.jtreport.printer.core.IPrinterStrategy;
import com.github.jtreport.printer.core.PrinterContext;
import com.github.jtreport.printer.core.PrinterContextFactory;
import com.github.jtreport.printer.velocity.PrintVelocityResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportTestListner
extends RunListener {
    private static final Logger L = LoggerFactory.getLogger(AbstractReportTestListner.class);
    private final ArrayList<TestMethodResult> testMethodResultList = new ArrayList();
    private final Map<String, Long> testRunningTime = new HashMap<String, Long>();

    private Map<Class<?>, TestClassResult> createTestResult(Result result) {
        Object object;
        Object object2;
        List list = result.getFailures();
        for (Object object3 : list) {
            Description object4 = object3.getDescription();
            object2 = object4.getMethodName();
            for (TestMethodResult testMethodResult : this.testMethodResultList) {
                object = testMethodResult.getTestMethodName();
                if (!StringUtils.equals((String)object, (String)object2)) continue;
                TestSingleReport testSingleReport = (TestSingleReport)testMethodResult.getDescriptionResult().getAnnotation(TestSingleReport.class);
                Throwable throwable = object3.getException();
                String string = throwable.getClass().getName();
                String string2 = throwable.getMessage();
                String string3 = string + ": " + string2;
                testMethodResult.setResultDescription(string3);
                if (throwable instanceof AssertionError) {
                    testMethodResult.setTestState(StateTestEnum.FAILED);
                    if (testSingleReport == null || !StringUtils.isNotBlank((String)testSingleReport.failed())) continue;
                    testMethodResult.setResultDescription(testSingleReport.failed());
                    continue;
                }
                testMethodResult.setTestState(StateTestEnum.ERROR);
                if (testSingleReport == null || !StringUtils.isNotBlank((String)testSingleReport.error())) continue;
                testMethodResult.setResultDescription(testSingleReport.error());
            }
        }
        HashMap hashMap = new HashMap();
        for (TestMethodResult testMethodResult : this.testMethodResultList) {
            Object object3;
            object2 = testMethodResult.getDescriptionResult().getTestClass();
            if (!hashMap.containsKey(object2)) {
                object3 = "";
                TestClassReport testClassReport = ((Class)object2).getAnnotation(TestClassReport.class);
                if (testClassReport != null) {
                    object3 = testClassReport.description();
                } else {
                    L.debug("The test Class [" + ((Class)object2).getName() + "] not have annotation for report");
                }
                object = new TestClassResult(this.setReportName(((Class)object2).getName()), (String)object3);
                hashMap.put(object2, object);
            }
            object3 = (TestClassResult)hashMap.get(object2);
            StateTestEnum stateTestEnum = testMethodResult.getTestState();
            ((TestClassResult)object3).addTestRun();
            ((TestClassResult)object3).addTestMethodResult(testMethodResult);
            switch (stateTestEnum) {
                case PASSED: {
                    ((TestClassResult)object3).addTestPassed();
                    break;
                }
                case ERROR: {
                    ((TestClassResult)object3).addTestError();
                    break;
                }
                case FAILED: {
                    ((TestClassResult)object3).addTestFailed();
                    break;
                }
                case IGNORED: {
                    ((TestClassResult)object3).addTestIgnored();
                }
            }
            hashMap.put(object2, object3);
        }
        return hashMap;
    }

    abstract ReportSummary getReportSummary(Class<?> var1);

    abstract String setReportName(String var1);

    public void testAssumptionFailure(Failure failure) {
        super.testAssumptionFailure(failure);
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
    }

    public void testFinished(Description description) throws Exception {
        TestSingleReport testSingleReport = (TestSingleReport)description.getAnnotation(TestSingleReport.class);
        String string = description.getMethodName();
        if (testSingleReport != null) {
            String string2 = testSingleReport.passed();
            String string3 = testSingleReport.description();
            String string4 = testSingleReport.expectations();
            String string5 = testSingleReport.keyCustomReport();
            String string6 = "Passed";
            if (StringUtils.isNotBlank((String)string2)) {
                string6 = string2;
            }
            TestMethodResult testMethodResult = new TestMethodResult(description, description.getTestClass().getSimpleName(), string, string3, string4, new DateTime(), StateTestEnum.PASSED, string6, 0.0, string5);
            this.testMethodResultList.add(testMethodResult);
            L.debug("Test [" + string + "] duration[" + 0.0 + "]");
        } else {
            L.debug("The test [" + string + "] not have annotation for report");
        }
        super.testFinished(description);
    }

    public void testIgnored(Description description) throws Exception {
        TestSingleReport testSingleReport = (TestSingleReport)description.getAnnotation(TestSingleReport.class);
        String string = description.getMethodName();
        if (testSingleReport != null) {
            Object object;
            String string2 = testSingleReport.ignored();
            String string3 = testSingleReport.description();
            String string4 = testSingleReport.expectations();
            String string5 = testSingleReport.keyCustomReport();
            String string6 = "Ignored";
            Ignore ignore = (Ignore)description.getAnnotation(Ignore.class);
            if (ignore != null) {
                object = ignore.value();
                String string7 = string6 = StringUtils.isNotBlank((String)object) ? object : string6;
            }
            if (StringUtils.isNotBlank((String)string2)) {
                string6 = string2;
            }
            object = new TestMethodResult(description, description.getTestClass().getSimpleName(), string, string3, string4, new DateTime(), StateTestEnum.IGNORED, string6, 0.0, string5);
            this.testMethodResultList.add((TestMethodResult)object);
            L.debug("Test [" + string + "] duration[" + 0L + "]");
        } else {
            L.debug("The test [" + string + "] not have annotation for report");
        }
        super.testIgnored(description);
    }

    public void testRunFinished(Result result) throws Exception {
        block9: {
            block7: {
                block8: {
                    if (this.testMethodResultList.size() <= 0) break block7;
                    String string = "";
                    String string2 = "";
                    Class clazz = this.testMethodResultList.get(0).getDescriptionResult().getTestClass();
                    ReportSummary reportSummary = this.getReportSummary(clazz);
                    if (reportSummary == null) break block8;
                    IPrinterStrategy iPrinterStrategy = null;
                    boolean bl = reportSummary.isMargeSurefireReport();
                    string = reportSummary.getVelocityTemplatePath();
                    string2 = reportSummary.getOutPathDir();
                    iPrinterStrategy = reportSummary.getCustomJtPrinter();
                    Collection<ReportTypePrinterEnum> collection = reportSummary.getReportPrinterType();
                    Map<Class<?>, TestClassResult> map = this.createTestResult(result);
                    ArrayList<TestClassResult> arrayList = new ArrayList<TestClassResult>();
                    for (Class<?> object : map.keySet()) {
                        arrayList.add(map.get(object));
                    }
                    PrinterGlobalTypeEnum printerGlobalTypeEnum = reportSummary.getPrinterType();
                    switch (printerGlobalTypeEnum) {
                        case CUSTOM: {
                            iPrinterStrategy.print(arrayList, string2);
                            break;
                        }
                        case DEFAULT: {
                            for (ReportTypePrinterEnum reportTypePrinterEnum : collection) {
                                PrinterContextFactory printerContextFactory = new PrinterContextFactory();
                                PrinterContext printerContext = printerContextFactory.createPrinter(reportTypePrinterEnum, bl);
                                printerContext.printReport(arrayList, string2);
                            }
                            break block9;
                        }
                        case VELOCITY: {
                            L.debug("Velocity printer selected why velocityTemplate: [" + string + "]");
                            PrintVelocityResult printVelocityResult = new PrintVelocityResult();
                            printVelocityResult.print(arrayList, string, string2, reportSummary.isTemplateWithKey());
                        }
                    }
                    break block9;
                }
                L.debug("ReportSummary is null");
                break block9;
            }
            L.debug("Not have tests to report");
        }
        super.testRunFinished(result);
    }

    public void testStarted(Description description) throws Exception {
        TestSingleReport testSingleReport = (TestSingleReport)description.getAnnotation(TestSingleReport.class);
        String string = description.getMethodName();
        if (testSingleReport != null) {
            this.testRunningTime.put(string, System.nanoTime());
        } else {
            L.debug("The test [" + string + "] not have annotation for report");
        }
        super.testStarted(description);
    }
}

