/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.core;

import com.github.jtreport.core.PrinterGlobalTypeEnum;
import com.github.jtreport.core.ReportTypePrinterEnum;
import com.github.jtreport.printer.core.IPrinterStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportSummary {
    private static final Logger L = LoggerFactory.getLogger(ReportSummary.class);
    private Collection<ReportTypePrinterEnum> reportPrinterType = new ArrayList<ReportTypePrinterEnum>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(ReportTypePrinterEnum.PDF);
        }
    };
    private String outPathDir = null;
    private String velocityTemplatePath = null;
    private boolean templateWithKey = false;
    private IPrinterStrategy customJtPrinter;
    private PrinterGlobalTypeEnum printerType = PrinterGlobalTypeEnum.DEFAULT;
    private boolean margeSurefireReport = false;

    public ReportSummary(IPrinterStrategy iPrinterStrategy, boolean bl) {
        this.printerType = PrinterGlobalTypeEnum.CUSTOM;
        this.templateWithKey = bl;
        this.customJtPrinter = iPrinterStrategy;
    }

    public ReportSummary(String string, Collection<ReportTypePrinterEnum> collection) {
        this.printerType = PrinterGlobalTypeEnum.DEFAULT;
        this.reportPrinterType = collection;
        this.outPathDir = string;
    }

    public ReportSummary(String string, String string2, boolean bl) {
        this.printerType = PrinterGlobalTypeEnum.VELOCITY;
        this.outPathDir = string2;
        this.velocityTemplatePath = string;
        this.templateWithKey = bl;
    }

    public ReportSummary(String string) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        Properties properties = new Properties();
        try {
            Object object;
            properties.load(inputStream);
            this.outPathDir = properties.getProperty("jtreportDir");
            this.velocityTemplatePath = properties.getProperty("veolocityTemplatePath");
            String string2 = properties.getProperty("templateWithKey");
            this.templateWithKey = StringUtils.equalsIgnoreCase((String)string2, (String)"true");
            String string3 = properties.getProperty("margeReport");
            this.margeSurefireReport = StringUtils.equalsIgnoreCase((String)string3, (String)"true");
            String string4 = properties.getProperty("printerType");
            String string5 = properties.getProperty("reportPrinterFormat");
            String[] stringArray = StringUtils.split((String)string5, (String)",");
            if (stringArray != null && stringArray.length > 0) {
                this.reportPrinterType = new ArrayList<ReportTypePrinterEnum>();
                object = stringArray;
                int n = ((String[])object).length;
                for (int i = 0; i < n; ++i) {
                    String string6 = object[i];
                    try {
                        ReportTypePrinterEnum reportTypePrinterEnum = ReportTypePrinterEnum.valueOf(string6);
                        this.reportPrinterType.add(reportTypePrinterEnum);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        L.warn("ReportTypePrinterEnum value [" + string6 + "] not found.");
                        L.debug("ReportTypePrinterEnum value [" + string6 + "] not found.", (Throwable)illegalArgumentException);
                    }
                }
            }
            if (this.reportPrinterType.size() == 0) {
                this.reportPrinterType.add(ReportTypePrinterEnum.PDF);
            }
            if (StringUtils.equalsIgnoreCase((String)string4, (String)PrinterGlobalTypeEnum.CUSTOM.name())) {
                this.printerType = PrinterGlobalTypeEnum.CUSTOM;
            }
            if (StringUtils.equalsIgnoreCase((String)string4, (String)PrinterGlobalTypeEnum.VELOCITY.name())) {
                this.printerType = PrinterGlobalTypeEnum.VELOCITY;
            }
            if (StringUtils.isNotBlank((String)(object = properties.getProperty("customPrinterClass")))) {
                try {
                    this.customJtPrinter = (IPrinterStrategy)Class.forName((String)object).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    L.error("Error Class [" + (String)object + "] not found!", (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    L.error("Instantiation Exception for class  [" + (String)object + "]", (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    L.error("Illegal acces for class  [" + (String)object + "]", (Throwable)illegalAccessException);
                }
            }
        }
        catch (IOException iOException) {
            L.error("Load jterport properties file error.", (Throwable)iOException);
        }
    }

    IPrinterStrategy getCustomJtPrinter() {
        return this.customJtPrinter;
    }

    String getOutPathDir() {
        return this.outPathDir;
    }

    PrinterGlobalTypeEnum getPrinterType() {
        return this.printerType;
    }

    Collection<ReportTypePrinterEnum> getReportPrinterType() {
        return this.reportPrinterType;
    }

    String getVelocityTemplatePath() {
        return this.velocityTemplatePath;
    }

    boolean isTemplateWithKey() {
        return this.templateWithKey;
    }

    public boolean isMargeSurefireReport() {
        return this.margeSurefireReport;
    }
}

