/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.core;

import com.github.jtreport.core.TestMethodResult;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClassResult {
    private Collection<TestMethodResult> testMethodResultList = new ArrayList<TestMethodResult>();
    private final String descriptionSummary;
    private long runningTime = 0L;
    private int totalRun = 0;
    private int totalPassed = 0;
    private int totalFailed = 0;
    private int totalError = 0;
    private int totalIgnored = 0;
    private final String testClassName;

    public TestClassResult(String string, Collection<TestMethodResult> collection, String string2, long l, int n, int n2, int n3, int n4, int n5) {
        this.testMethodResultList = collection;
        this.descriptionSummary = string2;
        this.runningTime = l;
        this.totalRun = n;
        this.totalPassed = n2;
        this.totalFailed = n3;
        this.totalError = n4;
        this.totalIgnored = n5;
        this.testClassName = string;
    }

    public TestClassResult(String string, String string2) {
        this.descriptionSummary = string2;
        this.testClassName = string;
    }

    public void addRunningTime(long l) {
        this.runningTime += l;
    }

    public void addTestError() {
        ++this.totalError;
    }

    public void addTestFailed() {
        ++this.totalFailed;
    }

    public void addTestIgnored() {
        ++this.totalIgnored;
    }

    public void addTestMethodResult(TestMethodResult testMethodResult) {
        if (testMethodResult != null) {
            this.testMethodResultList.add(testMethodResult);
        }
    }

    public void addTestPassed() {
        ++this.totalPassed;
    }

    public void addTestRun() {
        ++this.totalRun;
    }

    public String getDescriptionSummary() {
        return this.descriptionSummary;
    }

    public long getRunningTime() {
        return this.runningTime;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public Collection<TestMethodResult> getTestMethodResultList() {
        return this.testMethodResultList;
    }

    public int getTotalError() {
        return this.totalError;
    }

    public int getTotalFailed() {
        return this.totalFailed;
    }

    public int getTotalIgnored() {
        return this.totalIgnored;
    }

    public int getTotalPassed() {
        return this.totalPassed;
    }

    public int getTotalRun() {
        return this.totalRun;
    }
}

