/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.printer.core;

import com.github.jtreport.core.StateTestEnum;
import com.github.jtreport.core.TestClassResult;
import com.github.jtreport.datasource.DataSourceUtils;
import com.github.jtreport.printer.core.IPrinterStrategy;
import com.github.jtreport.printer.core.Templates;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.sf.dynamicreports.jasper.builder.JasperConcatenatedReportBuilder;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.ReportTemplateBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.Columns;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.Components;
import net.sf.dynamicreports.report.builder.datatype.DataTypes;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPrinterStrategyTemaplate
implements IPrinterStrategy {
    private boolean margeReport = false;
    private static final Logger L = LoggerFactory.getLogger(AbstractPrinterStrategyTemaplate.class);

    protected abstract void addColumn(JasperReportBuilder var1);

    protected abstract void addTitle(JasperReportBuilder var1, String var2);

    public JasperReportBuilder createReport(TestClassResult testClassResult, JasperReportBuilder jasperReportBuilder) {
        HashMap<StateTestEnum, String> hashMap = new HashMap<StateTestEnum, String>();
        hashMap.put(StateTestEnum.PASSED, testClassResult.getTotalPassed() + "");
        hashMap.put(StateTestEnum.ERROR, testClassResult.getTotalError() + "");
        hashMap.put(StateTestEnum.FAILED, testClassResult.getTotalFailed() + "");
        hashMap.put(StateTestEnum.IGNORED, testClassResult.getTotalIgnored() + "");
        jasperReportBuilder.addTitle(new ComponentBuilder[]{Templates.createTitleComponent(testClassResult.getTestClassName(), false)});
        jasperReportBuilder.title(new ComponentBuilder[]{Templates.createSubTitleComponent(testClassResult.getDescriptionSummary())});
        jasperReportBuilder.title(new ComponentBuilder[]{Templates.createSubTitleTestResult(hashMap, testClassResult.getTotalRun(), "")});
        jasperReportBuilder.fields(new FieldBuilder[]{DynamicReports.field((String)"state", String.class)});
        jasperReportBuilder.setTemplate(this.setReportTemplate());
        this.addColumn(jasperReportBuilder);
        jasperReportBuilder.addColumn(new ColumnBuilder[]{Columns.column((String)"Test name", (String)"testName", (DRIDataType)DataTypes.stringType())});
        jasperReportBuilder.addColumn(new ColumnBuilder[]{Columns.column((String)"Test description", (String)"testDescription", (DRIDataType)DataTypes.stringType())});
        jasperReportBuilder.addColumn(new ColumnBuilder[]{Columns.column((String)"Expectations: ", (String)"expectations", (DRIDataType)DataTypes.stringType())});
        jasperReportBuilder.addColumn(new ColumnBuilder[]{Columns.column((String)"Result: ", (String)"resultDescription", (DRIDataType)DataTypes.stringType())});
        jasperReportBuilder.addColumn(new ColumnBuilder[]{Columns.column((String)"Date:", (String)"formattedDate", (DRIDataType)DataTypes.stringType())});
        jasperReportBuilder.setDataSource((JRDataSource)DataSourceUtils.createDataSource(testClassResult.getTestMethodResultList()));
        jasperReportBuilder.highlightDetailEvenRows();
        jasperReportBuilder.addPageFooter(new ComponentBuilder[]{Components.pageNumber()});
        return jasperReportBuilder;
    }

    public boolean isMargeReport() {
        return this.margeReport;
    }

    @Override
    public void print(Collection<TestClassResult> collection, String string) {
        L.info("Number of TestClassReport [" + collection.size() + "]");
        if (this.isMargeReport() && collection != null && StringUtils.isNotBlank((String)string)) {
            this.printMarge(collection, string);
        } else if (collection != null && StringUtils.isNotBlank((String)string)) {
            this.printNoMarge(collection, string);
        } else {
            L.warn("Not print the report because globalTestResults [" + collection + "], dirOutPath [" + string + "]");
        }
    }

    protected abstract void printConcatenateReport(JasperConcatenatedReportBuilder var1, OutputStream var2) throws DRException;

    private void printMarge(Collection<TestClassResult> collection, String string) {
        String string2 = "Jtreport" + new DateTime().toString(ISODateTimeFormat.basicDateTimeNoMillis()) + "_" + new Random().nextInt(1000) + this.setExtension();
        try {
            JasperReportBuilder jasperReportBuilder;
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            string2 = file.getPath() + "/" + string2;
            L.debug("Report saved in [" + string2 + "]");
            File file2 = new File(string2);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            JasperReportBuilder jasperReportBuilder2 = DynamicReports.report();
            this.setBackground(jasperReportBuilder2);
            ArrayList<TestClassResult> arrayList = new ArrayList<TestClassResult>(collection);
            TestClassResult testClassResult = arrayList.get(0);
            this.addTitle(jasperReportBuilder2, "");
            ArrayList<JasperReportBuilder> arrayList2 = new ArrayList<JasperReportBuilder>();
            int n = arrayList.size();
            if (n > 1) {
                jasperReportBuilder = this.createReport(testClassResult, jasperReportBuilder2);
                arrayList2.add(jasperReportBuilder);
                arrayList.remove(0);
            }
            for (TestClassResult testClassResult2 : arrayList) {
                JasperReportBuilder jasperReportBuilder3 = this.createReport(testClassResult2, DynamicReports.report());
                arrayList2.add(jasperReportBuilder3);
            }
            jasperReportBuilder = DynamicReports.concatenatedReport().continuousPageNumbering().concatenate(arrayList2.toArray(new JasperReportBuilder[arrayList2.size()]));
            this.printConcatenateReport((JasperConcatenatedReportBuilder)jasperReportBuilder, fileOutputStream);
        }
        catch (DRException dRException) {
            L.error("Error during the report creation.", (Throwable)dRException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            L.error("File not found [" + string + "]", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            L.error("IOException during the report creation.", (Throwable)iOException);
        }
    }

    private void printNoMarge(Collection<TestClassResult> collection, String string) {
        for (TestClassResult testClassResult : collection) {
            try {
                String string2 = testClassResult.getTestClassName();
                String string3 = string2 + new DateTime().toString(ISODateTimeFormat.basicDateTimeNoMillis()) + "_" + new Random().nextInt(1000) + this.setExtension();
                File file = new File(string);
                if (!file.exists()) {
                    file.mkdirs();
                }
                string3 = file.getPath() + "/" + string3;
                L.debug("Report saved in [" + string3 + "]");
                File file2 = new File(string3);
                if (!file2.exists()) {
                    file2.createNewFile();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                JasperReportBuilder jasperReportBuilder = DynamicReports.report();
                this.setBackground(jasperReportBuilder);
                this.addTitle(jasperReportBuilder, "");
                this.createReport(testClassResult, jasperReportBuilder);
                this.printReport(jasperReportBuilder, fileOutputStream);
            }
            catch (DRException dRException) {
                L.error("Error during the report creation.", (Throwable)dRException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                L.error("File not found [" + string + "]", (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                L.error("IOException during the report creation.", (Throwable)iOException);
            }
        }
    }

    public abstract void printReport(JasperReportBuilder var1, OutputStream var2) throws DRException;

    protected abstract void setBackground(JasperReportBuilder var1);

    protected abstract String setExtension();

    public void setMargeReport(boolean bl) {
        this.margeReport = bl;
    }

    protected abstract ReportTemplateBuilder setReportTemplate();
}

