/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.printer.core;

import com.github.jtreport.core.ReportTypePrinterEnum;
import com.github.jtreport.printer.core.PrinterContext;
import com.github.jtreport.printer.csv.PrinterCsvStrategy;
import com.github.jtreport.printer.html.PrinterHtmlStrategy;
import com.github.jtreport.printer.jrxml.PrinterJrxmlStrategy;
import com.github.jtreport.printer.ods.PrinterOdsStrategy;
import com.github.jtreport.printer.odt.PrinterOdtStrategy;
import com.github.jtreport.printer.pdf.PrinterPdfStrategy;
import com.github.jtreport.printer.png.PrinterPngStrategy;
import com.github.jtreport.printer.xhtml.PrinterXHtmlStrategy;
import com.github.jtreport.printer.xml.PrinterXmlStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrinterContextFactory {
    private static final Logger L = LoggerFactory.getLogger(PrinterContextFactory.class);

    public PrinterContext createPrinter(ReportTypePrinterEnum reportTypePrinterEnum, boolean bl) {
        PrinterContext printerContext = new PrinterContext();
        switch (reportTypePrinterEnum) {
            case HTML: {
                L.debug("HTML printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterHtmlStrategy printerHtmlStrategy = new PrinterHtmlStrategy();
                printerHtmlStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerHtmlStrategy);
                break;
            }
            case PDF: {
                L.debug("PDF printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterPdfStrategy printerPdfStrategy = new PrinterPdfStrategy();
                printerPdfStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerPdfStrategy);
                break;
            }
            case XML: {
                L.debug("XML printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterXmlStrategy printerXmlStrategy = new PrinterXmlStrategy();
                printerXmlStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerXmlStrategy);
                break;
            }
            case CSV: {
                L.debug("CSV printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterCsvStrategy printerCsvStrategy = new PrinterCsvStrategy();
                printerCsvStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerCsvStrategy);
                break;
            }
            case XHTML: {
                L.debug("XHTML printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterXHtmlStrategy printerXHtmlStrategy = new PrinterXHtmlStrategy();
                printerXHtmlStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerXHtmlStrategy);
                break;
            }
            case ODS: {
                L.debug("ODS printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterOdsStrategy printerOdsStrategy = new PrinterOdsStrategy();
                printerOdsStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerOdsStrategy);
                break;
            }
            case ODT: {
                L.debug("ODT printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterOdtStrategy printerOdtStrategy = new PrinterOdtStrategy();
                printerOdtStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerOdtStrategy);
                break;
            }
            case PNG: {
                L.debug("PNG printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterPngStrategy printerPngStrategy = new PrinterPngStrategy();
                printerPngStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerPngStrategy);
                break;
            }
            case JRXML: {
                L.debug("JRXML printer selected why reportType: [" + reportTypePrinterEnum.name() + "]");
                PrinterJrxmlStrategy printerJrxmlStrategy = new PrinterJrxmlStrategy();
                printerJrxmlStrategy.setMargeReport(bl);
                printerContext.setPrinterStrategy(printerJrxmlStrategy);
            }
        }
        return printerContext;
    }
}

