/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.printer.core;

import com.github.jtreport.core.StateTestEnum;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import net.sf.dynamicreports.report.base.expression.AbstractValueFormatter;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.ReportTemplateBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.FillerBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.datatype.BigDecimalType;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.LineStyle;
import net.sf.dynamicreports.report.constant.VerticalAlignment;
import net.sf.dynamicreports.report.definition.ReportParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Templates {
    public static final StyleBuilder rootStyle = (StyleBuilder)DynamicReports.stl.style().setPadding(Integer.valueOf(2));
    public static final StyleBuilder boldStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)rootStyle).bold();
    public static final StyleBuilder italicStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)rootStyle).italic();
    public static final StyleBuilder boldCenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldStyle).setAlignment(HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE);
    public static final StyleBuilder bold12CenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setFontSize(Integer.valueOf(12));
    public static final StyleBuilder bold18CenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setFontSize(Integer.valueOf(18));
    public static final StyleBuilder bold22CenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setFontSize(Integer.valueOf(22));
    public static final StyleBuilder columnStyle = (StyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)rootStyle).setHorizontalAlignment(HorizontalAlignment.CENTER)).setVerticalAlignment(VerticalAlignment.MIDDLE)).setBorder(DynamicReports.stl.pen1Point().setLineStyle(LineStyle.SOLID));
    public static final StyleBuilder columnTitleStyle = (StyleBuilder)((StyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)columnStyle).setBorder(DynamicReports.stl.pen1Point())).setHorizontalAlignment(HorizontalAlignment.CENTER)).setBackgroundColor(Color.CYAN)).bold();
    public static final StyleBuilder groupStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldStyle).setHorizontalAlignment(HorizontalAlignment.LEFT);
    public static final StyleBuilder subtotalStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldStyle).setTopBorder(DynamicReports.stl.pen1Point());
    public static final ReportTemplateBuilder reportTemplate = DynamicReports.template().setLocale(Locale.ENGLISH).setColumnStyle((ReportStyleBuilder)columnStyle).setColumnTitleStyle((ReportStyleBuilder)columnTitleStyle).setGroupStyle((ReportStyleBuilder)groupStyle).setGroupTitleStyle((ReportStyleBuilder)groupStyle).setSubtotalStyle((ReportStyleBuilder)subtotalStyle);
    public static final CurrencyType currencyType = new CurrencyType();
    public static final ComponentBuilder<?, ?> dynamicReportsComponent = DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.image(Templates.class.getClassLoader().getResource("img/logo.png")).setHorizontalAlignment(HorizontalAlignment.RIGHT)})});
    public static final ComponentBuilder<?, ?> footerComponent = DynamicReports.cmp.pageXofY().setStyle((ReportStyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setTopBorder(DynamicReports.stl.pen1Point()));

    public static CurrencyValueFormatter createCurrencyValueFormatter(String string) {
        return new CurrencyValueFormatter(string);
    }

    public static ComponentBuilder<?, ?> createSubTitleComponent(String string) {
        return DynamicReports.cmp.verticalList().add(new ComponentBuilder[]{((TextFieldBuilder)DynamicReports.cmp.text("General description").setStyle((ReportStyleBuilder)bold18CenteredStyle)).setHorizontalAlignment(HorizontalAlignment.LEFT), ((TextFieldBuilder)DynamicReports.cmp.text(string).setStyle((ReportStyleBuilder)rootStyle)).setHorizontalAlignment(HorizontalAlignment.LEFT), DynamicReports.cmp.verticalGap(20)});
    }

    public static ComponentBuilder<?, ?> createSubTitleTestResult(Map<StateTestEnum, String> map, int n, String string) {
        String string2 = map.get((Object)StateTestEnum.PASSED);
        String string3 = map.get((Object)StateTestEnum.ERROR);
        String string4 = map.get((Object)StateTestEnum.FAILED);
        String string5 = map.get((Object)StateTestEnum.IGNORED);
        return DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.text("Test run: " + n + ", passed: " + string2 + ", error: " + string3 + ", failed: " + string4 + ", ignored: " + string5), DynamicReports.cmp.verticalGap(10)});
    }

    public static ComponentBuilder<?, ?> createTitleComponent(String string, boolean bl) {
        HorizontalListBuilder horizontalListBuilder = DynamicReports.cmp.horizontalList();
        TextFieldBuilder textFieldBuilder = ((TextFieldBuilder)DynamicReports.cmp.text(string).setStyle((ReportStyleBuilder)bold18CenteredStyle)).setHorizontalAlignment(HorizontalAlignment.LEFT);
        FillerBuilder fillerBuilder = (FillerBuilder)((FillerBuilder)DynamicReports.cmp.filler().setStyle((ReportStyleBuilder)DynamicReports.stl.style().setTopBorder(DynamicReports.stl.pen2Point()))).setFixedHeight(Integer.valueOf(10));
        HorizontalListBuilder horizontalListBuilder2 = null;
        horizontalListBuilder2 = bl ? horizontalListBuilder.add(new ComponentBuilder[]{textFieldBuilder, dynamicReportsComponent}) : horizontalListBuilder.add(new ComponentBuilder[]{textFieldBuilder}).newRow().add(new ComponentBuilder[]{fillerBuilder});
        return horizontalListBuilder2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurrencyValueFormatter
    extends AbstractValueFormatter<String, Number> {
        private static final long serialVersionUID = 1L;
        private final String label;

        public CurrencyValueFormatter(String string) {
            this.label = string;
        }

        public String format(Number number, ReportParameters reportParameters) {
            return this.label + currencyType.valueToString(number, reportParameters.getLocale());
        }
    }

    public static class CurrencyType
    extends BigDecimalType {
        private static final long serialVersionUID = 1L;

        public String getPattern() {
            return "$ #,###.00";
        }
    }
}

