/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.printer.velocity;

import com.github.jtreport.core.TestClassResult;
import com.github.jtreport.core.TestMethodResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintVelocityResult {
    private static final Logger L = LoggerFactory.getLogger(PrintVelocityResult.class);

    public void print(Collection<TestClassResult> collection, String string, String string2, boolean bl) throws IOException {
        for (TestClassResult testClassResult : collection) {
            File file;
            String string3 = testClassResult.getTestClassName();
            int n = testClassResult.getTotalRun();
            int n2 = testClassResult.getTotalFailed();
            int n3 = testClassResult.getTotalIgnored();
            int n4 = testClassResult.getTotalPassed();
            int n5 = testClassResult.getTotalError();
            long l = testClassResult.getRunningTime();
            FileInputStream fileInputStream = new FileInputStream(string);
            if (fileInputStream == null) continue;
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.setProperty("resource.loader", (Object)"class");
            velocityEngine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            velocityEngine.init();
            VelocityContext velocityContext = new VelocityContext();
            String string4 = string3 + new DateTime().toString(ISODateTimeFormat.basicDateTimeNoMillis()) + ".vm";
            String string5 = string2 + string4;
            File file2 = new File(string2);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (!(file = new File(string5)).exists()) {
                file.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            velocityContext.put("testClassName", (Object)string3);
            velocityContext.put("testDate", (Object)new DateTime().toString());
            velocityContext.put("totalDuration", (Object)(l + ""));
            velocityContext.put("totalRun", (Object)n);
            velocityContext.put("totalPassed", (Object)n4);
            velocityContext.put("totalFail", (Object)n2);
            velocityContext.put("totalError", (Object)n5);
            velocityContext.put("totalIgnore", (Object)n3);
            velocityContext.put("summaryDescription", (Object)testClassResult.getDescriptionSummary());
            velocityContext.put("StringEscapeUtils", StringEscapeUtils.class);
            Collection<TestMethodResult> collection2 = testClassResult.getTestMethodResultList();
            if (bl) {
                for (TestMethodResult testMethodResult : collection2) {
                    String string6 = testMethodResult.getTestKey();
                    if (!StringUtils.isNotBlank((String)string6)) continue;
                    velocityContext.put(string6 + "_descriptionComment", (Object)testMethodResult.getTestDescription());
                    velocityContext.put(string6 + "_descriptionResult", (Object)testMethodResult.getDescriptionResult());
                    velocityContext.put(string6 + "_resultDescription", (Object)testMethodResult.getResultDescription());
                    velocityContext.put(string6 + "_testClassName", (Object)testMethodResult.getTestClassName());
                    velocityContext.put(string6 + "_testDisplayName", (Object)testMethodResult.getDescriptionResult().getDisplayName());
                    velocityContext.put(string6 + "_testMethodName", (Object)testMethodResult.getTestMethodName());
                    velocityContext.put(string6 + "_testState", (Object)testMethodResult.getTestState());
                    velocityContext.put(string6 + "_formattdDate", (Object)testMethodResult.getFormattdDate());
                }
            } else {
                velocityContext.put("testList", collection2);
            }
            if (!velocityEngine.evaluate((Context)velocityContext, (Writer)bufferedWriter, string, (Reader)inputStreamReader)) {
                L.error("Failed to convert the template.");
                continue;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }
}

