/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.printer.xml;

import com.github.jtreport.core.TestClassResult;
import com.github.jtreport.printer.core.AbstractPrinterStrategyTemaplate;
import com.github.jtreport.printer.core.Templates;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import net.sf.dynamicreports.jasper.builder.JasperConcatenatedReportBuilder;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.ReportTemplateBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.exception.DRException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrinterXmlStrategy
extends AbstractPrinterStrategyTemaplate {
    private static final Logger L = LoggerFactory.getLogger(PrinterXmlStrategy.class);
    private static final String DEFAULT_TEMPLATE = "xml-template-resources/xmlDatasourceTemplate.xml";

    @Override
    protected void addColumn(JasperReportBuilder jasperReportBuilder) {
    }

    @Override
    protected void addTitle(JasperReportBuilder jasperReportBuilder, String string) {
        jasperReportBuilder.addTitle(new ComponentBuilder[]{Templates.createTitleComponent(string, false)});
    }

    @Override
    public void print(Collection<TestClassResult> collection, String string) {
        for (TestClassResult testClassResult : collection) {
            String string2 = testClassResult.getTestClassName();
            int n = testClassResult.getTotalRun();
            int n2 = testClassResult.getTotalFailed();
            int n3 = testClassResult.getTotalIgnored();
            int n4 = testClassResult.getTotalPassed();
            int n5 = testClassResult.getTotalError();
            long l = testClassResult.getRunningTime();
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_TEMPLATE);
            try {
                if (inputStream != null) {
                    File file;
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    VelocityEngine velocityEngine = new VelocityEngine();
                    velocityEngine.setProperty("resource.loader", (Object)"class");
                    velocityEngine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                    velocityEngine.init();
                    VelocityContext velocityContext = new VelocityContext();
                    String string3 = string2 + new DateTime().toString(ISODateTimeFormat.basicDateTimeNoMillis()) + ".xml";
                    String string4 = string + string3;
                    File file2 = new File(string);
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    if (!(file = new File(string4)).exists()) {
                        file.createNewFile();
                    }
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    velocityContext.put("testClassName", (Object)string2);
                    velocityContext.put("testDate", (Object)new DateTime().toString());
                    velocityContext.put("totalDuration", (Object)(l + ""));
                    velocityContext.put("totalRun", (Object)n);
                    velocityContext.put("totalPassed", (Object)n4);
                    velocityContext.put("totalFail", (Object)n2);
                    velocityContext.put("totalError", (Object)n5);
                    velocityContext.put("totalIgnore", (Object)n3);
                    velocityContext.put("summaryDescription", (Object)testClassResult.getDescriptionSummary());
                    velocityContext.put("StringEscapeUtils", StringEscapeUtils.class);
                    velocityContext.put("testList", testClassResult.getTestMethodResultList());
                    if (!velocityEngine.evaluate((Context)velocityContext, (Writer)bufferedWriter, DEFAULT_TEMPLATE, (Reader)inputStreamReader)) {
                        L.error("Failed to convert the template into xml.");
                        continue;
                    }
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    continue;
                }
                L.error("Template [xml-template-resources/xmlDatasourceTemplate.xml] is null");
            }
            catch (IOException iOException) {
                L.error(iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    @Override
    public void printReport(JasperReportBuilder jasperReportBuilder, OutputStream outputStream) throws DRException {
    }

    @Override
    protected void setBackground(JasperReportBuilder jasperReportBuilder) {
    }

    @Override
    public String setExtension() {
        return null;
    }

    @Override
    protected ReportTemplateBuilder setReportTemplate() {
        return null;
    }

    @Override
    protected void printConcatenateReport(JasperConcatenatedReportBuilder jasperConcatenatedReportBuilder, OutputStream outputStream) throws DRException {
        jasperConcatenatedReportBuilder.toHtml(outputStream);
    }
}

