/*
 * Decompiled with CFR 0.152.
 */
package com.github.jtreport.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTreportUtils {
    private static final Logger L = LoggerFactory.getLogger(JTreportUtils.class);

    public static boolean copyFile(File file, File file2) {
        try {
            return JTreportUtils.copyStream((InputStream)new FileInputStream(file), new FileOutputStream(file2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            L.error("File not found [" + file2 + "]", (Throwable)fileNotFoundException);
            return false;
        }
    }

    private static boolean copyFilesRecusively(File file, File file2) {
        assert (file2.isDirectory());
        if (!file.isDirectory()) {
            return JTreportUtils.copyFile(file, new File(file2, file.getName()));
        }
        File file3 = new File(file2, file.getName());
        if (!file3.exists() && !file3.mkdir()) {
            return false;
        }
        for (File file4 : file.listFiles()) {
            if (JTreportUtils.copyFilesRecusively(file4, file3)) continue;
            return false;
        }
        return true;
    }

    public static boolean copyJarResourcesRecursively(File file, JarURLConnection jarURLConnection) throws IOException {
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            Object object;
            JarEntry jarEntry = enumeration.nextElement();
            if (!jarEntry.getName().startsWith(jarURLConnection.getEntryName())) continue;
            String string = StringUtils.removeStart((String)jarEntry.getName(), (String)jarURLConnection.getEntryName());
            File file2 = new File(file, string);
            if (!jarEntry.isDirectory()) {
                object = jarFile.getInputStream(jarEntry);
                if (!JTreportUtils.copyStream((InputStream)object, file2)) {
                    return false;
                }
                ((InputStream)object).close();
                continue;
            }
            if (JTreportUtils.ensureDirectoryExists(file2)) continue;
            object = "Could not create directory: " + file2.getAbsolutePath();
            L.debug((String)object);
            throw new IOException((String)object);
        }
        return true;
    }

    public static boolean copyResourcesRecursively(URL uRL, File file) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof JarURLConnection) {
                return JTreportUtils.copyJarResourcesRecursively(file, (JarURLConnection)uRLConnection);
            }
            return JTreportUtils.copyFilesRecusively(new File(uRL.getPath()), file);
        }
        catch (IOException iOException) {
            L.error(iOException.getMessage(), (Throwable)iOException);
            return false;
        }
    }

    private static boolean copyStream(InputStream inputStream, File file) {
        try {
            return JTreportUtils.copyStream(inputStream, new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            L.error("File not found [" + file.getAbsolutePath() + "]", (Throwable)fileNotFoundException);
            return false;
        }
    }

    private static boolean copyStream(InputStream inputStream, OutputStream outputStream) {
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            outputStream.close();
            return true;
        }
        catch (IOException iOException) {
            L.error(iOException.getMessage(), (Throwable)iOException);
            return false;
        }
    }

    private static boolean ensureDirectoryExists(File file) {
        return file.exists() || file.mkdir();
    }
}

