/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa;

import com.sun.codemodel.JFieldVar;
import java.lang.reflect.Field;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String[] NUMBERS = new String[]{"BigDecimal", "BigInteger", "String", "byte", "short", "int", "long"};

    public static int toInt(Object maxOccurs) {
        if (maxOccurs instanceof BigInteger) {
            return ((BigInteger)maxOccurs).intValue();
        }
        if (maxOccurs instanceof Integer) {
            return (Integer)maxOccurs;
        }
        throw new IllegalArgumentException("unknown type " + maxOccurs.getClass());
    }

    private static Field getSimpleField(String fieldName, Class<?> clazz) {
        Class<?> tmpClass = clazz;
        try {
            do {
                for (Field field : tmpClass.getDeclaredFields()) {
                    String candidateName = field.getName();
                    if (!candidateName.equals(fieldName)) continue;
                    field.setAccessible(true);
                    return field;
                }
            } while ((tmpClass = tmpClass.getSuperclass()) != null);
        }
        catch (Exception e) {
            System.err.println("krasa-jaxb-tools - Field '" + fieldName + "' not found on class " + clazz);
        }
        return null;
    }

    public static Object getField(String path, Object oo) {
        try {
            if (path.contains(".")) {
                String field = path.substring(0, path.indexOf("."));
                Field declaredField = oo.getClass().getDeclaredField(field);
                declaredField.setAccessible(true);
                Object result = declaredField.get(oo);
                return Utils.getField(path.substring(path.indexOf(".") + 1), result);
            }
            Field simpleField = Utils.getSimpleField(path, oo.getClass());
            simpleField.setAccessible(true);
            return simpleField.get(oo);
        }
        catch (Exception e) {
            System.err.println("krasa-jaxb-tools - Field " + path + " not found on " + oo.getClass().getName());
            return null;
        }
    }

    public static Integer parseInt(String value) {
        try {
            Integer i = Integer.parseInt(value);
            if (i < Integer.MAX_VALUE && i > Integer.MIN_VALUE) {
                return i;
            }
        }
        catch (Exception e) {
            try {
                return (int)Math.round(Double.parseDouble(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean equals(String value, long val) {
        return value.equals(BigInteger.valueOf(val).toString());
    }

    public static boolean isMin(String value) {
        return Utils.equals(value, Long.MIN_VALUE) || Utils.equals(value, Integer.MIN_VALUE);
    }

    public static boolean isMax(String value) {
        return Utils.equals(value, Long.MAX_VALUE) || Utils.equals(value, Integer.MAX_VALUE);
    }

    public static boolean isNumber(JFieldVar field) {
        for (String type : NUMBERS) {
            if (!type.equalsIgnoreCase(field.type().name())) continue;
            return true;
        }
        try {
            if (Utils.isNumber(Class.forName(field.type().fullName()))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected static boolean isNumber(Class<?> aClass) {
        return Number.class.isAssignableFrom(aClass);
    }

    static boolean isCustomType(JFieldVar var) {
        return "JDirectClass".equals(var.type().getClass().getSimpleName());
    }
}

