/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.http;

import com.github.loki4j.client.http.HttpConfig;
import com.github.loki4j.client.http.Loki4jHttpClient;
import com.github.loki4j.client.http.LokiResponse;
import com.github.loki4j.client.util.Loki4jThreadFactory;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class JavaHttpClient
implements Loki4jHttpClient {
    private final HttpConfig conf;
    private final HttpClient client;
    private final HttpRequest.Builder requestBuilder;
    private ExecutorService internalHttpThreadPool;

    public JavaHttpClient(HttpConfig conf) {
        this.conf = conf;
        this.internalHttpThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, conf.java().innerThreadsExpirationMs, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new Loki4jThreadFactory("loki4j-java-http-internal"));
        this.client = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(conf.connectionTimeoutMs)).executor(this.internalHttpThreadPool).build();
        this.requestBuilder = HttpRequest.newBuilder().timeout(Duration.ofMillis(conf.requestTimeoutMs)).uri(URI.create(conf.pushUrl)).header("Content-Type", conf.contentType);
        conf.tenantId.ifPresent(tenant -> this.requestBuilder.setHeader("X-Scope-OrgID", (String)tenant));
        conf.basicAuthToken().ifPresent(token -> this.requestBuilder.setHeader("Authorization", "Basic " + token));
    }

    @Override
    public void close() throws Exception {
        this.internalHttpThreadPool.shutdown();
    }

    @Override
    public LokiResponse send(ByteBuffer batch) throws Exception {
        HttpRequest request = this.requestBuilder.copy().POST(HttpRequest.BodyPublishers.fromPublisher(new BatchPublisher(batch), batch.remaining())).build();
        HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        return new LokiResponse(response.statusCode(), response.body());
    }

    @Override
    public HttpConfig getConfig() {
        return this.conf;
    }

    static class BatchSubscription
    implements Flow.Subscription {
        private final ByteBuffer body;
        private final Flow.Subscriber<? super ByteBuffer> subscriber;
        private volatile boolean cancelled = false;
        private volatile boolean finished = false;

        public BatchSubscription(ByteBuffer body, Flow.Subscriber<? super ByteBuffer> subscriber) {
            this.body = body;
            this.subscriber = subscriber;
        }

        @Override
        public void request(long n) {
            if (this.cancelled || this.finished) {
                return;
            }
            if (n <= 0L) {
                this.subscriber.onError(new IllegalArgumentException("illegal non-positive request:" + n));
            } else {
                this.finished = true;
                this.subscriber.onNext(this.body);
                this.subscriber.onComplete();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }
    }

    static class BatchPublisher
    implements Flow.Publisher<ByteBuffer> {
        private final ByteBuffer body;

        public BatchPublisher(ByteBuffer body) {
            this.body = body;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
            subscriber.onSubscribe(new BatchSubscription(this.body, subscriber));
        }
    }
}

