/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.AttachedNarArtifact;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarInfo;
import com.github.maven_nar.NarLayout;
import com.github.maven_nar.NarManager;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyMojo
extends AbstractNarMojo {
    private ArtifactRepository localRepository;
    protected ArtifactResolver artifactResolver;
    protected List remoteArtifactRepositories;
    protected ArchiverManager archiverManager;

    protected final ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    protected final List getRemoteRepositories() {
        return this.remoteArtifactRepositories;
    }

    protected final ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    protected final NarManager getNarManager() throws MojoFailureException, MojoExecutionException {
        return new NarManager(this.getLog(), this.getLocalRepository(), this.getMavenProject(), this.getArchitecture(), this.getOS(), this.getLinker());
    }

    protected List<Artifact> getArtifacts() {
        try {
            return this.getNarManager().getNarDependencies("compile");
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
        catch (MojoFailureException e) {
            e.printStackTrace();
        }
        return Collections.EMPTY_LIST;
    }

    public final List<NarArtifact> getNarArtifacts() throws MojoExecutionException {
        LinkedList<NarArtifact> narDependencies = new LinkedList<NarArtifact>();
        for (Artifact dependency : this.getArtifacts()) {
            this.getLog().debug((CharSequence)("Examining artifact for NarInfo: " + dependency));
            NarInfo narInfo = this.getNarInfo(dependency);
            if (narInfo == null) continue;
            this.getLog().debug((CharSequence)"    - added as NarDependency");
            narDependencies.add(new NarArtifact(dependency, narInfo));
        }
        this.getLog().debug((CharSequence)("Dependencies contained " + narDependencies.size() + " NAR artifacts."));
        return narDependencies;
    }

    public final NarInfo getNarInfo(Artifact dependency) throws MojoExecutionException {
        NarInfo narInfo;
        dependency.isSnapshot();
        File file = new File(this.getLocalRepository().getBasedir(), this.getLocalRepository().pathOf(dependency));
        if (!file.exists()) {
            this.getLog().debug((CharSequence)("Dependency nar file does not exist: " + file));
            return null;
        }
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            NarInfo info = new NarInfo(dependency.getGroupId(), dependency.getArtifactId(), dependency.getBaseVersion(), this.getLog());
            if (!info.exists(jar)) {
                this.getLog().debug((CharSequence)("Dependency nar file does not contain this artifact: " + file));
                NarInfo narInfo2 = null;
                return narInfo2;
            }
            info.read(jar);
            narInfo = info;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading " + file, (Exception)e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {}
            }
        }
        return narInfo;
    }

    public final List<AttachedNarArtifact> getAllAttachedNarArtifacts(List<NarArtifact> narArtifacts) throws MojoExecutionException, MojoFailureException {
        ArrayList<AttachedNarArtifact> artifactList = new ArrayList<AttachedNarArtifact>();
        for (NarArtifact dependency : narArtifacts) {
            String binding = this.getBinding(dependency);
            artifactList.addAll(this.getAttachedNarArtifacts(dependency, this.getAOL(), binding));
            artifactList.addAll(this.getAttachedNarArtifacts(dependency, null, "noarch"));
        }
        return artifactList;
    }

    protected String getBinding(NarArtifact dependency) throws MojoFailureException, MojoExecutionException {
        String binding = dependency.getNarInfo().getBinding(this.getAOL(), "static");
        return binding;
    }

    private List<AttachedNarArtifact> getAttachedNarArtifacts(NarArtifact dependency, AOL aol, String type) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("GetNarDependencies for " + (Object)((Object)dependency) + ", aol: " + aol + ", type: " + type));
        ArrayList<AttachedNarArtifact> artifactList = new ArrayList<AttachedNarArtifact>();
        NarInfo narInfo = dependency.getNarInfo();
        String[] nars = narInfo.getAttachedNars(aol, type);
        if (nars != null) {
            for (int j = 0; j < nars.length; ++j) {
                this.getLog().debug((CharSequence)("    Checking: " + nars[j]));
                if (nars[j].equals("")) continue;
                String[] nar = nars[j].split(":", 5);
                if (nar.length >= 4) {
                    try {
                        String groupId = nar[0].trim();
                        String artifactId = nar[1].trim();
                        String ext = nar[2].trim();
                        String classifier = nar[3].trim();
                        AOL aolString = narInfo.getAOL(aol);
                        if (aolString != null) {
                            classifier = NarUtil.replace("${aol}", aolString.toString(), classifier);
                        }
                        String version = nar.length >= 5 ? nar[4].trim() : dependency.getVersion();
                        artifactList.add(new AttachedNarArtifact(groupId, artifactId, version, dependency.getScope(), ext, classifier, dependency.isOptional(), dependency.getFile()));
                        continue;
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new MojoExecutionException("Error while reading nar file for dependency " + (Object)((Object)dependency), (Exception)((Object)e));
                    }
                }
                this.getLog().warn((CharSequence)("nars property in " + dependency.getArtifactId() + " contains invalid field: '" + nars[j]));
            }
        }
        return artifactList;
    }

    public final void downloadAttachedNars(List<AttachedNarArtifact> dependencies) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Download for NarDependencies {");
        Iterator<AttachedNarArtifact> i = dependencies.iterator();
        while (i.hasNext()) {
            this.getLog().debug((CharSequence)("  - " + (Object)((Object)i.next())));
        }
        this.getLog().debug((CharSequence)"}");
        for (Artifact artifact : dependencies) {
            try {
                this.getLog().debug((CharSequence)("Resolving " + artifact));
                this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, this.getLocalRepository());
            }
            catch (ArtifactNotFoundException e) {
                String message = "nar not found " + artifact.getId();
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
            catch (ArtifactResolutionException e) {
                String message = "nar cannot resolve " + artifact.getId();
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
        }
    }

    public final void unpackAttachedNars(List<AttachedNarArtifact> dependencies) throws MojoExecutionException, MojoFailureException {
        File unpackDir = this.getUnpackDirectory();
        this.getLog().info((CharSequence)String.format("Unpacking %1$d dependencies to %2$s", dependencies.size(), unpackDir));
        for (AttachedNarArtifact dependency : dependencies) {
            File file = this.getNarManager().getNarFile((Artifact)dependency);
            this.getLog().debug((CharSequence)String.format("Unpack %1$s (%2$s) to %3$s", new Object[]{dependency, file, unpackDir}));
            NarLayout layout = this.getLayout();
            layout.unpackNar(unpackDir, this.archiverManager, file, this.getOS(), this.getLinker().getName(), this.getAOL());
        }
    }

    @Override
    public void narExecute() throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)"Preparing Nar dependencies");
        List<NarArtifact> narArtifacts = this.getNarArtifacts();
        List<AttachedNarArtifact> dependencies = this.getAllAttachedNarArtifacts(narArtifacts);
        this.downloadAttachedNars(dependencies);
        this.unpackAttachedNars(dependencies);
    }
}

