/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.Lib;
import com.github.maven_nar.NarProperties;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.StringTextStream;
import com.github.maven_nar.SysLib;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.LinkerDef;
import com.github.maven_nar.cpptasks.LinkerEnum;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import com.github.maven_nar.cpptasks.types.LinkerArgument;
import com.github.maven_nar.cpptasks.types.SystemLibrarySet;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.Project;
import org.codehaus.plexus.util.FileUtils;

public class Linker {
    private String name;
    private String toolPath;
    private boolean incremental = false;
    private boolean map = false;
    private List options;
    private String optionSet;
    private boolean clearDefaultOptions;
    private List libs;
    private String libSet;
    private List sysLibs;
    private String sysLibSet;
    private String narDependencyLibOrder;
    private final Log log;

    public Linker() {
        this(null);
    }

    public Linker(Log log) {
        this.log = log;
    }

    public Linker(String name, Log log) {
        this.name = name;
        this.log = log;
    }

    public final String getName() {
        return this.name;
    }

    public final String getName(NarProperties properties, String prefix) throws MojoFailureException, MojoExecutionException {
        if (this.name == null && properties != null && prefix != null) {
            this.name = properties.getProperty(prefix + "linker");
        }
        if (this.name == null) {
            throw new MojoExecutionException("NAR: One of two things may be wrong here:\n\n1. <Name> tag is missing inside the <Linker> tag of your NAR configuration\n\n2. no linker is defined in the aol.properties file for '" + prefix + "linker'\n");
        }
        return this.name;
    }

    public final String getVersion() throws MojoFailureException, MojoExecutionException {
        if (this.name == null) {
            throw new MojoFailureException("Cannot deduce linker version if name is null");
        }
        String version = null;
        StringTextStream out = new StringTextStream();
        StringTextStream err = new StringTextStream();
        StringTextStream dbg = new StringTextStream();
        if (this.name.equals("g++") || this.name.equals("gcc")) {
            NarUtil.runCommand("gcc", new String[]{"--version"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("msvc")) {
            NarUtil.runCommand("link", new String[]{"/?"}, null, null, out, err, dbg, this.log, true);
            Pattern p = Pattern.compile("\\d+\\.\\d+\\.\\d+(\\.\\d+)?");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("icc") || this.name.equals("icpc")) {
            NarUtil.runCommand("icc", new String[]{"--version"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)out).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("icl")) {
            NarUtil.runCommand("icl", new String[]{"/QV"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.\\d+");
            Matcher m = p.matcher(((Object)err).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else if (this.name.equals("CC")) {
            NarUtil.runCommand("CC", new String[]{"-V"}, null, null, out, err, dbg, this.log);
            Pattern p = Pattern.compile("\\d+\\.d+");
            Matcher m = p.matcher(((Object)err).toString());
            if (m.find()) {
                version = m.group(0);
            }
        } else {
            throw new MojoFailureException("Cannot find version number for linker '" + this.name + "'");
        }
        if (version == null) {
            throw new MojoFailureException("Cannot deduce version number from: " + ((Object)out).toString());
        }
        return version;
    }

    public final LinkerDef getLinker(AbstractCompileMojo mojo, Project antProject, String os, String prefix, String type) throws MojoFailureException, MojoExecutionException {
        String option;
        LinkerArgument arg;
        if (this.name == null) {
            throw new MojoFailureException("NAR: Please specify a <Name> as part of <Linker>");
        }
        LinkerDef linker = new LinkerDef();
        linker.setProject(antProject);
        LinkerEnum linkerEnum = new LinkerEnum();
        linkerEnum.setValue(this.name);
        linker.setName(linkerEnum);
        if (this.toolPath != null) {
            linker.setToolPath(this.toolPath);
        }
        linker.setIncremental(this.incremental);
        linker.setMap(this.map);
        if (os.equals("Windows") && (type.equals("shared") || type.equals("jni"))) {
            HashSet defs = new HashSet();
            try {
                if (mojo.getC() != null) {
                    List cSrcDirs = mojo.getC().getSourceDirectories();
                    for (File dir : cSrcDirs) {
                        if (!dir.exists()) continue;
                        defs.addAll(FileUtils.getFiles((File)dir, (String)"**/*.def", null));
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (mojo.getCpp() != null) {
                    List cppSrcDirs = mojo.getCpp().getSourceDirectories();
                    for (File dir : cppSrcDirs) {
                        if (!dir.exists()) continue;
                        defs.addAll(FileUtils.getFiles((File)dir, (String)"**/*.def", null));
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (mojo.getFortran() != null) {
                    List fortranSrcDirs = mojo.getFortran().getSourceDirectories();
                    for (File dir : fortranSrcDirs) {
                        if (!dir.exists()) continue;
                        defs.addAll(FileUtils.getFiles((File)dir, (String)"**/*.def", null));
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            Iterator i = defs.iterator();
            while (i.hasNext()) {
                arg = new LinkerArgument();
                arg.setValue("/def:" + i.next());
                linker.addConfiguredLinkerArg(arg);
            }
        }
        if (os.equals("Windows") && this.getName(null, null).equals("msvc") && !this.getVersion().startsWith("6.")) {
            LinkerArgument arg2 = new LinkerArgument();
            arg2.setValue("/MANIFEST");
            linker.addConfiguredLinkerArg(arg2);
        }
        if (this.options != null) {
            Iterator i = this.options.iterator();
            while (i.hasNext()) {
                LinkerArgument arg3 = new LinkerArgument();
                arg3.setValue((String)i.next());
                linker.addConfiguredLinkerArg(arg3);
            }
        }
        if (this.optionSet != null) {
            String[] opts = this.optionSet.split("\\s");
            for (int i = 0; i < opts.length; ++i) {
                arg = new LinkerArgument();
                arg.setValue(opts[i]);
                linker.addConfiguredLinkerArg(arg);
            }
        }
        if (!this.clearDefaultOptions && (option = NarProperties.getInstance(mojo.getMavenProject()).getProperty(prefix + "options")) != null) {
            String[] opt = option.split(" ");
            for (int i = 0; i < opt.length; ++i) {
                LinkerArgument arg4 = new LinkerArgument();
                arg4.setValue(opt[i]);
                linker.addConfiguredLinkerArg(arg4);
            }
        }
        if (this.narDependencyLibOrder != null) {
            LinkedList<String> libOrder = new LinkedList<String>();
            String[] lib = this.narDependencyLibOrder.split(",");
            for (int i = 0; i < lib.length; ++i) {
                libOrder.add(lib[i].trim());
            }
            mojo.setDependencyLibOrder(libOrder);
        }
        if (this.libs != null || this.libSet != null) {
            if (this.libs != null) {
                for (Lib lib : this.libs) {
                    lib.addLibSet(mojo, linker, antProject);
                }
            }
            if (this.libSet != null) {
                this.addLibraries(this.libSet, linker, antProject, false);
            }
        } else {
            String libsList = NarProperties.getInstance(mojo.getMavenProject()).getProperty(prefix + "libs");
            this.addLibraries(libsList, linker, antProject, false);
        }
        if (this.sysLibs != null || this.sysLibSet != null) {
            if (this.sysLibs != null) {
                for (SysLib sysLib : this.sysLibs) {
                    linker.addSyslibset(sysLib.getSysLibSet(antProject));
                }
            }
            if (this.sysLibSet != null) {
                this.addLibraries(this.sysLibSet, linker, antProject, true);
            }
        } else {
            String sysLibsList = NarProperties.getInstance(mojo.getMavenProject()).getProperty(prefix + "sysLibs");
            this.addLibraries(sysLibsList, linker, antProject, true);
        }
        return linker;
    }

    private void addLibraries(String libraryList, LinkerDef linker, Project antProject, boolean isSystem) {
        if (libraryList == null) {
            return;
        }
        String[] lib = libraryList.split(",");
        for (int i = 0; i < lib.length; ++i) {
            String[] libInfo = lib[i].trim().split(":", 3);
            LibrarySet librarySet = new LibrarySet();
            if (isSystem) {
                librarySet = new SystemLibrarySet();
            }
            librarySet.setProject(antProject);
            librarySet.setLibs(new CUtil.StringArrayBuilder(libInfo[0]));
            if (libInfo.length > 1) {
                LibraryTypeEnum libType = new LibraryTypeEnum();
                libType.setValue(libInfo[1]);
                librarySet.setType(libType);
                if (!isSystem && libInfo.length > 2) {
                    librarySet.setDir(new File(libInfo[2]));
                }
            }
            if (!isSystem) {
                linker.addLibset(librarySet);
                continue;
            }
            linker.addSyslibset((SystemLibrarySet)librarySet);
        }
    }
}

