/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractGnuMojo;
import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class NarGnuConfigureMojo
extends AbstractGnuMojo {
    private boolean gnuAutogenSkip;
    private boolean gnuConfigureSkip;
    private String gnuConfigureArgs;
    private String gnuBuildconfArgs;
    private static final String AUTOGEN = "autogen.sh";
    private static final String BUILDCONF = "buildconf";
    private static final String CONFIGURE = "configure";

    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.useGnu()) {
            return;
        }
        File targetDir = this.getGnuAOLSourceDirectory();
        if (this.getGnuSourceDirectory().exists()) {
            this.getLog().info((CharSequence)"Copying GNU sources");
            try {
                FileUtils.mkdir((String)targetDir.getPath());
                NarUtil.copyDirectoryStructure(this.getGnuSourceDirectory(), targetDir, null, null);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy GNU sources", (Exception)e);
            }
            if (!this.gnuConfigureSkip && !this.gnuAutogenSkip) {
                File autogen = new File(targetDir, AUTOGEN);
                File buildconf = new File(targetDir, BUILDCONF);
                if (autogen.exists()) {
                    this.getLog().info((CharSequence)"Running GNU autogen.sh");
                    this.runAutogen(autogen, targetDir, null);
                } else if (buildconf.exists()) {
                    this.getLog().info((CharSequence)"Running GNU buildconf");
                    String[] gnuBuildconfArgsArray = null;
                    if (this.gnuBuildconfArgs != null) {
                        gnuBuildconfArgsArray = this.gnuBuildconfArgs.split("\\s");
                    }
                    this.runAutogen(buildconf, targetDir, gnuBuildconfArgsArray);
                }
            }
            File configure = new File(targetDir, CONFIGURE);
            if (!this.gnuConfigureSkip && configure.exists()) {
                this.getLog().info((CharSequence)"Running GNU configure");
                NarUtil.makeExecutable(configure, this.getLog());
                Object[] args = null;
                if (this.gnuConfigureArgs != null) {
                    String[] a = this.gnuConfigureArgs.split(" ");
                    args = new String[a.length + 2];
                    for (int i = 0; i < a.length; ++i) {
                        args[i + 2] = a[i];
                    }
                } else {
                    args = new String[]{"./" + configure.getName(), "--prefix=" + this.getGnuAOLTargetDirectory().getAbsolutePath()};
                }
                this.getLog().info((CharSequence)("args: " + NarGnuConfigureMojo.arraysToString(args)));
                int result = NarUtil.runCommand("sh", (String[])args, targetDir, null, this.getLog());
                if (result != 0) {
                    throw new MojoExecutionException("'configure' errorcode: " + result);
                }
            }
        }
    }

    private void runAutogen(File autogen, File targetDir, String[] args) throws MojoExecutionException, MojoFailureException {
        File configDir = new File(targetDir, "config");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        NarUtil.makeExecutable(autogen, this.getLog());
        this.getLog().debug((CharSequence)("running sh ./" + autogen.getName()));
        Object[] arguments = null;
        if (args != null) {
            arguments = new String[1 + args.length];
            for (int i = 0; i < args.length; ++i) {
                arguments[i + 1] = args[i];
            }
        } else {
            arguments = new String[]{"./" + autogen.getName()};
        }
        this.getLog().info((CharSequence)("args: " + NarGnuConfigureMojo.arraysToString(arguments)));
        int result = NarUtil.runCommand("sh", (String[])arguments, targetDir, null, this.getLog());
        if (result != 0) {
            throw new MojoExecutionException("'" + autogen.getName() + "' errorcode: " + result);
        }
    }

    private static String arraysToString(Object[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

