/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AOL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class NarInfo {
    public static final String NAR_PROPERTIES = "nar.properties";
    private String groupId;
    private String artifactId;
    private String version;
    private Properties info;
    private Log log;

    public NarInfo(String groupId, String artifactId, String version, Log log) throws MojoExecutionException {
        this(groupId, artifactId, version, log, null);
    }

    public NarInfo(String groupId, String artifactId, String version, Log log, File propertiesFile) throws MojoExecutionException {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.log = log;
        this.info = new Properties();
        if (propertiesFile != null) {
            try {
                this.info.load(new FileInputStream(propertiesFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem loading " + propertiesFile, (Exception)e);
            }
        }
    }

    public final String toString() {
        StringBuffer s = new StringBuffer("NarInfo for ");
        s.append(this.groupId);
        s.append(":");
        s.append(this.artifactId);
        s.append("-");
        s.append(this.version);
        s.append(" {\n");
        for (String string : this.info.keySet()) {
            s.append("   ");
            s.append(string);
            s.append("='");
            s.append(this.info.getProperty(string, "<null>"));
            s.append("'\n");
        }
        s.append("}\n");
        return s.toString();
    }

    public final boolean exists(JarFile jar) {
        return this.getNarPropertiesEntry(jar) != null;
    }

    public final void read(JarFile jar) throws IOException {
        this.info.load(jar.getInputStream(this.getNarPropertiesEntry(jar)));
    }

    private JarEntry getNarPropertiesEntry(JarFile jar) {
        return jar.getJarEntry("META-INF/nar/" + this.groupId + "/" + this.artifactId + "/" + NAR_PROPERTIES);
    }

    public final String getBinding(AOL aol, String defaultBinding) {
        return this.getProperty(aol, "libs.binding", defaultBinding);
    }

    public final void setBinding(AOL aol, String value) {
        this.setProperty(aol, "libs.binding", value);
    }

    public final String getOutput(AOL aol, String defaultOutput) {
        return this.getProperty(aol, "output", defaultOutput);
    }

    public final void setOutput(AOL aol, String value) {
        this.setProperty(aol, "output", value);
    }

    public final String[] getAttachedNars(AOL aol, String type) {
        String attachedNars = this.getProperty(aol, "nar." + type);
        return attachedNars != null ? attachedNars.split(",") : null;
    }

    public final void addNar(AOL aol, String type, String nar) {
        String nars = this.getProperty(aol, "nar." + type);
        nars = nars == null ? nar : nars + ", " + nar;
        this.setProperty(aol, "nar." + type, nars);
    }

    public final void setNar(AOL aol, String type, String nar) {
        this.setProperty(aol, "nar." + type, nar);
    }

    public final AOL getAOL(AOL aol) {
        return aol == null ? null : new AOL(this.getProperty(aol, aol.toString(), aol.toString()));
    }

    public final String getOptions(AOL aol) {
        return this.getProperty(aol, "linker.options");
    }

    public final String getLibs(AOL aol) {
        return this.getProperty(aol, "libs.names", this.getOutput(aol, this.artifactId + "-" + this.version));
    }

    public final String getSysLibs(AOL aol) {
        return this.getProperty(aol, "syslibs.names");
    }

    public final void writeToFile(File file) throws IOException {
        this.info.store(new FileOutputStream(file), "NAR Properties for " + this.groupId + "." + this.artifactId + "-" + this.version);
    }

    private void setProperty(AOL aol, String key, String value) {
        if (aol == null) {
            this.info.setProperty(key, value);
        } else {
            this.info.setProperty(aol.toString() + "." + key, value);
        }
    }

    public final String getProperty(AOL aol, String key) {
        return this.getProperty(aol, key, (String)null);
    }

    public final String getProperty(AOL aol, String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = this.info.getProperty(key, defaultValue);
        value = aol == null ? value : this.info.getProperty(aol.toString() + "." + key, value);
        this.log.debug((CharSequence)("getProperty(" + aol + ", " + key + ", " + defaultValue + ") = " + value));
        return value;
    }

    public final int getProperty(AOL aol, String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(aol, key, Integer.toString(defaultValue)));
    }

    public final boolean getProperty(AOL aol, String key, boolean defaultValue) {
        return new Boolean(this.getProperty(aol, key, String.valueOf(defaultValue)));
    }

    public final File getProperty(AOL aol, String key, File defaultValue) {
        return new File(this.getProperty(aol, key, defaultValue.getPath()));
    }
}

