/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.Library;
import com.github.maven_nar.NarArtifact;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.Test;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class NarTestMojo
extends AbstractCompileMojo {
    private List classpathElements;
    private File testResourceDirectory;

    protected List getArtifacts() {
        return this.getMavenProject().getTestArtifacts();
    }

    protected File getUnpackDirectory() {
        return this.getTestUnpackDirectory() == null ? super.getUnpackDirectory() : this.getTestUnpackDirectory();
    }

    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        super.narExecute();
        Iterator<Object> i = this.getTests().iterator();
        while (i.hasNext()) {
            this.runTest((Test)i.next());
        }
        i = this.getLibraries().iterator();
        while (i.hasNext()) {
            this.runExecutable((Library)i.next());
        }
    }

    private void runTest(Test test) throws MojoExecutionException, MojoFailureException {
        if (test.shouldRun()) {
            String name = test.getName() + (this.getOS().equals("Windows") ? ".exe" : "");
            File path = new File(this.getTestTargetDirectory(), "bin");
            path = new File(path, this.getAOL().toString());
            if (!(path = new File(path, name)).exists()) {
                this.getLog().warn((CharSequence)("Skipping non-existing test " + path));
                return;
            }
            File workingDir = new File(this.getTestTargetDirectory(), "test-reports");
            workingDir.mkdirs();
            try {
                int copied = 0;
                if (this.testResourceDirectory.exists()) {
                    copied += NarUtil.copyDirectoryStructure(this.testResourceDirectory, workingDir, null, "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
                }
                this.getLog().info((CharSequence)("Copied " + copied + " test resources"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("NAR: Could not copy test resources", (Exception)e);
            }
            this.getLog().info((CharSequence)("Running test " + name + " in " + workingDir));
            List args = test.getArgs();
            int result = NarUtil.runCommand(path.toString(), args.toArray(new String[args.size()]), workingDir, this.generateEnvironment(), this.getLog());
            if (result != 0) {
                throw new MojoFailureException("Test " + name + " failed with exit code: " + result + " 0x" + Integer.toHexString(result));
            }
        }
    }

    private void runExecutable(Library library) throws MojoExecutionException, MojoFailureException {
        if (library.getType().equals("executable") && library.shouldRun()) {
            MavenProject project = this.getMavenProject();
            String extension = this.getOS().equals("Windows") ? ".exe" : "";
            File executable = new File(this.getLayout().getBinDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString()), project.getArtifactId() + extension);
            if (!executable.exists()) {
                this.getLog().warn((CharSequence)("Skipping non-existing executable " + executable));
                return;
            }
            this.getLog().info((CharSequence)("Running executable " + executable));
            List args = library.getArgs();
            int result = NarUtil.runCommand(executable.getPath(), args.toArray(new String[args.size()]), null, this.generateEnvironment(), this.getLog());
            if (result != 0) {
                throw new MojoFailureException("Test " + executable + " failed with exit code: " + result + " 0x" + Integer.toHexString(result));
            }
        }
    }

    private String[] generateEnvironment() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> env = new ArrayList<String>();
        HashSet<File> sharedPaths = new HashSet<File>();
        for (Library lib : this.getLibraries()) {
            if (!lib.getType().equals("shared")) continue;
            File path = this.getLayout().getLibDirectory(this.getTargetDirectory(), this.getMavenProject().getArtifactId(), this.getMavenProject().getVersion(), this.getAOL().toString(), lib.getType());
            this.getLog().debug((CharSequence)("Adding path to shared library: " + path));
            sharedPaths.add(path);
        }
        String classifier = this.getAOL() + "-shared";
        List<NarArtifact> narArtifacts = this.getNarArtifacts();
        List dependencies = this.getNarManager().getAttachedNarDependencies(narArtifacts, classifier);
        for (Artifact dependency : dependencies) {
            this.getLog().debug((CharSequence)("Looking for dependency " + dependency));
            dependency.isSnapshot();
            File libDirectory = this.getLayout().getLibDirectory(this.getUnpackDirectory(), dependency.getArtifactId(), dependency.getVersion(), this.getAOL().toString(), "shared");
            sharedPaths.add(libDirectory);
        }
        if (sharedPaths.size() > 0) {
            String sharedPath = "";
            Iterator i = sharedPaths.iterator();
            while (i.hasNext()) {
                sharedPath = sharedPath + ((File)i.next()).getPath();
                if (!i.hasNext()) continue;
                sharedPath = sharedPath + File.pathSeparator;
            }
            String sharedEnv = NarUtil.addLibraryPathToEnv(sharedPath, null, this.getOS());
            env.add(sharedEnv);
        }
        if (this.getOS().equals("Windows")) {
            env.add("SystemRoot=" + NarUtil.getEnv("SystemRoot", "SystemRoot", "C:\\Windows"));
        }
        env.add("CLASSPATH=" + StringUtils.join(this.classpathElements.iterator(), (String)File.pathSeparator));
        return env.size() > 0 ? env.toArray(new String[env.size()]) : null;
    }
}

