/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.devstudio;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.devstudio.DevStudioLinker;
import com.github.maven_nar.cpptasks.devstudio.DevStudioProcessor;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public final class DevStudioMIDLCompiler
extends CommandLineCompiler {
    private static final DevStudioMIDLCompiler instance = new DevStudioMIDLCompiler(false, null);

    public static DevStudioMIDLCompiler getInstance() {
        return instance;
    }

    private DevStudioMIDLCompiler(boolean newEnvironment, Environment env) {
        super("midl", null, new String[]{".idl", ".odl"}, new String[0], ".tlb", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
    }

    protected void addWarningSwitch(Vector args, int level) {
        DevStudioProcessor.addWarningSwitch(args, level);
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new DevStudioMIDLCompiler(newEnvironment, env);
        }
        return this;
    }

    protected Parser createParser(File source) {
        return new CParser();
    }

    protected int getArgumentCountPerInputFile() {
        return 3;
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        DevStudioProcessor.getDefineSwitch(buffer, define, value);
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return DevStudioProcessor.getIncludeDirSwitch(includeDir);
    }

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        switch (index) {
            case 0: {
                return "/tlb";
            }
            case 1: {
                return new File(outputDir, this.getOutputFileNames(filename, null)[0]).getAbsolutePath();
            }
        }
        return filename;
    }

    public Linker getLinker(LinkType type) {
        return DevStudioLinker.getInstance().getLinker(type);
    }

    public int getMaximumCommandLength() {
        return 32000;
    }

    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        String arg1 = this.getInputFileArgument(outputDir, inputFile, 0);
        String arg2 = this.getInputFileArgument(outputDir, inputFile, 1);
        String arg3 = this.getInputFileArgument(outputDir, inputFile, 2);
        return arg1.length() + arg2.length() + arg3.length() + 3;
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        DevStudioProcessor.getUndefineSwitch(buffer, define);
    }
}

